/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.glsl.node.primary;

import foundry.veil.impl.glsl.node.GlslConstantNode;
import foundry.veil.impl.glsl.node.primary.GlslIntFormat;

public record GlslIntConstantNode(GlslIntFormat format, boolean signed, int value) implements GlslConstantNode
{
    @Override
    public Number numberValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public boolean booleanValue() {
        return (double)this.value != 0.0;
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public String getSourceString() {
        return switch (this.format) {
            default -> throw new MatchException(null, null);
            case GlslIntFormat.HEXADECIMAL -> "0x" + Integer.toHexString(this.value) + (this.signed ? "" : "u");
            case GlslIntFormat.OCTAL -> Integer.toOctalString(this.value) + (this.signed ? "" : "u");
            case GlslIntFormat.DECIMAL -> this.value + (this.signed ? "" : "u");
        };
    }

    @Override
    public String toString() {
        return this.getSourceString();
    }
}

