/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import foundry.veil.Veil;
import foundry.veil.VeilClient;
import foundry.veil.api.client.editor.SingleWindowEditor;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.client.registry.VeilResourceEditorRegistry;
import foundry.veil.api.resource.VeilEditorEnvironment;
import foundry.veil.api.resource.VeilResource;
import foundry.veil.api.resource.VeilResourceAction;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.api.resource.VeilResourceManager;
import foundry.veil.api.resource.editor.ResourceFileEditor;
import foundry.veil.impl.resource.VeilPackResources;
import foundry.veil.impl.resource.VeilResourceManagerImpl;
import foundry.veil.impl.resource.VeilResourceRenderer;
import foundry.veil.impl.resource.tree.VeilResourceFolder;
import imgui.ImGui;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5348;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ResourceManagerEditor
extends SingleWindowEditor
implements VeilEditorEnvironment {
    public static final class_2561 TITLE = class_2561.method_43471((String)"editor.veil.resource.title");
    private static final class_2561 RELOAD_BUTTON = class_2561.method_43471((String)"editor.veil.resource.button.reload");
    private static final class_2561 COPY_PATH = class_2561.method_43471((String)"editor.veil.resource.action.copy_path");
    private static final class_2561 OPEN_FOLDER = class_2561.method_43471((String)"editor.veil.resource.action.open_folder");
    private VeilResource<?> contextResource;
    private List<? extends VeilResourceAction<?>> actions;
    private CompletableFuture<?> reloadFuture;

    @Override
    public void renderComponents() {
        this.contextResource = null;
        this.actions = Collections.emptyList();
        ImGui.beginDisabled((this.reloadFuture != null && !this.reloadFuture.isDone() ? 1 : 0) != 0);
        if (ImGui.button((String)RELOAD_BUTTON.getString())) {
            this.reloadFuture = class_310.method_1551().method_1521();
        }
        ImGui.endDisabled();
        VeilResourceManagerImpl resourceManager = VeilClient.resourceManager();
        if (ImGui.beginListBox((String)"##file_tree", (float)ImGui.getContentRegionAvailX(), (float)ImGui.getContentRegionAvailY())) {
            List<VeilPackResources> packs = resourceManager.getAllPacks();
            for (int i = packs.size() - 1; i >= 0; --i) {
                VeilPackResources pack = packs.get(i);
                String modid = pack.getName();
                int color = VeilImGuiUtil.colorOf(modid);
                boolean open = ImGui.treeNodeEx((String)("##" + modid), (int)2048);
                ImGui.pushStyleColor((int)0, (int)color);
                ImGui.sameLine();
                int icon = pack.getTexture();
                if (icon != 0) {
                    float size = ImGui.getTextLineHeight();
                    ImGui.image((int)icon, (float)size, (float)size);
                } else {
                    VeilImGuiUtil.icon(60029, color);
                }
                ImGui.sameLine();
                ImGui.text((String)modid);
                ImGui.popStyleColor();
                if (open) {
                    this.renderFolderContents(pack.getRoot());
                    ImGui.treePop();
                }
                ImGui.separator();
            }
            ImGui.endListBox();
        }
    }

    private void renderFolder(VeilResourceFolder folder) {
        boolean open = ImGui.treeNodeEx((String)("##" + folder.getName()), (int)2048);
        ImGui.sameLine();
        VeilImGuiUtil.icon(open ? 60783 : 62523);
        ImGui.sameLine();
        ImGui.text((String)folder.getName());
        if (open) {
            this.renderFolderContents(folder);
            ImGui.treePop();
        }
    }

    private void renderFolderContents(VeilResourceFolder folder) {
        for (VeilResourceFolder veilResourceFolder : folder.getSubFolders()) {
            this.renderFolder(veilResourceFolder);
        }
        ImGui.indent();
        for (VeilResource veilResource : folder.getResources()) {
            VeilResourceInfo info = veilResource.resourceInfo();
            if (info.hidden()) continue;
            ImGui.selectable((String)("##" + String.valueOf(veilResource.resourceInfo().location())));
            ImGui.setItemAllowOverlap();
            ImGui.sameLine();
            VeilResourceRenderer.renderFilename(veilResource);
            if (!ImGui.beginPopupContextItem((String)String.valueOf(veilResource.resourceInfo().location()))) continue;
            if (veilResource != this.contextResource) {
                this.contextResource = veilResource;
                this.actions = veilResource.getActions();
            }
            if (ImGui.selectable((String)"##copy_path")) {
                ImGui.setClipboardText((String)info.location().toString());
            }
            ImGui.pushStyleVar((int)14, (float)0.0f, (float)0.0f);
            ImGui.setItemAllowOverlap();
            ImGui.sameLine();
            VeilImGuiUtil.icon(60305);
            ImGui.sameLine();
            ImGui.popStyleVar();
            VeilImGuiUtil.component((class_5348)COPY_PATH);
            ImGui.beginDisabled((boolean)info.isStatic());
            if (ImGui.selectable((String)"##open_folder")) {
                Path file;
                Path path = file = info.modResourcePath() != null ? info.modResourcePath() : info.filePath();
                if (file.getParent() != null) {
                    class_156.method_668().method_672(file.getParent().toFile());
                }
            }
            ImGui.pushStyleVar((int)14, (float)0.0f, (float)0.0f);
            ImGui.setItemAllowOverlap();
            ImGui.sameLine();
            VeilImGuiUtil.icon(60591);
            ImGui.sameLine();
            ImGui.popStyleVar();
            VeilImGuiUtil.component((class_5348)OPEN_FOLDER);
            ImGui.endDisabled();
            for (int i = 0; i < this.actions.size(); ++i) {
                VeilResourceAction<?> action = this.actions.get(i);
                if (ImGui.selectable((String)("##action" + i))) {
                    action.perform(this, veilResource);
                }
                ImGui.pushStyleVar((int)14, (float)0.0f, (float)0.0f);
                ImGui.setItemAllowOverlap();
                ImGui.sameLine();
                action.getIcon().ifPresent(icon -> {
                    VeilImGuiUtil.icon(icon);
                    ImGui.sameLine();
                });
                ImGui.popStyleVar();
                VeilImGuiUtil.component((class_5348)action.getName());
            }
            ImGui.endPopup();
        }
        ImGui.unindent();
    }

    @Override
    public class_2561 getDisplayName() {
        return TITLE;
    }

    @Override
    public class_2561 getGroup() {
        return RESOURCE_GROUP;
    }

    @Override
    public void open(VeilResource<?> resource, class_2960 editorName) {
        ResourceFileEditor editor = (ResourceFileEditor)VeilResourceEditorRegistry.REGISTRY.method_10223(editorName);
        if (editor == null) {
            Veil.LOGGER.error("Failed to find editor for resource: {}", (Object)resource.resourceInfo().location());
            return;
        }
        try {
            this.open(editor, resource);
        }
        catch (Throwable t) {
            Veil.LOGGER.error("Failed to open editor for resource: {}", (Object)resource.resourceInfo().location(), (Object)t);
        }
    }

    private <T extends VeilResource<?>> void open(ResourceFileEditor<T> editor, VeilResource<?> resource) {
        editor.open(this, resource);
    }

    @Override
    public VeilResourceManager getResourceManager() {
        return VeilClient.resourceManager();
    }
}

