/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.deferred;

import foundry.veil.Veil;
import foundry.veil.VeilClient;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.FramebufferManager;
import foundry.veil.api.client.render.post.PostPipeline;
import foundry.veil.api.client.render.post.PostProcessingManager;
import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.client.render.shader.definition.ShaderPreDefinitions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_5250;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.system.NativeResource;

public class VeilDeferredRenderer
implements class_3302,
NativeResource {
    public static final class_2960 PACK_ID = Veil.veilPath("deferred");
    public static final String DISABLE_VANILLA_ENTITY_LIGHT_KEY = "DISABLE_VANILLA_ENTITY_LIGHT";
    public static final class_2960 OPAQUE_POST = Veil.veilPath("core/opaque");
    public static final class_2960 LIGHT_POST = Veil.veilPath("core/light");
    public static final class_2960 OPAQUE_MIX = Veil.veilPath("core/mix_opaque");
    public static final class_2960 TRANSPARENT_MIX = Veil.veilPath("core/mix_transparent");
    public static final class_2960 TRANSPARENT_POST = Veil.veilPath("core/transparent");
    public static final class_2960 SCREEN_POST = Veil.veilPath("core/screen");
    public static final class_5250 UNSUPPORTED_TITLE = class_2561.method_43471((String)"veil.deferred.unsupported.title");
    public static final class_5250 UNSUPPORTED_SODIUM_DESC = class_2561.method_43471((String)"veil.deferred.unsupported.sodium_desc");
    public static final class_5250 UNSUPPORTED_FABULOUS_DESC = class_2561.method_43471((String)"veil.deferred.unsupported.fabulous_desc");
    private final ShaderManager deferredShaderManager;
    private final ShaderPreDefinitions shaderPreDefinitions;
    private final FramebufferManager framebufferManager;
    private final PostProcessingManager postProcessingManager;
    private boolean enabled;
    private RendererState state;

    public VeilDeferredRenderer(ShaderManager deferredShaderManager, ShaderPreDefinitions shaderPreDefinitions, FramebufferManager framebufferManager, PostProcessingManager postProcessingManager) {
        this.deferredShaderManager = deferredShaderManager;
        this.shaderPreDefinitions = shaderPreDefinitions;
        this.framebufferManager = framebufferManager;
        this.postProcessingManager = postProcessingManager;
        this.enabled = false;
        this.state = RendererState.INACTIVE;
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.supplyAsync(() -> {
            boolean active;
            boolean selected = class_310.method_1551().method_1520().method_29210().contains(PACK_ID.toString()) || resourceManager.method_29213().anyMatch(pack -> pack.method_14409().equals(PACK_ID.toString()));
            boolean bl = active = selected && VeilDeferredRenderer.isSupported();
            if (selected && class_310.method_29611()) {
                class_370.method_27024((class_374)class_310.method_1551().method_1566(), (class_370.class_9037)VeilClient.UNSUPPORTED_NOTIFICATION, (class_2561)UNSUPPORTED_TITLE, (class_2561)UNSUPPORTED_FABULOUS_DESC);
            }
            if (this.enabled != active) {
                this.enabled = active;
                if (active) {
                    Veil.LOGGER.info("Deferred Renderer Enabled");
                } else {
                    Veil.LOGGER.info("Deferred Renderer Disabled");
                    return preparationBarrier.method_18352(null).thenRunAsync(this::free, gameExecutor);
                }
            }
            if (this.enabled) {
                return this.deferredShaderManager.method_25931(preparationBarrier, resourceManager, prepareProfiler, applyProfiler, backgroundExecutor, gameExecutor);
            }
            return preparationBarrier.method_18352(null);
        }, gameExecutor).thenCompose(future -> future);
    }

    public void free() {
        this.enabled = false;
        this.state = RendererState.INACTIVE;
        this.deferredShaderManager.close();
    }

    @ApiStatus.Internal
    public void setup() {
    }

    @ApiStatus.Internal
    public void clear() {
    }

    @ApiStatus.Internal
    public void beginOpaque() {
    }

    @ApiStatus.Internal
    public void beginTranslucent() {
    }

    private void run(class_3695 profiler, AdvancedFbo deferred, AdvancedFbo light, class_2960 post, class_2960 mix) {
        PostPipeline mixPipeline;
        PostPipeline postPipeline = this.postProcessingManager.getPipeline(post);
        if (postPipeline != null) {
            profiler.method_15396("post");
            this.postProcessingManager.runPipeline(postPipeline, false);
            profiler.method_15407();
        }
        profiler.method_15396("draw_lights");
        light.bind(true);
        profiler.method_15407();
        PostPipeline lightPipeline = this.postProcessingManager.getPipeline(LIGHT_POST);
        if (lightPipeline != null) {
            profiler.method_15396("light_post");
            this.postProcessingManager.runPipeline(lightPipeline, false);
            profiler.method_15407();
        }
        if ((mixPipeline = this.postProcessingManager.getPipeline(mix)) != null) {
            profiler.method_15396("mix");
            this.postProcessingManager.runPipeline(mixPipeline, false);
            profiler.method_15407();
        }
    }

    @ApiStatus.Internal
    public void end() {
        if (!this.isEnabled() || this.state == RendererState.DISABLED) {
            return;
        }
        this.state = RendererState.INACTIVE;
    }

    public void enable() {
        this.state = RendererState.INACTIVE;
    }

    public void disable() {
        this.state = RendererState.DISABLED;
    }

    public boolean isEnabled() {
        return this.enabled && VeilDeferredRenderer.isSupported();
    }

    public static boolean isSupported() {
        return !class_310.method_29611() && !Veil.SODIUM;
    }

    public boolean isActive() {
        return this.isEnabled() && this.state.isActive();
    }

    public RendererState getRendererState() {
        return this.state;
    }

    public ShaderManager getDeferredShaderManager() {
        return this.deferredShaderManager;
    }

    public static enum RendererState {
        DISABLED,
        INACTIVE,
        OPAQUE,
        TRANSLUCENT;


        public boolean isActive() {
            return this == OPAQUE || this == TRANSLUCENT;
        }
    }
}

