package foundry.veil.mixin.client.pipeline;

import foundry.veil.api.client.render.rendertype.VeilRenderTypeBuilder;
import foundry.veil.ext.CompositeStateExtension;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1921;
import net.minecraft.class_4668;

@Mixin(class_1921.class_4688.class_4689.class)
public abstract class CompositeStateBuilderMixin implements VeilRenderTypeBuilder {

    @Shadow
    public abstract class_1921.class_4688.class_4689 setTextureState(class_4668.class_5939 emptyTextureStateShard);

    @Shadow
    public abstract class_1921.class_4688.class_4689 setShaderState(class_4668.class_5942 shaderStateShard);

    @Shadow
    public abstract class_1921.class_4688.class_4689 setTransparencyState(class_4668.class_4685 transparencyStateShard);

    @Shadow
    public abstract class_1921.class_4688.class_4689 setDepthTestState(class_4668.class_4672 depthTestStateShard);

    @Shadow
    public abstract class_1921.class_4688.class_4689 setLightmapState(class_4668.class_4676 lightmapStateShard);

    @Shadow
    public abstract class_1921.class_4688.class_4689 setCullState(class_4668.class_4671 cullStateShard);

    @Shadow
    public abstract class_1921.class_4688.class_4689 setOverlayState(class_4668.class_4679 overlayStateShard);

    @Shadow
    public abstract class_1921.class_4688.class_4689 setLayeringState(class_4668.class_4675 layeringStateShard);

    @Shadow
    public abstract class_1921.class_4688.class_4689 setOutputState(class_4668.class_4678 outputStateShard);

    @Shadow
    public abstract class_1921.class_4688.class_4689 setTexturingState(class_4668.class_4684 texturingStateShard);

    @Shadow
    public abstract class_1921.class_4688.class_4689 setWriteMaskState(class_4668.class_4686 writeMaskStateShard);

    @Shadow
    public abstract class_1921.class_4688.class_4689 setLineState(class_4668.class_4677 lineStateShard);

    @Shadow
    public abstract class_1921.class_4688.class_4689 setColorLogicState(class_4668.class_8559 colorLogicStateShard);

    @Shadow
    public abstract class_1921.class_4688 createCompositeState(class_1921.class_4750 outlineProperty);

    @Unique
    private List<class_4668> veil$layers;

    @Override
    public VeilRenderTypeBuilder textureState(class_4668.class_5939 state) {
        this.setTextureState(state);
        return this;
    }

    @Override
    public VeilRenderTypeBuilder shaderState(class_4668.class_5942 state) {
        this.setShaderState(state);
        return this;
    }

    @Override
    public VeilRenderTypeBuilder transparencyState(class_4668.class_4685 state) {
        this.setTransparencyState(state);
        return this;
    }

    @Override
    public VeilRenderTypeBuilder depthTestState(class_4668.class_4672 state) {
        this.setDepthTestState(state);
        return this;
    }

    @Override
    public VeilRenderTypeBuilder cullState(class_4668.class_4671 state) {
        this.setCullState(state);
        return this;
    }

    @Override
    public VeilRenderTypeBuilder lightmapState(class_4668.class_4676 state) {
        this.setLightmapState(state);
        return this;
    }

    @Override
    public VeilRenderTypeBuilder overlayState(class_4668.class_4679 state) {
        this.setOverlayState(state);
        return this;
    }

    @Override
    public VeilRenderTypeBuilder layeringState(class_4668.class_4675 state) {
        this.setLayeringState(state);
        return this;
    }

    @Override
    public VeilRenderTypeBuilder outputState(class_4668.class_4678 state) {
        this.setOutputState(state);
        return this;
    }

    @Override
    public VeilRenderTypeBuilder texturingState(class_4668.class_4684 state) {
        this.setTexturingState(state);
        return this;
    }

    @Override
    public VeilRenderTypeBuilder writeMaskState(class_4668.class_4686 state) {
        this.setWriteMaskState(state);
        return this;
    }

    @Override
    public VeilRenderTypeBuilder lineState(class_4668.class_4677 state) {
        this.setLineState(state);
        return this;
    }

    @Override
    public VeilRenderTypeBuilder colorLogicState(class_4668.class_8559 state) {
        this.setColorLogicState(state);
        return this;
    }

    @Override
    public VeilRenderTypeBuilder addLayer(class_4668 shard) {
        if (this.veil$layers == null) {
            this.veil$layers = new LinkedList<>();
        }
        this.veil$layers.add(shard);
        return this;
    }

    @Override
    public class_1921.class_4688 create(class_1921.class_4750 outlineProperty) {
        return this.createCompositeState(outlineProperty);
    }

    @Inject(method = "createCompositeState(Lnet/minecraft/client/renderer/RenderType$OutlineProperty;)Lnet/minecraft/client/renderer/RenderType$CompositeState;", at = @At("RETURN"))
    public void addLayers(class_1921.class_4750 $$0, CallbackInfoReturnable<class_1921.class_4688> cir) {
        if (this.veil$layers != null) {
            ((CompositeStateExtension) (Object) cir.getReturnValue()).veil$addShards(this.veil$layers);
        }
    }
}
