package foundry.veil.mixin.client.dynamicbuffer;

import com.mojang.blaze3d.platform.GlStateManager;
import foundry.veil.Veil;
import foundry.veil.ext.ShaderInstanceExtension;
import foundry.veil.impl.client.render.dynamicbuffer.VanillaShaderCompiler;
import foundry.veil.mixin.accessor.ProgramAccessor;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.class_281;
import net.minecraft.class_284;
import net.minecraft.class_285;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3679;
import net.minecraft.class_5912;
import net.minecraft.class_5944;

import static org.lwjgl.opengl.GL20C.*;

@Mixin(class_5944.class)
public abstract class ShaderInstanceMixin implements class_3679, ShaderInstanceExtension {

    @Shadow
    private static class_281 getOrCreate(class_5912 resourceProvider, class_281.class_282 programType, String name) throws IOException {
        return null;
    }

    @Mutable
    @Shadow
    @Final
    private class_281 vertexProgram;

    @Mutable
    @Shadow
    @Final
    private class_281 fragmentProgram;

    @Shadow
    @Final
    private int programId;

    @Shadow
    @Final
    private class_293 vertexFormat;

    @Shadow
    protected abstract void updateLocations();

    @Shadow
    @Final
    public Map<String, class_284> uniformMap;

    @Shadow
    @Final
    private List<Integer> uniformLocations;

    @Shadow
    @Final
    private List<Integer> samplerLocations;

    @Shadow
    @Final
    private String name;
    @Unique
    private String veil$vertexSource;
    @Unique
    private String veil$fragmentSource;

    @Inject(method = "apply", at = @At("HEAD"))
    public void apply(CallbackInfo ci) {
        VanillaShaderCompiler.markRendered(this.name);
        if (this.veil$vertexSource != null && this.veil$fragmentSource != null) {
            try {
                ProgramAccessor vertexAccessor = (ProgramAccessor) this.vertexProgram;
                ProgramAccessor fragmentAccessor = (ProgramAccessor) this.fragmentProgram;

                glDetachShader(this.programId, vertexAccessor.getId());
                glDetachShader(this.programId, fragmentAccessor.getId());

                GlStateManager.glShaderSource(vertexAccessor.getId(), List.of(this.veil$vertexSource));
                GlStateManager.glCompileShader(vertexAccessor.getId());
                if (GlStateManager.glGetShaderi(vertexAccessor.getId(), GL_COMPILE_STATUS) == 0) {
                    String error = StringUtils.trim(glGetShaderInfoLog(vertexAccessor.getId()));
                    throw new IOException("Couldn't compile vertex program (" + this.vertexProgram.method_1280() + ", " + this.name + ") : " + error);
                }

                GlStateManager.glShaderSource(fragmentAccessor.getId(), List.of(this.veil$fragmentSource));
                GlStateManager.glCompileShader(fragmentAccessor.getId());
                if (GlStateManager.glGetShaderi(fragmentAccessor.getId(), GL_COMPILE_STATUS) == 0) {
                    String error = StringUtils.trim(glGetShaderInfoLog(fragmentAccessor.getId()));
                    throw new IOException("Couldn't compile fragment program (" + this.fragmentProgram.method_1280() + ", " + this.name + ") : " + error);
                }

                int i = 0;
                for (String name : this.vertexFormat.method_34445()) {
                    class_284.method_34419(this.programId, i, name);
                    i++;
                }

                this.uniformLocations.clear();
                this.samplerLocations.clear();
                this.uniformMap.clear();

                // Force re-link
                class_285.method_1307(this);
                this.updateLocations();

                this.method_1279();
            } catch (Throwable t) {
                Veil.LOGGER.error("Failed to recompile vanilla shader: {}", this.name, t);
            }
            this.veil$vertexSource = null;
            this.veil$fragmentSource = null;
        }
    }

    @Override
    public Collection<class_2960> veil$getShaderSources() {
        // TODO probably extra code for iris/sodium needed
        class_2960 vertexProgramName = class_2960.method_60654(this.vertexProgram.method_1280());
        class_2960 fragmentProgramName = class_2960.method_60654(this.fragmentProgram.method_1280());
        class_2960 vertexPath = class_2960.method_60655(vertexProgramName.method_12836(), "shaders/core/" + vertexProgramName.method_12832() + class_281.class_282.field_1530.method_1284());
        class_2960 fragmentPath = class_2960.method_60655(fragmentProgramName.method_12836(), "shaders/core/" + fragmentProgramName.method_12832() + class_281.class_282.field_1531.method_1284());
        return List.of(vertexPath, fragmentPath);
    }

    @Override
    public void veil$recompile(boolean vertex, String source) {
        if (vertex) {
            this.veil$vertexSource = source;
        } else {
            this.veil$fragmentSource = source;
        }
    }
}
