package foundry.veil.api.client.anim;

import foundry.veil.api.client.util.Easings;
import net.minecraft.class_243;

public class Frame {
    class_243 position;
    class_243 rotation;
    class_243 scale;

    public Frame(class_243 position, class_243 rotation, class_243 scale) {
        this.position = position;
        this.rotation = rotation;
        this.scale = scale;
    }

    public class_243 getPosition() {
        return position;
    }

    public class_243 getRotation() {
        return rotation;
    }

    public class_243 getScale() {
        return scale;
    }

    public Frame copy() {
        return new Frame(position, rotation, scale);
    }

    public Frame interpolate(Frame frame, float progress, Easings.Easing easing) {
        class_243 position = this.position.method_1019(frame.position.method_1020(this.position).method_1021(easing.ease(progress)));
        class_243 rotation = this.rotation.method_1019(frame.rotation.method_1020(this.rotation).method_1021(easing.ease(progress)));
        class_243 scale = this.scale.method_1019(frame.scale.method_1020(this.scale).method_1021(easing.ease(progress)));
        return new Frame(position, rotation, scale);
    }

    public Frame bezierInterpolate(Frame frame, float progress, Easings.Easing easing) {
        // interpolate from this to frame using a bezier curve
        // https://en.wikipedia.org/wiki/B%C3%A9zier_curve#Cubic_B%C3%A9zier_curves
        class_243 p0 = this.position;
        class_243 p1 = this.position.method_1019(this.rotation);
        class_243 p2 = frame.position.method_1019(frame.rotation);
        class_243 p3 = frame.position;
        class_243 position = p0.method_1021((float) Math.pow(1 - progress, 3))
                .method_1019(p1.method_1021(3 * progress * (float) Math.pow(1 - progress, 2)))
                .method_1019(p2.method_1021(3 * (float) Math.pow(progress, 2) * (1 - progress)))
                .method_1019(p3.method_1021((float) Math.pow(progress, 3)));
        class_243 r0 = this.rotation;
        class_243 r1 = this.rotation.method_1019(this.scale);
        class_243 r2 = frame.rotation.method_1019(frame.scale);
        class_243 r3 = frame.rotation;
        class_243 rotation = r0.method_1021((float) Math.pow(1 - progress, 3))
                .method_1019(r1.method_1021(3 * progress * (float) Math.pow(1 - progress, 2)))
                .method_1019(r2.method_1021(3 * (float) Math.pow(progress, 2) * (1 - progress)))
                .method_1019(r3.method_1021((float) Math.pow(progress, 3)));
        class_243 s0 = this.scale;
        class_243 s1 = this.scale.method_1019(this.position);
        class_243 s2 = frame.scale.method_1019(frame.position);
        class_243 s3 = frame.scale;
        class_243 scale = s0.method_1021((float) Math.pow(1 - progress, 3))
                .method_1019(s1.method_1021(3 * progress * (float) Math.pow(1 - progress, 2)))
                .method_1019(s2.method_1021(3 * (float) Math.pow(progress, 2) * (1 - progress)))
                .method_1019(s3.method_1021((float) Math.pow(progress, 3)));
        return new Frame(position, rotation, scale);
    }
}
