/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.glsl.node.expression;

import foundry.veil.impl.glsl.grammar.GlslSpecifiedType;
import foundry.veil.impl.glsl.node.GlslNode;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class GlslUnaryNode
implements GlslNode {
    private GlslNode expression;
    private Operand operand;

    public GlslUnaryNode(GlslNode expression, Operand operand) {
        this.expression = expression;
        this.operand = operand;
    }

    @Override
    @Nullable
    public GlslSpecifiedType getType() {
        return this.expression.getType();
    }

    @Override
    public Stream<GlslNode> stream() {
        return Stream.concat(Stream.of(this), this.expression.stream());
    }

    public GlslNode getExpression() {
        return this.expression;
    }

    public Operand getOperand() {
        return this.operand;
    }

    public GlslUnaryNode setExpression(GlslNode expression) {
        this.expression = expression;
        return this;
    }

    public GlslUnaryNode setOperand(Operand operand) {
        this.operand = operand;
        return this;
    }

    public String toString() {
        return "GlslUnaryNode{expression=" + String.valueOf(this.expression) + ", operand=" + String.valueOf((Object)this.operand) + "}";
    }

    @Override
    public String getSourceString() {
        return switch (this.operand.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1, 4, 5, 6, 7 -> this.operand.getDelimiter() + this.expression.getSourceString();
            case 2, 3 -> this.expression.getSourceString() + this.operand.getDelimiter();
        };
    }

    public static enum Operand {
        PRE_INCREMENT("++"),
        PRE_DECREMENT("--"),
        POST_INCREMENT("++"),
        POST_DECREMENT("--"),
        PLUS("+"),
        DASH("-"),
        BANG("!"),
        TILDE("~");

        private final String delimiter;

        private Operand(String delimiter) {
            this.delimiter = delimiter;
        }

        public String getDelimiter() {
            return this.delimiter;
        }
    }
}

