/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.client.render.shader.definition.ShaderPreDefinitions;
import foundry.veil.api.client.render.shader.processor.ShaderCustomProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderModifyProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderPreProcessor;
import foundry.veil.api.client.render.shader.program.ProgramDefinition;
import foundry.veil.impl.client.render.dynamicbuffer.DynamicBufferProcessor;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_5912;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class SimpleShaderProcessor {
    private static final ThreadLocal<ShaderPreProcessor> PROCESSOR = new ThreadLocal();

    public static void setup(class_5912 resourceProvider) {
        int activeBuffers = VeilRenderSystem.renderer().getDynamicBufferManger().getActiveBuffers();
        PROCESSOR.set(ShaderPreProcessor.allOf(new ShaderModifyProcessor(), new ShaderCustomProcessor(resourceProvider), new DynamicBufferProcessor(DynamicBufferType.decode(activeBuffers))));
    }

    public static void free() {
        PROCESSOR.remove();
    }

    public static String modify(@Nullable String shaderInstance, @Nullable class_2960 name, @Nullable class_293 vertexFormat, int type, String source) throws IOException {
        ShaderPreProcessor processor = PROCESSOR.get();
        if (processor == null) {
            throw new NullPointerException("Processor not initialized");
        }
        return processor.modify(new Context(shaderInstance, name, type, vertexFormat), source);
    }

    private record Context(String shaderInstance, class_2960 name, int type, class_293 vertexFormat) implements ShaderPreProcessor.Context
    {
        @Override
        public String modify(@Nullable class_2960 name, String source) throws IOException {
            return PROCESSOR.get().modify(new Context(this.shaderInstance, name, this.type, this.vertexFormat), source);
        }

        @Override
        public void addUniformBinding(String name, int binding) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addDefinitionDependency(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addInclude(class_2960 name) {
        }

        @Override
        public Set<class_2960> includes() {
            return Collections.emptySet();
        }

        @Override
        public boolean isSourceFile() {
            return true;
        }

        @Override
        @Nullable
        public ProgramDefinition definition() {
            return null;
        }

        @Override
        @Nullable
        public ShaderPreDefinitions preDefinitions() {
            return null;
        }
    }
}

