/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.dynamicbuffer;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.ext.ShaderInstanceExtension;
import foundry.veil.impl.client.render.shader.SimpleShaderProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4239;
import net.minecraft.class_5912;
import net.minecraft.class_5913;
import net.minecraft.class_5944;
import org.apache.commons.io.IOUtils;

public class VanillaShaderCompiler {
    private static final Set<String> LAST_FRAME_SHADERS = ConcurrentHashMap.newKeySet();
    private AtomicBoolean cancelled;
    private CompletableFuture<?> reloadFuture = CompletableFuture.completedFuture(null);

    private void compileShader(AtomicBoolean cancelled, class_5944 shader) {
        ShaderInstanceExtension extension = (ShaderInstanceExtension)shader;
        Collection<class_2960> shaderSources = extension.veil$getShaderSources();
        class_293 vertexFormat = shader.method_35786();
        final class_3300 resourceManager = class_310.method_1551().method_1478();
        SimpleShaderProcessor.setup((class_5912)resourceManager);
        for (final class_2960 path : shaderSources) {
            try {
                BufferedReader reader = resourceManager.openAsReader(path);
                try {
                    String source = IOUtils.toString((Reader)reader);
                    if (cancelled.get()) {
                        return;
                    }
                    class_5913 preprocessor = new class_5913(this){
                        private final Set<String> importedPaths = Sets.newHashSet();

                        public String method_34233(boolean useFullPath, String directory) {
                            directory = class_4239.method_34676((String)((useFullPath ? path.method_12832() : "shaders/include/") + directory));
                            if (!this.importedPaths.add(directory)) {
                                return null;
                            }
                            class_2960 resourcelocation = class_2960.method_60654((String)directory);
                            try {
                                String s2;
                                try (BufferedReader reader = resourceManager.openAsReader(resourcelocation);){
                                    s2 = IOUtils.toString((Reader)reader);
                                }
                                return s2;
                            }
                            catch (IOException e) {
                                Veil.LOGGER.error("Could not open GLSL import {}: {}", (Object)directory, (Object)e.getMessage());
                                return "#error " + e.getMessage();
                            }
                        }
                    };
                    source = String.join((CharSequence)"", preprocessor.method_34229(source));
                    if (cancelled.get()) {
                        return;
                    }
                    boolean vertex = path.method_12832().endsWith(".vsh");
                    String processed = SimpleShaderProcessor.modify(shader.method_35787(), path, vertexFormat, vertex ? 35633 : 35632, source);
                    RenderSystem.recordRenderCall(() -> extension.veil$recompile(vertex, processed));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Throwable t) {
                Veil.LOGGER.error("Couldn't load vanilla shader from {}", (Object)path, (Object)t);
            }
        }
        SimpleShaderProcessor.free();
    }

    public CompletableFuture<?> reload(Collection<class_5944> shaders) {
        AtomicBoolean cancelled;
        if (this.cancelled != null) {
            this.cancelled.set(true);
        }
        ConcurrentHashMap<String, class_5944> shaderMap = new ConcurrentHashMap<String, class_5944>(shaders.size());
        for (class_5944 shader : shaders) {
            shaderMap.put(shader.method_35787(), shader);
        }
        this.cancelled = cancelled = new AtomicBoolean(false);
        TaskScheduler scheduler = new TaskScheduler("VeilShaderCompile", Math.max(1, Runtime.getRuntime().availableProcessors() / 2), () -> {
            if (cancelled.get()) {
                return null;
            }
            for (String lastFrameShader : LAST_FRAME_SHADERS) {
                class_5944 shader = (class_5944)shaderMap.remove(lastFrameShader);
                if (shader == null) continue;
                return () -> this.compileShader(cancelled, shader);
            }
            Iterator iterator = shaderMap.values().iterator();
            if (iterator.hasNext()) {
                class_5944 shader = (class_5944)iterator.next();
                iterator.remove();
                return () -> this.compileShader(cancelled, shader);
            }
            return null;
        });
        CompletableFuture<?> future = scheduler.getCompletedFuture();
        future.thenRunAsync(() -> {
            if (!cancelled.get()) {
                Veil.LOGGER.info("Compiled {} vanilla shaders", (Object)shaders.size());
            }
        }, (Executor)class_310.method_1551());
        this.reloadFuture = future;
        return this.reloadFuture;
    }

    public boolean isCompilingShaders() {
        return !this.reloadFuture.isDone();
    }

    public static void markRendered(String shaderInstace) {
        if (VeilRenderSystem.renderer().getVanillaShaderCompiler().isCompilingShaders()) {
            LAST_FRAME_SHADERS.add(shaderInstace);
        }
    }

    public static void clear() {
        LAST_FRAME_SHADERS.clear();
    }

    private static class TaskScheduler {
        private final int threadCount;
        private final Semaphore semaphore;
        private final CompletableFuture<?> completedFuture;
        private final Supplier<Runnable> source;
        private final Deque<Runnable> queue;
        private final AtomicBoolean running;
        private final AtomicInteger finished;

        public TaskScheduler(String name, int threadCount, Supplier<Runnable> source) {
            int i;
            this.threadCount = threadCount;
            this.semaphore = new Semaphore(0);
            this.completedFuture = new CompletableFuture();
            this.source = source;
            this.queue = new ConcurrentLinkedDeque<Runnable>();
            this.running = new AtomicBoolean(true);
            this.finished = new AtomicInteger(0);
            for (i = 0; i < this.threadCount; ++i) {
                Thread thread = new Thread(this::run, name + "Thread#" + i);
                thread.setPriority(Math.max(0, 3));
                thread.start();
            }
            for (i = 0; i < this.threadCount; ++i) {
                Runnable work = source.get();
                if (work == null) {
                    this.running.set(false);
                    this.semaphore.release(this.threadCount);
                    return;
                }
                this.queue.add(work);
                this.semaphore.release();
            }
        }

        private void run() {
            while (this.running.get()) {
                Runnable task;
                block8: {
                    try {
                        this.semaphore.acquire();
                        task = this.queue.poll();
                        if (task == null) break block8;
                        Runnable next = this.source.get();
                        if (next == null) {
                            this.running.set(false);
                            this.semaphore.release(this.threadCount);
                        } else {
                            this.queue.add(next);
                            this.semaphore.release();
                        }
                    }
                    catch (InterruptedException ignored) {
                        continue;
                    }
                }
                if (task == null) continue;
                try {
                    task.run();
                }
                catch (Throwable t) {
                    Veil.LOGGER.error("Error running task", t);
                }
            }
            if (this.finished.incrementAndGet() >= this.threadCount) {
                this.completedFuture.complete(null);
            }
        }

        public CompletableFuture<?> getCompletedFuture() {
            return this.completedFuture;
        }
    }
}

