/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.post.stage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.Veil;
import foundry.veil.api.client.registry.PostPipelineStageRegistry;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.FramebufferManager;
import foundry.veil.api.client.render.post.PostPipeline;
import foundry.veil.api.client.render.post.stage.FramebufferPostStage;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import java.util.Optional;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix2fc;
import org.joml.Matrix3fc;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3fc;
import org.joml.Vector2fc;
import org.joml.Vector2ic;
import org.joml.Vector3fc;
import org.joml.Vector3ic;
import org.joml.Vector4fc;
import org.joml.Vector4ic;

public class BlitPostStage
extends FramebufferPostStage {
    public static final MapCodec<BlitPostStage> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.fieldOf("shader").forGetter(BlitPostStage::getShaderId), (App)FramebufferManager.FRAMEBUFFER_CODEC.optionalFieldOf("in").forGetter(stage -> Optional.ofNullable(stage.getIn())), (App)FramebufferManager.FRAMEBUFFER_CODEC.fieldOf("out").forGetter(FramebufferPostStage::getOut), (App)Codec.BOOL.optionalFieldOf("clear", (Object)true).forGetter(FramebufferPostStage::clearOut)).apply((Applicative)instance, (shader, in, out, clear) -> new BlitPostStage((class_2960)shader, in.orElse(null), (class_2960)out, (boolean)clear)));
    private final class_2960 shader;
    private boolean printedError;

    public BlitPostStage(class_2960 shader, @Nullable class_2960 in, class_2960 out, boolean clear) {
        super(in, out, clear);
        this.shader = shader;
    }

    @Override
    public void apply(PostPipeline.Context context) {
        ShaderProgram shader = VeilRenderSystem.renderer().getShaderManager().getShader(this.shader);
        if (shader == null) {
            if (!this.printedError) {
                this.printedError = true;
                Veil.LOGGER.warn("Failed to find post shader: {}", (Object)this.shader);
            }
            return;
        }
        if (this.getOut().equals((Object)this.getIn()) && !this.printedError) {
            this.printedError = true;
            Veil.LOGGER.error("Input and output targets cannot be the same: {}", (Object)this.shader);
        }
        shader.bind();
        shader.applyRenderSystem();
        shader.addRenderSystemTextures();
        context.applySamplers(shader);
        this.setupFramebuffer(context, shader);
        shader.applyShaderSamplers(context, 0);
        VeilRenderSystem.drawScreenQuad();
    }

    @Override
    public PostPipelineStageRegistry.PipelineType<? extends PostPipeline> getType() {
        return PostPipelineStageRegistry.BLIT.get();
    }

    @Override
    public boolean hasUniform(CharSequence name) {
        ShaderProgram shader = this.getShader();
        return shader != null && shader.hasUniform(name);
    }

    @Override
    public boolean hasUniformBlock(CharSequence name) {
        ShaderProgram shader = this.getShader();
        return shader != null && shader.hasUniformBlock(name);
    }

    @Override
    public boolean hasStorageBlock(CharSequence name) {
        ShaderProgram shader = this.getShader();
        return shader != null && shader.hasStorageBlock(name);
    }

    @Override
    public void setUniformBlock(CharSequence name, int binding) {
        ShaderProgram shader = this.getShader();
        if (shader != null) {
            shader.setUniformBlock(name, binding);
        }
    }

    @Override
    public void setStorageBlock(CharSequence name, int binding) {
        ShaderProgram shader = this.getShader();
        if (shader != null) {
            shader.setStorageBlock(name, binding);
        }
    }

    @Override
    public void setFloat(CharSequence name, float value) {
        ShaderProgram shader = this.getShader();
        if (shader != null) {
            shader.setFloat(name, value);
        }
    }

    @Override
    public void setVector(CharSequence name, float x, float y) {
        ShaderProgram shader = this.getShader();
        if (shader != null) {
            shader.setVector(name, x, y);
        }
    }

    @Override
    public void setVector(CharSequence name, float x, float y, float z) {
        ShaderProgram shader = this.getShader();
        if (shader != null) {
            shader.setVector(name, x, y, z);
        }
    }

    @Override
    public void setVector(CharSequence name, float x, float y, float z, float w) {
        ShaderProgram shader = this.getShader();
        if (shader != null) {
            shader.setVector(name, x, y, z, w);
        }
    }

    @Override
    public void setInt(CharSequence name, int value) {
        ShaderProgram shader = this.getShader();
        if (shader != null) {
            shader.setInt(name, value);
        }
    }

    @Override
    public void setVectorI(CharSequence name, int x, int y) {
        ShaderProgram shader = this.getShader();
        if (shader != null) {
            shader.setVectorI(name, x, y);
        }
    }

    @Override
    public void setVectorI(CharSequence name, int x, int y, int z) {
        ShaderProgram shader = this.getShader();
        if (shader != null) {
            shader.setVectorI(name, x, y, z);
        }
    }

    @Override
    public void setVectorI(CharSequence name, int x, int y, int z, int w) {
        ShaderProgram shader = this.getShader();
        if (shader != null) {
            shader.setVectorI(name, x, y, z, w);
        }
    }

    @Override
    public void setFloats(CharSequence name, float ... values) {
        ShaderProgram shader = this.getShader();
        if (shader != null) {
            shader.setFloats(name, values);
        }
    }

    @Override
    public void setVectors(CharSequence name, Vector2fc ... values) {
        ShaderProgram shader = this.getShader();
        if (shader != null) {
            shader.setVectors(name, values);
        }
    }

    @Override
    public void setVectors(CharSequence name, Vector3fc ... values) {
        ShaderProgram shader = this.getShader();
        if (shader != null) {
            shader.setVectors(name, values);
        }
    }

    @Override
    public void setVectors(CharSequence name, Vector4fc ... values) {
        ShaderProgram shader = this.getShader();
        if (shader != null) {
            shader.setVectors(name, values);
        }
    }

    @Override
    public void setInts(CharSequence name, int ... values) {
        ShaderProgram shader = this.getShader();
        if (shader != null) {
            shader.setInts(name, values);
        }
    }

    @Override
    public void setVectors(CharSequence name, Vector2ic ... values) {
        ShaderProgram shader = this.getShader();
        if (shader != null) {
            shader.setVectors(name, values);
        }
    }

    @Override
    public void setVectors(CharSequence name, Vector3ic ... values) {
        ShaderProgram shader = this.getShader();
        if (shader != null) {
            shader.setVectors(name, values);
        }
    }

    @Override
    public void setVectors(CharSequence name, Vector4ic ... values) {
        ShaderProgram shader = this.getShader();
        if (shader != null) {
            shader.setVectors(name, values);
        }
    }

    @Override
    public void setMatrix(CharSequence name, Matrix2fc value) {
        ShaderProgram shader = this.getShader();
        if (shader != null) {
            shader.setMatrix(name, value);
        }
    }

    @Override
    public void setMatrix(CharSequence name, Matrix3fc value) {
        ShaderProgram shader = this.getShader();
        if (shader != null) {
            shader.setMatrix(name, value);
        }
    }

    @Override
    public void setMatrix(CharSequence name, Matrix3x2fc value) {
        ShaderProgram shader = this.getShader();
        if (shader != null) {
            shader.setMatrix(name, value);
        }
    }

    @Override
    public void setMatrix(CharSequence name, Matrix4fc value) {
        ShaderProgram shader = this.getShader();
        if (shader != null) {
            shader.setMatrix(name, value);
        }
    }

    @Override
    public void setMatrix(CharSequence name, Matrix4x3fc value) {
        ShaderProgram shader = this.getShader();
        if (shader != null) {
            shader.setMatrix(name, value);
        }
    }

    @Nullable
    public ShaderProgram getShader() {
        return VeilRenderSystem.renderer().getShaderManager().getShader(this.shader);
    }

    public class_2960 getShaderId() {
        return this.shader;
    }
}

