/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.editor.EditorManager;
import foundry.veil.api.client.render.CameraMatrices;
import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.GuiInfo;
import foundry.veil.api.client.render.deferred.VeilDeferredRenderer;
import foundry.veil.api.client.render.deferred.light.renderer.LightRenderer;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.client.render.framebuffer.FramebufferManager;
import foundry.veil.api.client.render.post.PostProcessingManager;
import foundry.veil.api.client.render.rendertype.DynamicRenderTypeManager;
import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.client.render.shader.ShaderModificationManager;
import foundry.veil.api.client.render.shader.definition.ShaderPreDefinitions;
import foundry.veil.api.quasar.particle.ParticleSystemManager;
import foundry.veil.ext.LevelRendererExtension;
import foundry.veil.impl.client.imgui.VeilImGuiImpl;
import foundry.veil.impl.client.render.dynamicbuffer.DynamicBufferManger;
import foundry.veil.impl.client.render.dynamicbuffer.VanillaShaderCompiler;
import foundry.veil.mixin.accessor.ReloadableResourceManagerAccessor;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.system.NativeResource;

public class VeilRenderer
implements NativeResource {
    public static final class_2960 ALBEDO_BUFFER_TEXTURE = Veil.veilPath("dynamic_buffer/albedo");
    public static final class_2960 NORMAL_BUFFER_TEXTURE = Veil.veilPath("dynamic_buffer/normal");
    public static final class_2960 LIGHT_UV_BUFFER_TEXTURE = Veil.veilPath("dynamic_buffer/light_uv");
    public static final class_2960 LIGHT_COLOR_BUFFER_TEXTURE = Veil.veilPath("dynamic_buffer/light_color");
    public static final class_2960 DEBUG_BUFFER_TEXTURE = Veil.veilPath("dynamic_buffer/debug");
    public static final class_2960 LIGHT_POST = Veil.veilPath("core/light_post");
    public static final class_2960 COMPOSITE = Veil.veilPath("core/composite");
    private final VanillaShaderCompiler vanillaShaderCompiler = new VanillaShaderCompiler();
    private final DynamicBufferManger dynamicBufferManger;
    private final ShaderModificationManager shaderModificationManager;
    private final ShaderPreDefinitions shaderPreDefinitions;
    private final ShaderManager shaderManager;
    private final FramebufferManager framebufferManager;
    private final PostProcessingManager postProcessingManager;
    private final VeilDeferredRenderer deferredRenderer;
    private final DynamicRenderTypeManager dynamicRenderTypeManager;
    private final ParticleSystemManager quasarParticleManager;
    private final EditorManager editorManager;
    private final CameraMatrices cameraMatrices;
    private final LightRenderer lightRenderer;
    private final GuiInfo guiInfo;

    @ApiStatus.Internal
    public VeilRenderer(class_3304 resourceManager, class_1041 window) {
        this.dynamicBufferManger = new DynamicBufferManger(window.method_4489(), window.method_4506());
        this.shaderModificationManager = new ShaderModificationManager();
        this.shaderPreDefinitions = new ShaderPreDefinitions();
        this.shaderManager = new ShaderManager(ShaderManager.PROGRAM_SET, this.shaderPreDefinitions, this.dynamicBufferManger);
        this.framebufferManager = new FramebufferManager();
        this.postProcessingManager = new PostProcessingManager();
        ShaderManager deferredShaderManager = new ShaderManager(ShaderManager.DEFERRED_SET, this.shaderPreDefinitions, this.dynamicBufferManger);
        this.deferredRenderer = new VeilDeferredRenderer(deferredShaderManager, this.shaderPreDefinitions, this.framebufferManager, this.postProcessingManager);
        this.dynamicRenderTypeManager = new DynamicRenderTypeManager();
        this.quasarParticleManager = new ParticleSystemManager();
        this.editorManager = new EditorManager(resourceManager);
        this.cameraMatrices = new CameraMatrices();
        this.lightRenderer = new LightRenderer();
        this.guiInfo = new GuiInfo();
        List<class_3302> listeners = ((ReloadableResourceManagerAccessor)resourceManager).getListeners();
        listeners.add(0, (class_3302)this.shaderModificationManager);
        listeners.add(1, this.shaderManager);
        resourceManager.method_14477((class_3302)this.framebufferManager);
        resourceManager.method_14477((class_3302)this.postProcessingManager);
        resourceManager.method_14477((class_3302)this.dynamicRenderTypeManager);
    }

    @ApiStatus.Internal
    public void addDebugInfo(Consumer<String> consumer) {
        boolean ambientOcclusion = this.lightRenderer.isAmbientOcclusionEnabled();
        consumer.accept("Ambient Occlusion: " + (ambientOcclusion ? String.valueOf(class_124.field_1060) + "On" : String.valueOf(class_124.field_1061) + "Off"));
        this.lightRenderer.addDebugInfo(consumer);
    }

    public boolean enableBuffers(DynamicBufferType ... buffers) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (buffers.length == 0) {
            return false;
        }
        int active = this.dynamicBufferManger.getActiveBuffers() | DynamicBufferType.encode(buffers);
        return this.dynamicBufferManger.setActiveBuffers(active);
    }

    public boolean disableBuffers(DynamicBufferType ... buffers) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (buffers.length == 0) {
            return false;
        }
        int active = this.dynamicBufferManger.getActiveBuffers() & ~DynamicBufferType.encode(buffers);
        return this.dynamicBufferManger.setActiveBuffers(active);
    }

    public VanillaShaderCompiler getVanillaShaderCompiler() {
        return this.vanillaShaderCompiler;
    }

    public DynamicBufferManger getDynamicBufferManger() {
        return this.dynamicBufferManger;
    }

    public ShaderModificationManager getShaderModificationManager() {
        return this.shaderModificationManager;
    }

    public ShaderPreDefinitions getShaderDefinitions() {
        return this.shaderPreDefinitions;
    }

    public ShaderManager getShaderManager() {
        return this.shaderManager;
    }

    public FramebufferManager getFramebufferManager() {
        return this.framebufferManager;
    }

    public PostProcessingManager getPostProcessingManager() {
        return this.postProcessingManager;
    }

    @Deprecated
    public VeilDeferredRenderer getDeferredRenderer() {
        return this.deferredRenderer;
    }

    public DynamicRenderTypeManager getDynamicRenderTypeManager() {
        return this.dynamicRenderTypeManager;
    }

    public ParticleSystemManager getParticleManager() {
        return this.quasarParticleManager;
    }

    public EditorManager getEditorManager() {
        return this.editorManager;
    }

    public CameraMatrices getCameraMatrices() {
        return this.cameraMatrices;
    }

    public LightRenderer getLightRenderer() {
        return this.lightRenderer;
    }

    public GuiInfo getGuiInfo() {
        return this.guiInfo;
    }

    public static boolean hasImGui() {
        return VeilImGuiImpl.get() instanceof VeilImGuiImpl;
    }

    public static CullFrustum getCullingFrustum() {
        return ((LevelRendererExtension)class_310.method_1551().field_1769).veil$getCullFrustum();
    }

    public void free() {
        this.dynamicBufferManger.free();
        this.shaderManager.close();
        this.framebufferManager.free();
        this.postProcessingManager.free();
        this.deferredRenderer.free();
        this.quasarParticleManager.clear();
        this.cameraMatrices.free();
        this.lightRenderer.free();
        this.guiInfo.free();
    }
}

