/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.glsl;

import foundry.veil.impl.glsl.GlslSyntaxException;
import foundry.veil.impl.glsl.grammar.GlslTypeQualifier;
import foundry.veil.impl.glsl.grammar.GlslTypeSpecifier;
import foundry.veil.impl.glsl.node.expression.GlslAssignmentNode;
import foundry.veil.impl.glsl.node.expression.GlslUnaryNode;
import gg.moonflower.molangcompiler.core.compiler.StringReader;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class GlslLexer {
    public static Token[] createTokens(String input) throws GlslSyntaxException {
        return GlslLexer.createTokens(input, null);
    }

    public static Token[] createTokens(String input, @Nullable BiConsumer<Integer, Token> commentConsumer) throws GlslSyntaxException {
        StringReader reader = new StringReader(input);
        ArrayList<Token> tokens = new ArrayList<Token>();
        reader.skipWhitespace();
        while (reader.canRead()) {
            Token token = GlslLexer.getToken(reader);
            if (token != null) {
                if (token.type != TokenType.COMMENT && token.type != TokenType.MULTI_COMMENT) {
                    tokens.add(token);
                } else if (commentConsumer != null) {
                    commentConsumer.accept(tokens.size(), token);
                }
                reader.skipWhitespace();
                continue;
            }
            throw new GlslSyntaxException("Unknown Token", reader.getString(), reader.getCursor() + 1);
        }
        return (Token[])tokens.toArray(Token[]::new);
    }

    @Nullable
    private static Token getToken(StringReader reader) {
        String word = reader.getString().substring(reader.getCursor());
        Token longest = null;
        int length = 0;
        for (TokenType type : TokenType.values()) {
            Matcher matcher = type.pattern.matcher(word);
            if (!matcher.find() || matcher.start() != 0 || matcher.end() <= length) continue;
            length = matcher.end();
            longest = new Token(type, word.substring(0, length));
        }
        if (longest != null) {
            reader.setCursor(reader.getCursor() + length);
            return longest;
        }
        return null;
    }

    public record Token(TokenType type, String value) {
        @Override
        public String toString() {
            return String.valueOf((Object)this.type) + "[" + this.value + "]";
        }
    }

    public static enum TokenType {
        DIRECTIVE("#.*"),
        GLSL_MACRO("__LINE__|__FILE__|__VERSION__"),
        COMMENT("\\/\\/.*"),
        MULTI_COMMENT("\\/\\*[^*]*\\*+(?:[^/*][^*]*\\*+)*\\/"),
        CONST("const"),
        BOOL("bool"),
        FLOAT("float"),
        INT("int"),
        UINT("uint"),
        DOUBLE("double"),
        BVEC2("bvec2"),
        BVEC3("bvec3"),
        BVEC4("bvec4"),
        IVEC2("ivec2"),
        IVEC3("ivec3"),
        IVEC4("ivec4"),
        UVEC2("uvec2"),
        UVEC3("uvec3"),
        UVEC4("uvec4"),
        VEC2("vec2"),
        VEC3("vec3"),
        VEC4("vec4"),
        MAT2("mat2"),
        MAT3("mat3"),
        MAT4("mat4"),
        MAT2X2("mat2x2"),
        MAT2X3("mat2x3"),
        MAT2X4("mat2x4"),
        MAT3X2("mat3x2"),
        MAT3X3("mat3x3"),
        MAT3X4("mat3x4"),
        MAT4X2("mat4x2"),
        MAT4X3("mat4x3"),
        MAT4X4("mat4x4"),
        DVEC2("dvec2"),
        DVEC3("dvec3"),
        DVEC4("dvec4"),
        DMAT2("dmat2"),
        DMAT3("dmat3"),
        DMAT4("dmat4"),
        DMAT2X2("dmat2x2"),
        DMAT2X3("dmat2x3"),
        DMAT2X4("dmat2x4"),
        DMAT3X2("dmat3x2"),
        DMAT3X3("dmat3x3"),
        DMAT3X4("dmat3x4"),
        DMAT4X2("dmat4x2"),
        DMAT4X3("dmat4x3"),
        DMAT4X4("dmat4x4"),
        CENTROID("centroid"),
        IN("in"),
        OUT("out"),
        INOUT("inout"),
        UNIFORM("uniform"),
        PATCH("patch"),
        SAMPLE("sample"),
        BUFFER("buffer"),
        SHARED("shared"),
        COHERENT("cohent"),
        VOLATILE("volatile"),
        RESTRICT("restrict"),
        READONLY("readonly"),
        WRITEONLY("writeonly"),
        NOPERSPECTIVE("noperspective"),
        FLAT("flat"),
        SMOOTH("smooth"),
        LAYOUT("layout"),
        ATOMIC_UINT("atomic_uint"),
        SAMPLER2D("sampler2D"),
        SAMPLER3D("sampler3D"),
        SAMPLERCUBE("samplerCube"),
        SAMPLER2DSHADOW("sampler2DShadow"),
        SAMPLERCUBESHADOW("samplerCubeShadow"),
        SAMPLER2DARRAY("sampler2DArray"),
        SAMPLER2DARRAYSHADOW("sampler2DArrayShadow"),
        ISAMPLER2D("isampler2D"),
        ISAMPLER3D("isampler3D"),
        ISAMPLERCUBE("isamplerCube"),
        ISAMPLER2DARRAY("isampler2DArray"),
        USAMPLER2D("usampler2D"),
        USAMPLER3D("usampler3D"),
        USAMPLERCUBE("usamplerCube"),
        USAMPLER2DARRAY("uSampler2DArray"),
        SAMPLER1D("sampler1D"),
        SAMPLER1DSHADOW("sampler1DShadow"),
        SAMPLER1DARRAY("sampler1DArray"),
        SAMPLER1DARRAYSHADOW("sampler1DArrayShadow"),
        ISAMPLER1D("isampler1D"),
        ISAMPLER1DARRAY("isampler1DArray"),
        USAMPLER1D("usampler1D"),
        USAMPLER1DARRAY("usampler1DArray"),
        SAMPLER2DRECT("sampler2DRect"),
        SAMPLER2DRECTSHADOW("sampler2DRectShadow"),
        ISAMPLER2DRECT("isampler2DRect"),
        USAMPLER2DRECT("usampler2DRect"),
        SAMPLERBUFFER("samplerBuffer"),
        ISAMPLERBUFFER("isamplerBuffer"),
        USAMPLERBUFFER("usamplerBuffer"),
        SAMPLERCUBEARRAY("samplerCubeArray"),
        SAMPLERCUBEARRAYSHADOW("samplerCubeArrayShadow"),
        ISAMPLERCUBEARRAY("isamplerCubeArray"),
        USAMPLERCUBEARRAY("usamplerCubeArray"),
        SAMPLER2DMS("sampler2Dms"),
        ISAMPLER2DMS("isampler2Dms"),
        USAMPLER2DMS("usampler2Dms"),
        SAMPLER2DMSARRAY("sampler2DMSArray"),
        ISAMPLER2DMSARRAY("isampler2DMSArray"),
        USAMPLER2DMSARRAY("usampler2DMSArray"),
        IMAGE2D("image2D"),
        IIMAGE2D("iimage2D"),
        UIMAGE2D("uimage2D"),
        IMAGE3D("image3D"),
        IIMAGE3D("iimage3D"),
        UIMAGE3D("uimage3D"),
        IMAGECUBE("imagecube"),
        IIMAGECUBE("iimageCube"),
        UIMAGECUBE("uimageCube"),
        IMAGEBUFFER("imageBuffer"),
        IIMAGEBUFFER("iimageBuffer"),
        UIMAGEBUFFER("uimageBuffer"),
        IMAGE2DARRAY("image2DArray"),
        IIMAGE2DARRAY("iimage2DArray"),
        UIMAGE2DARRAY("uimage2DArray"),
        IMAGECUBEARRAY("imagecubeArray"),
        IIMAGECUBEARRAY("iimageCubeArray"),
        UIMAGECUBEARRAY("uimageCubeArray"),
        IMAGE1D("image1D"),
        IIMAGE1D("iimage1D"),
        UIMAGE1D("uimage1D"),
        IMAGE1DARRAY("image1DArray"),
        IIMAGE1DARRAY("iimage1DArray"),
        UIMAGE1DARRAY("uimage1DArray"),
        IMAGE2DRECT("image2DRect"),
        IIMAGE2DRECT("iimage2DRect"),
        UIMAGE2DRECT("uimage2DRect"),
        IMAGE2DMS("image2Dms"),
        IIMAGE2DMS("iimage2DMS"),
        UIMAGE2DMS("uimage2DMS"),
        IMAGE2DMSARRAY("image2DMSArray"),
        IIMAGE2DMSARRAY("iimage2DMSArray"),
        UIMAGE2DMSARRAY("uimage2DMSArray"),
        STRUCT("struct"),
        VOID("void"),
        WHILE("while"),
        BREAK("break"),
        CONTINUE("continue"),
        DO("do"),
        ELSE("else"),
        FOR("for"),
        IF("if"),
        DISCARD("discard"),
        RETURN("return"),
        SWITCH("switch"),
        CASE("case"),
        DEFAULT("default"),
        SUBROUTINE("subroutine"),
        FLOATING_CONSTANT("(?:(?:\\d+\\.\\d+|\\d+\\.|\\.\\d+)(?:[eE][+-]?\\d+)?(?:f|F|lf|LF)?)|(?:\\d+)(?:\\.|[eE][+-]?\\d+)(?:f|F|lf|LF)?"),
        UINTEGER_HEXADECIMAL_CONSTANT("0[xX][0-9a-fA-F]*[uU]?"),
        UINTEGER_OCTAL_CONSTANT("0[0-7]*[uU]?"),
        UINTEGER_DECIMAL_CONSTANT("[1-9][\\d]*[uU]?"),
        INTEGER_HEXADECIMAL_CONSTANT("0[xX][0-9a-fA-F]*"),
        INTEGER_OCTAL_CONSTANT("0[0-7]*"),
        INTEGER_DECIMAL_CONSTANT("[1-9][\\d]*"),
        BOOL_CONSTANT("true|false"),
        LEFT_OP("<<"),
        RIGHT_OP(">>"),
        INC_OP("\\+\\+"),
        DEC_OP("--"),
        LE_OP("<="),
        GE_OP(">="),
        EQ_OP("=="),
        NE_OP("!="),
        AND_OP("&&"),
        OR_OP("\\|\\|"),
        XOR_OP("\\^\\^"),
        MUL_ASSIGN("\\*="),
        DIV_ASSIGN("\\/="),
        ADD_ASSIGN("\\+="),
        MOD_ASSIGN("%="),
        LEFT_ASSIGN("<<="),
        RIGHT_ASSIGN(">>="),
        AND_ASSIGN("&="),
        XOR_ASSIGN("\\^="),
        OR_ASSIGN("\\|="),
        SUB_ASSIGN("-="),
        LEFT_PAREN("\\("),
        RIGHT_PAREN("\\)"),
        LEFT_BRACKET("\\["),
        RIGHT_BRACKET("\\]"),
        LEFT_BRACE("\\{"),
        RIGHT_BRACE("\\}"),
        DOT("\\."),
        COMMA(","),
        COLON(":"),
        EQUAL("="),
        SEMICOLON(";"),
        BANG("!"),
        DASH("-"),
        TILDE("~"),
        PLUS("\\+"),
        STAR("\\*"),
        SLASH("\\/"),
        PERCENT("%"),
        LEFT_ANGLE("<"),
        RIGHT_ANGLE(">"),
        VERTICAL_BAR("\\|"),
        CARET("\\^"),
        AMPERSAND("&"),
        QUESTION("\\?"),
        INVARIANT("invariant"),
        PRECISE("precise"),
        HIGH_PRECISION("highp"),
        MEDIUM_PRECISION("mediump"),
        LOW_PRECISION("lowp"),
        PRECISION("precision"),
        IDENTIFIER("[_a-zA-Z][\\d_a-zA-Z]*");

        private final Pattern pattern;

        private TokenType(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        @Nullable
        public GlslTypeSpecifier.BuiltinType asBuiltinType() {
            return switch (this.ordinal()) {
                case 142 -> GlslTypeSpecifier.BuiltinType.VOID;
                case 6 -> GlslTypeSpecifier.BuiltinType.FLOAT;
                case 9 -> GlslTypeSpecifier.BuiltinType.DOUBLE;
                case 7 -> GlslTypeSpecifier.BuiltinType.INT;
                case 8 -> GlslTypeSpecifier.BuiltinType.UINT;
                case 5 -> GlslTypeSpecifier.BuiltinType.BOOL;
                case 19 -> GlslTypeSpecifier.BuiltinType.VEC2;
                case 20 -> GlslTypeSpecifier.BuiltinType.VEC3;
                case 21 -> GlslTypeSpecifier.BuiltinType.VEC4;
                case 34 -> GlslTypeSpecifier.BuiltinType.DVEC2;
                case 35 -> GlslTypeSpecifier.BuiltinType.DVEC3;
                case 36 -> GlslTypeSpecifier.BuiltinType.DVEC4;
                case 10 -> GlslTypeSpecifier.BuiltinType.BVEC2;
                case 11 -> GlslTypeSpecifier.BuiltinType.BVEC3;
                case 12 -> GlslTypeSpecifier.BuiltinType.BVEC4;
                case 13 -> GlslTypeSpecifier.BuiltinType.IVEC2;
                case 14 -> GlslTypeSpecifier.BuiltinType.IVEC3;
                case 15 -> GlslTypeSpecifier.BuiltinType.IVEC4;
                case 16 -> GlslTypeSpecifier.BuiltinType.UVEC2;
                case 17 -> GlslTypeSpecifier.BuiltinType.UVEC3;
                case 18 -> GlslTypeSpecifier.BuiltinType.UVEC4;
                case 22 -> GlslTypeSpecifier.BuiltinType.MAT2;
                case 23 -> GlslTypeSpecifier.BuiltinType.MAT3;
                case 24 -> GlslTypeSpecifier.BuiltinType.MAT4;
                case 25 -> GlslTypeSpecifier.BuiltinType.MAT2X2;
                case 26 -> GlslTypeSpecifier.BuiltinType.MAT2X3;
                case 27 -> GlslTypeSpecifier.BuiltinType.MAT2X4;
                case 28 -> GlslTypeSpecifier.BuiltinType.MAT3X2;
                case 29 -> GlslTypeSpecifier.BuiltinType.MAT3X3;
                case 30 -> GlslTypeSpecifier.BuiltinType.MAT3X4;
                case 31 -> GlslTypeSpecifier.BuiltinType.MAT4X2;
                case 32 -> GlslTypeSpecifier.BuiltinType.MAT4X3;
                case 33 -> GlslTypeSpecifier.BuiltinType.MAT4X4;
                case 37 -> GlslTypeSpecifier.BuiltinType.DMAT2;
                case 38 -> GlslTypeSpecifier.BuiltinType.DMAT3;
                case 39 -> GlslTypeSpecifier.BuiltinType.DMAT4;
                case 40 -> GlslTypeSpecifier.BuiltinType.DMAT2X2;
                case 41 -> GlslTypeSpecifier.BuiltinType.DMAT2X3;
                case 42 -> GlslTypeSpecifier.BuiltinType.DMAT2X4;
                case 43 -> GlslTypeSpecifier.BuiltinType.DMAT3X2;
                case 44 -> GlslTypeSpecifier.BuiltinType.DMAT3X3;
                case 45 -> GlslTypeSpecifier.BuiltinType.DMAT3X4;
                case 46 -> GlslTypeSpecifier.BuiltinType.DMAT4X2;
                case 47 -> GlslTypeSpecifier.BuiltinType.DMAT4X3;
                case 48 -> GlslTypeSpecifier.BuiltinType.DMAT4X4;
                case 67 -> GlslTypeSpecifier.BuiltinType.ATOMIC_UINT;
                case 68 -> GlslTypeSpecifier.BuiltinType.SAMPLER2D;
                case 69 -> GlslTypeSpecifier.BuiltinType.SAMPLER3D;
                case 70 -> GlslTypeSpecifier.BuiltinType.SAMPLERCUBE;
                case 71 -> GlslTypeSpecifier.BuiltinType.SAMPLER2DSHADOW;
                case 72 -> GlslTypeSpecifier.BuiltinType.SAMPLERCUBESHADOW;
                case 73 -> GlslTypeSpecifier.BuiltinType.SAMPLER2DARRAY;
                case 74 -> GlslTypeSpecifier.BuiltinType.SAMPLER2DARRAYSHADOW;
                case 98 -> GlslTypeSpecifier.BuiltinType.SAMPLERCUBEARRAY;
                case 99 -> GlslTypeSpecifier.BuiltinType.SAMPLERCUBEARRAYSHADOW;
                case 75 -> GlslTypeSpecifier.BuiltinType.ISAMPLER2D;
                case 76 -> GlslTypeSpecifier.BuiltinType.ISAMPLER3D;
                case 77 -> GlslTypeSpecifier.BuiltinType.ISAMPLERCUBE;
                case 78 -> GlslTypeSpecifier.BuiltinType.ISAMPLER2DARRAY;
                case 100 -> GlslTypeSpecifier.BuiltinType.ISAMPLERCUBEARRAY;
                case 79 -> GlslTypeSpecifier.BuiltinType.USAMPLER2D;
                case 80 -> GlslTypeSpecifier.BuiltinType.USAMPLER3D;
                case 81 -> GlslTypeSpecifier.BuiltinType.USAMPLERCUBE;
                case 82 -> GlslTypeSpecifier.BuiltinType.USAMPLER2DARRAY;
                case 101 -> GlslTypeSpecifier.BuiltinType.USAMPLERCUBEARRAY;
                case 83 -> GlslTypeSpecifier.BuiltinType.SAMPLER1D;
                case 84 -> GlslTypeSpecifier.BuiltinType.SAMPLER1DSHADOW;
                case 85 -> GlslTypeSpecifier.BuiltinType.SAMPLER1DARRAY;
                case 86 -> GlslTypeSpecifier.BuiltinType.SAMPLER1DARRAYSHADOW;
                case 87 -> GlslTypeSpecifier.BuiltinType.ISAMPLER1D;
                case 88 -> GlslTypeSpecifier.BuiltinType.ISAMPLER1DARRAY;
                case 89 -> GlslTypeSpecifier.BuiltinType.USAMPLER1D;
                case 90 -> GlslTypeSpecifier.BuiltinType.USAMPLER1DARRAY;
                case 91 -> GlslTypeSpecifier.BuiltinType.SAMPLER2DRECT;
                case 92 -> GlslTypeSpecifier.BuiltinType.SAMPLER2DRECTSHADOW;
                case 93 -> GlslTypeSpecifier.BuiltinType.ISAMPLER2DRECT;
                case 94 -> GlslTypeSpecifier.BuiltinType.USAMPLER2DRECT;
                case 95 -> GlslTypeSpecifier.BuiltinType.SAMPLERBUFFER;
                case 96 -> GlslTypeSpecifier.BuiltinType.ISAMPLERBUFFER;
                case 97 -> GlslTypeSpecifier.BuiltinType.USAMPLERBUFFER;
                case 102 -> GlslTypeSpecifier.BuiltinType.SAMPLER2DMS;
                case 103 -> GlslTypeSpecifier.BuiltinType.ISAMPLER2DMS;
                case 104 -> GlslTypeSpecifier.BuiltinType.USAMPLER2DMS;
                case 105 -> GlslTypeSpecifier.BuiltinType.SAMPLER2DMSARRAY;
                case 106 -> GlslTypeSpecifier.BuiltinType.ISAMPLER2DMSARRAY;
                case 107 -> GlslTypeSpecifier.BuiltinType.USAMPLER2DMSARRAY;
                case 108 -> GlslTypeSpecifier.BuiltinType.IMAGE2D;
                case 109 -> GlslTypeSpecifier.BuiltinType.IIMAGE2D;
                case 110 -> GlslTypeSpecifier.BuiltinType.UIMAGE2D;
                case 111 -> GlslTypeSpecifier.BuiltinType.IMAGE3D;
                case 112 -> GlslTypeSpecifier.BuiltinType.IIMAGE3D;
                case 113 -> GlslTypeSpecifier.BuiltinType.UIMAGE3D;
                case 114 -> GlslTypeSpecifier.BuiltinType.IMAGECUBE;
                case 115 -> GlslTypeSpecifier.BuiltinType.IIMAGECUBE;
                case 116 -> GlslTypeSpecifier.BuiltinType.UIMAGECUBE;
                case 117 -> GlslTypeSpecifier.BuiltinType.IMAGEBUFFER;
                case 118 -> GlslTypeSpecifier.BuiltinType.IIMAGEBUFFER;
                case 119 -> GlslTypeSpecifier.BuiltinType.UIMAGEBUFFER;
                case 126 -> GlslTypeSpecifier.BuiltinType.IMAGE1D;
                case 127 -> GlslTypeSpecifier.BuiltinType.IIMAGE1D;
                case 128 -> GlslTypeSpecifier.BuiltinType.UIMAGE1D;
                case 129 -> GlslTypeSpecifier.BuiltinType.IMAGE1DARRAY;
                case 130 -> GlslTypeSpecifier.BuiltinType.IIMAGE1DARRAY;
                case 131 -> GlslTypeSpecifier.BuiltinType.UIMAGE1DARRAY;
                case 132 -> GlslTypeSpecifier.BuiltinType.IMAGE2DRECT;
                case 133 -> GlslTypeSpecifier.BuiltinType.IIMAGE2DRECT;
                case 134 -> GlslTypeSpecifier.BuiltinType.UIMAGE2DRECT;
                case 120 -> GlslTypeSpecifier.BuiltinType.IMAGE2DARRAY;
                case 121 -> GlslTypeSpecifier.BuiltinType.IIMAGE2DARRAY;
                case 122 -> GlslTypeSpecifier.BuiltinType.UIMAGE2DARRAY;
                case 123 -> GlslTypeSpecifier.BuiltinType.IMAGECUBEARRAY;
                case 124 -> GlslTypeSpecifier.BuiltinType.IIMAGECUBEARRAY;
                case 125 -> GlslTypeSpecifier.BuiltinType.UIMAGECUBEARRAY;
                case 135 -> GlslTypeSpecifier.BuiltinType.IMAGE2DMS;
                case 136 -> GlslTypeSpecifier.BuiltinType.IIMAGE2DMS;
                case 137 -> GlslTypeSpecifier.BuiltinType.UIMAGE2DMS;
                case 138 -> GlslTypeSpecifier.BuiltinType.IMAGE2DMSARRAY;
                case 139 -> GlslTypeSpecifier.BuiltinType.IIMAGE2DMSARRAY;
                case 140 -> GlslTypeSpecifier.BuiltinType.UIMAGE2DMSARRAY;
                default -> null;
            };
        }

        @Nullable
        public GlslTypeQualifier.StorageType asStorageQualifier() {
            return switch (this.ordinal()) {
                case 4 -> GlslTypeQualifier.StorageType.CONST;
                case 50 -> GlslTypeQualifier.StorageType.IN;
                case 51 -> GlslTypeQualifier.StorageType.OUT;
                case 52 -> GlslTypeQualifier.StorageType.INOUT;
                case 49 -> GlslTypeQualifier.StorageType.CENTROID;
                case 54 -> GlslTypeQualifier.StorageType.PATCH;
                case 55 -> GlslTypeQualifier.StorageType.SAMPLE;
                case 53 -> GlslTypeQualifier.StorageType.UNIFORM;
                case 56 -> GlslTypeQualifier.StorageType.BUFFER;
                case 57 -> GlslTypeQualifier.StorageType.SHARED;
                case 58 -> GlslTypeQualifier.StorageType.COHERENT;
                case 59 -> GlslTypeQualifier.StorageType.VOLATILE;
                case 60 -> GlslTypeQualifier.StorageType.RESTRICT;
                case 61 -> GlslTypeQualifier.StorageType.READONLY;
                case 62 -> GlslTypeQualifier.StorageType.WRITEONLY;
                default -> null;
            };
        }

        @Nullable
        public GlslTypeQualifier.Precision asPrecisionQualifier() {
            return switch (this.ordinal()) {
                case 211 -> GlslTypeQualifier.Precision.HIGH_PRECISION;
                case 212 -> GlslTypeQualifier.Precision.MEDIUM_PRECISION;
                case 213 -> GlslTypeQualifier.Precision.LOW_PRECISION;
                default -> null;
            };
        }

        @Nullable
        public GlslTypeQualifier.Interpolation asInterpolationQualifier() {
            return switch (this.ordinal()) {
                case 65 -> GlslTypeQualifier.Interpolation.SMOOTH;
                case 64 -> GlslTypeQualifier.Interpolation.FLAT;
                case 63 -> GlslTypeQualifier.Interpolation.NOPERSPECTIVE;
                default -> null;
            };
        }

        @Nullable
        public GlslAssignmentNode.Operand asAssignmentOperator() {
            return switch (this.ordinal()) {
                case 194 -> GlslAssignmentNode.Operand.EQUAL;
                case 175 -> GlslAssignmentNode.Operand.MUL_ASSIGN;
                case 176 -> GlslAssignmentNode.Operand.DIV_ASSIGN;
                case 178 -> GlslAssignmentNode.Operand.MOD_ASSIGN;
                case 177 -> GlslAssignmentNode.Operand.ADD_ASSIGN;
                case 184 -> GlslAssignmentNode.Operand.SUB_ASSIGN;
                case 179 -> GlslAssignmentNode.Operand.LEFT_ASSIGN;
                case 180 -> GlslAssignmentNode.Operand.RIGHT_ASSIGN;
                case 181 -> GlslAssignmentNode.Operand.AND_ASSIGN;
                case 182 -> GlslAssignmentNode.Operand.XOR_ASSIGN;
                case 183 -> GlslAssignmentNode.Operand.OR_ASSIGN;
                default -> null;
            };
        }

        @Nullable
        public GlslUnaryNode.Operand asUnaryOperator() {
            return switch (this.ordinal()) {
                case 199 -> GlslUnaryNode.Operand.PLUS;
                case 197 -> GlslUnaryNode.Operand.DASH;
                case 196 -> GlslUnaryNode.Operand.BANG;
                case 198 -> GlslUnaryNode.Operand.TILDE;
                default -> null;
            };
        }
    }
}

