/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader.modifier;

import foundry.veil.impl.client.render.shader.modifier.ShaderModification;
import foundry.veil.impl.client.render.shader.transformer.VeilJobParameters;
import foundry.veil.impl.glsl.GlslParser;
import foundry.veil.impl.glsl.GlslSyntaxException;
import foundry.veil.impl.glsl.grammar.GlslVersion;
import foundry.veil.impl.glsl.node.GlslCompoundNode;
import foundry.veil.impl.glsl.node.GlslTree;
import foundry.veil.impl.glsl.node.function.GlslFunctionNode;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class SimpleShaderModification
implements ShaderModification {
    private final int version;
    private final int priority;
    private final class_2960[] includes;
    private final String output;
    private final String uniform;
    private final ShaderModification.Function[] functions;

    public SimpleShaderModification(int version, int priority, class_2960[] includes, @Nullable String output, @Nullable String uniform, ShaderModification.Function[] functions) {
        this.version = version;
        this.priority = priority;
        this.includes = includes;
        this.output = output;
        this.uniform = uniform;
        this.functions = functions;
    }

    @Override
    public void inject(GlslTree tree, VeilJobParameters parameters) throws GlslSyntaxException, IOException {
        GlslVersion version;
        if (parameters.applyVersion() && (version = tree.getVersion()).getVersion() < this.version) {
            version.setVersion(this.version);
        }
        List<String> directives = tree.getDirectives();
        for (class_2960 class_29602 : this.includes) {
            directives.add("#custom veil:include " + String.valueOf(class_29602));
        }
        if (this.output != null && !this.output.isEmpty()) {
            tree.getBody().addAll(0, GlslParser.parse(this.fillPlaceholders(this.output)).getBody());
        }
        if (this.uniform != null && !this.uniform.isEmpty()) {
            tree.getBody().addAll(0, GlslParser.parse(this.fillPlaceholders(this.uniform)).getBody());
        }
        for (ShaderModification.Function function : this.functions) {
            String name = function.name();
            List body = tree.functions().filter(definition -> {
                if (definition == null) {
                    return false;
                }
                if (definition.getBody() == null) {
                    return false;
                }
                int paramCount = function.parameters();
                if (paramCount == -1) {
                    return true;
                }
                return definition.getHeader().getParameters().size() == paramCount;
            }).findFirst().map(GlslFunctionNode::getBody).orElseThrow(() -> {
                int paramCount = function.parameters();
                if (paramCount == -1) {
                    return new IOException("Unknown function: " + name);
                }
                return new IOException("Unknown function with " + paramCount + " parameters: " + name);
            });
            GlslCompoundNode insert = new GlslCompoundNode(GlslParser.parseExpressionList(this.fillPlaceholders(function.code())));
            if (function.head()) {
                body.add(0, insert);
                continue;
            }
            body.add(insert);
        }
    }

    public String fillPlaceholders(String code) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(code);
        if (!matcher.find()) {
            return code;
        }
        StringBuilder builder = new StringBuilder();
        do {
            matcher.appendReplacement(builder, this.getPlaceholder(matcher.group(1)));
        } while (matcher.find());
        matcher.appendTail(builder);
        return builder.toString();
    }

    protected String getPlaceholder(String key) {
        return key;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    public String getOutput() {
        return this.output;
    }
}

