/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.dynamicbuffer;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.ext.ShaderInstanceExtension;
import foundry.veil.impl.client.render.shader.SimpleShaderProcessor;
import foundry.veil.mixin.accessor.GameRendererAccessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_156;
import net.minecraft.class_276;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4239;
import net.minecraft.class_5912;
import net.minecraft.class_5913;
import net.minecraft.class_5944;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.NativeResource;

public class DynamicBufferManger
implements NativeResource {
    private static final int[] GL_MAPPING = new int[]{35633, 36488, 36487, 36313, 35632, 37305};
    public static final class_2960 MAIN_WRAPPER = Veil.veilPath("dynamic_main");
    private int activeBuffers = 0;
    private boolean enabled = false;
    private final int[] clearBuffers = Arrays.stream(DynamicBufferType.values()).mapToInt(type -> 36065 + type.ordinal()).toArray();
    private final Map<class_2960, AdvancedFbo> framebuffers = new HashMap<class_2960, AdvancedFbo>();
    private final EnumMap<DynamicBufferType, DynamicBuffer> dynamicBuffers = new EnumMap(DynamicBufferType.class);
    private final AtomicBoolean vanillaCancelled;
    private CompletableFuture<?> vanillaLoadFuture;

    public DynamicBufferManger(int width, int height) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer textures = stack.mallocInt(DynamicBufferType.values().length);
            GL20C.glGenTextures((IntBuffer)textures);
            for (DynamicBufferType value : DynamicBufferType.values()) {
                DynamicBuffer buffer = new DynamicBuffer(value, textures.get(value.ordinal()));
                buffer.init(width, height);
                this.dynamicBuffers.put(value, buffer);
            }
        }
        this.vanillaCancelled = new AtomicBoolean(false);
        this.vanillaLoadFuture = CompletableFuture.completedFuture(null);
    }

    private void deleteFramebuffers() {
        for (Map.Entry<class_2960, AdvancedFbo> entry : this.framebuffers.entrySet()) {
            entry.getValue().free();
            VeilRenderSystem.renderer().getFramebufferManager().removeFramebuffer(entry.getKey());
        }
        this.framebuffers.clear();
    }

    public CompletableFuture<?> reloadVanillaShaders(Collection<class_5944> shaders) {
        this.vanillaCancelled.set(true);
        this.vanillaLoadFuture = CompletableFuture.runAsync(() -> {
            this.vanillaCancelled.set(false);
            class_3300 resourceManager = class_310.method_1551().method_1478();
            Veil.LOGGER.info("Compiling {} vanilla shaders", (Object)shaders.size());
            SimpleShaderProcessor.setup((class_5912)resourceManager);
            HashMap<String, class_5944> shaderMap = new HashMap<String, class_5944>(shaders.size());
            for (class_5944 shader : shaders) {
                shaderMap.put(shader.method_35787(), shader);
            }
            block1: while (!shaderMap.isEmpty()) {
                if (this.vanillaCancelled.get()) {
                    return;
                }
                Set<String> lastFrameShaders = SimpleShaderProcessor.getLastFrameShaders();
                boolean compiled = false;
                for (String lastFrameShader : lastFrameShaders) {
                    class_5944 shader = (class_5944)shaderMap.remove(lastFrameShader);
                    if (shader == null || !shader.method_35787().startsWith("rendertype_")) continue;
                    this.compileShader((class_5912)resourceManager, shader);
                    compiled = true;
                    break;
                }
                if (compiled) continue;
                Iterator iterator = shaderMap.values().iterator();
                while (iterator.hasNext()) {
                    class_5944 shader = (class_5944)iterator.next();
                    iterator.remove();
                    if (!shader.method_35787().startsWith("rendertype_")) continue;
                    this.compileShader((class_5912)resourceManager, shader);
                    continue block1;
                }
            }
            SimpleShaderProcessor.free();
            if (!this.vanillaCancelled.get()) {
                Veil.LOGGER.info("Compiled {} vanilla shaders", (Object)shaders.size());
            }
        }, class_156.method_18349());
        return this.vanillaLoadFuture;
    }

    private void compileShader(final class_5912 resourceProvider, class_5944 shader) {
        ShaderInstanceExtension extension = (ShaderInstanceExtension)shader;
        Collection<class_2960> shaderSources = extension.veil$getShaderSources();
        class_293 vertexFormat = shader.method_35786();
        for (final class_2960 path : shaderSources) {
            try {
                BufferedReader reader = resourceProvider.openAsReader(path);
                try {
                    String source = IOUtils.toString((Reader)reader);
                    class_5913 preprocessor = new class_5913(this){
                        private final Set<String> importedPaths = Sets.newHashSet();

                        public String method_34233(boolean useFullPath, String directory) {
                            directory = class_4239.method_34676((String)((useFullPath ? path.method_12832() : "shaders/include/") + directory));
                            if (!this.importedPaths.add(directory)) {
                                return null;
                            }
                            class_2960 resourcelocation = class_2960.method_60654((String)directory);
                            try {
                                String s2;
                                try (BufferedReader reader = resourceProvider.openAsReader(resourcelocation);){
                                    s2 = IOUtils.toString((Reader)reader);
                                }
                                return s2;
                            }
                            catch (IOException e) {
                                Veil.LOGGER.error("Could not open GLSL import {}: {}", (Object)directory, (Object)e.getMessage());
                                return "#error " + e.getMessage();
                            }
                        }
                    };
                    source = String.join((CharSequence)"", preprocessor.method_34229(source));
                    boolean vertex = path.method_12832().endsWith(".vsh");
                    String processed = SimpleShaderProcessor.modify(shader.method_35787(), path, vertexFormat, vertex ? 35633 : 35632, source);
                    RenderSystem.recordRenderCall(() -> extension.veil$recompile(vertex, processed));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Throwable t) {
                Veil.LOGGER.error("Couldn't load vanilla shader from {}", (Object)path, (Object)t);
            }
        }
    }

    public boolean isCompilingShaders() {
        return !this.vanillaLoadFuture.isDone();
    }

    public int getActiveBuffers() {
        return this.activeBuffers;
    }

    public int getBufferTexture(DynamicBufferType type) {
        return this.dynamicBuffers.get((Object)((Object)type)).textureId;
    }

    public boolean setActiveBuffers(int activeBuffers) {
        if (this.activeBuffers == activeBuffers) {
            return false;
        }
        this.activeBuffers = activeBuffers;
        this.reloadVanillaShaders(((GameRendererAccessor)class_310.method_1551().field_1773).getShaders().values());
        this.deleteFramebuffers();
        try {
            VeilRenderSystem.renderer().getShaderManager().setActiveBuffers(activeBuffers);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @ApiStatus.Internal
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void free() {
        this.deleteFramebuffers();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer textures = stack.mallocInt(DynamicBufferType.values().length);
            for (DynamicBufferType value : DynamicBufferType.values()) {
                textures.put(value.ordinal(), this.dynamicBuffers.get((Object)((Object)value)).textureId);
            }
            GL20C.glDeleteTextures((IntBuffer)textures);
        }
        this.dynamicBuffers.clear();
    }

    @ApiStatus.Internal
    public void setupRenderState(class_2960 name, @Nullable class_276 renderTarget) {
        if (this.activeBuffers == 0 || !this.enabled) {
            return;
        }
        if (renderTarget == null) {
            VeilRenderSystem.renderer().getFramebufferManager().removeFramebuffer(name);
            AdvancedFbo fbo = this.framebuffers.remove(name);
            if (fbo != null) {
                fbo.free();
            }
            return;
        }
        AdvancedFbo fbo = this.framebuffers.get(name);
        if (fbo == null) {
            AdvancedFbo.Builder builder = AdvancedFbo.withSize(renderTarget.field_1482, renderTarget.field_1481);
            builder.addColorTextureWrapper(renderTarget.method_30277());
            for (Map.Entry<DynamicBufferType, DynamicBuffer> entry : this.dynamicBuffers.entrySet()) {
                DynamicBufferType type = entry.getKey();
                if ((this.activeBuffers & type.getMask()) == 0) continue;
                builder.setName(type.getSourceName()).addColorTextureWrapper(entry.getValue().textureId);
            }
            builder.setDepthTextureWrapper(renderTarget.method_30278());
            fbo = builder.build(true);
            this.framebuffers.put(name, fbo);
        }
        VeilRenderSystem.renderer().getFramebufferManager().setFramebuffer(name, fbo);
        fbo.bind(true);
    }

    @ApiStatus.Internal
    public void clearRenderState() {
        if (this.activeBuffers == 0 || !this.enabled) {
            return;
        }
        this.setupRenderState(MAIN_WRAPPER, class_310.method_1551().method_1522());
    }

    @ApiStatus.Internal
    public void clear() {
        for (AdvancedFbo framebuffer : this.framebuffers.values()) {
            framebuffer.bind(false);
            GL20C.glDrawBuffers((int[])this.clearBuffers);
            GlStateManager._clear((int)16384, (boolean)class_310.field_1703);
            GL20C.glDrawBuffers((int[])framebuffer.getDrawBuffers());
        }
    }

    @ApiStatus.Internal
    public void resizeFramebuffers(int width, int height) {
        this.deleteFramebuffers();
        for (DynamicBuffer buffer : this.dynamicBuffers.values()) {
            buffer.resize(width, height);
        }
    }

    public static int getShaderIndex(int glType, int activeBuffers) {
        for (int i = 0; i < GL_MAPPING.length; ++i) {
            if (GL_MAPPING[i] != glType) continue;
            return i | activeBuffers << 4;
        }
        throw new IllegalArgumentException("Invalid GL Shader Type: 0x" + Integer.toHexString(glType).toUpperCase(Locale.ROOT));
    }

    private record DynamicBuffer(DynamicBufferType type, int textureId) {
        public void init(int width, int height) {
            GlStateManager._bindTexture((int)this.textureId);
            GlStateManager._texParameter((int)3553, (int)10241, (int)9728);
            GlStateManager._texParameter((int)3553, (int)10240, (int)9728);
            GlStateManager._texParameter((int)3553, (int)33085, (int)0);
            GlStateManager._texParameter((int)3553, (int)33082, (int)0);
            GlStateManager._texParameter((int)3553, (int)33083, (int)0);
            GlStateManager._texParameter((int)3553, (int)34049, (float)0.0f);
            GlStateManager._texParameter((int)3553, (int)10242, (int)33071);
            GlStateManager._texParameter((int)3553, (int)10243, (int)33071);
            GlStateManager._texImage2D((int)3553, (int)0, (int)this.type.getInternalFormat(), (int)width, (int)height, (int)0, (int)this.type.getTexelFormat(), (int)5125, null);
        }

        public void resize(int width, int height) {
            GlStateManager._bindTexture((int)this.textureId);
            GlStateManager._texImage2D((int)3553, (int)0, (int)this.type.getInternalFormat(), (int)width, (int)height, (int)0, (int)this.type.getTexelFormat(), (int)5125, null);
        }
    }
}

