/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.util;

import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DebugFrustumRenderer {
    private static final Vector3f[] POSITIONS = new Vector3f[8];
    private static final Matrix4f MODELVIEW = new Matrix4f();
    private static final Matrix4f PROJECTION = new Matrix4f();

    private static int getIndex(int x, int y, int z) {
        return (z * 2 + y) * 2 + x;
    }

    private static void putLine(@NotNull class_4588 consumer, int x0, int y0, int z0, int x1, int y1, int z1, float red, float green, float blue, float alpha) {
        Vector3f pos0 = POSITIONS[DebugFrustumRenderer.getIndex(x0, y0, z0)];
        Vector3f pos1 = POSITIONS[DebugFrustumRenderer.getIndex(x1, y1, z1)];
        Vector3f norm = pos1.sub((Vector3fc)pos0, new Vector3f()).normalize();
        consumer.method_22912(pos0.x(), pos0.y(), pos0.z()).method_22915(red, green, blue, alpha).method_22914(norm.x(), norm.y(), norm.z());
        consumer.method_22912(pos1.x(), pos1.y(), pos1.z()).method_22915(red, green, blue, alpha).method_22914(norm.x(), norm.y(), norm.z());
    }

    public static void renderFrustum(@NotNull class_4597 source, @NotNull class_4587 stack, @NotNull Matrix4fc pose, @NotNull Matrix4fc projection, float red, float green, float blue, float alpha) {
        stack.method_22903();
        Matrix4f modelView = stack.method_23760().method_23761();
        modelView.mul((Matrix4fc)pose.invert(MODELVIEW));
        modelView.mul((Matrix4fc)projection.invert(PROJECTION));
        for (int z = 0; z < 2; ++z) {
            for (int x = 0; x < 2; ++x) {
                for (int y = 0; y < 2; ++y) {
                    modelView.transformPosition((float)(x * 2 - 1), (float)(y * 2 - 1), (float)(z * 2 - 1), POSITIONS[DebugFrustumRenderer.getIndex(x, y, z)]);
                }
            }
        }
        class_4588 consumer = source.getBuffer(class_1921.method_23594());
        DebugFrustumRenderer.putLine(consumer, 0, 0, 0, 0, 1, 0, red, green, blue, alpha);
        DebugFrustumRenderer.putLine(consumer, 0, 0, 1, 0, 1, 1, red, green, blue, alpha);
        DebugFrustumRenderer.putLine(consumer, 0, 0, 0, 0, 0, 1, red, green, blue, alpha);
        DebugFrustumRenderer.putLine(consumer, 0, 1, 0, 1, 1, 0, red, green, blue, alpha);
        DebugFrustumRenderer.putLine(consumer, 0, 1, 1, 1, 1, 1, red, green, blue, alpha);
        DebugFrustumRenderer.putLine(consumer, 0, 1, 0, 0, 1, 1, red, green, blue, alpha);
        DebugFrustumRenderer.putLine(consumer, 1, 1, 0, 1, 0, 0, red, green, blue, alpha);
        DebugFrustumRenderer.putLine(consumer, 1, 1, 1, 1, 0, 1, red, green, blue, alpha);
        DebugFrustumRenderer.putLine(consumer, 1, 1, 0, 1, 1, 1, red, green, blue, alpha);
        DebugFrustumRenderer.putLine(consumer, 1, 0, 0, 0, 0, 0, red, green, blue, alpha);
        DebugFrustumRenderer.putLine(consumer, 1, 0, 1, 0, 0, 1, red, green, blue, alpha);
        DebugFrustumRenderer.putLine(consumer, 1, 0, 0, 1, 0, 1, red, green, blue, alpha);
        stack.method_22909();
    }

    static {
        for (int i = 0; i < POSITIONS.length; ++i) {
            DebugFrustumRenderer.POSITIONS[i] = new Vector3f();
        }
    }
}

