/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.client.render.shader.ShaderCompiler;
import foundry.veil.api.client.render.shader.ShaderException;
import foundry.veil.api.client.render.shader.ShaderSourceSet;
import foundry.veil.api.client.render.shader.VeilShaderSource;
import foundry.veil.api.client.render.shader.definition.ShaderPreDefinitions;
import foundry.veil.api.client.render.shader.processor.ShaderBindingProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderCustomProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderImportProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderModifyProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderPreProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderPredefinitionProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderVersionProcessor;
import foundry.veil.api.client.render.shader.program.ProgramDefinition;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.impl.client.render.dynamicbuffer.DynamicBufferManger;
import foundry.veil.impl.client.render.dynamicbuffer.DynamicBufferProcessor;
import foundry.veil.impl.client.render.shader.ShaderProgramImpl;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_5912;
import net.minecraft.class_7654;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;

public class ShaderManager
implements class_3302,
Closeable {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).registerTypeAdapter(ProgramDefinition.class, (Object)new ProgramDefinition.Deserializer()).create();
    public static final class_7654 INCLUDE_LISTER = new class_7654("pinwheel/shaders/include", ".glsl");
    public static final ShaderSourceSet PROGRAM_SET = new ShaderSourceSet("pinwheel/shaders/program");
    public static final ShaderSourceSet DEFERRED_SET = new ShaderSourceSet("pinwheel/shaders/deferred");
    private static final Map<Integer, String> TYPES = Map.of(35633, "vertex", 36488, "tesselation_control", 36487, "tesselation_evaluation", 36313, "geometry", 35632, "fragment", 37305, "compute");
    private final DynamicBufferManger dynamicBufferManager;
    private final ShaderSourceSet sourceSet;
    private final ShaderPreDefinitions definitions;
    private final Map<class_2960, ShaderProgram> shaders;
    private final Map<class_2960, ShaderProgram> shadersView;
    private final Set<class_2960> dirtyShaders;
    private final List<ShaderPreProcessor> processors;
    private final List<ShaderPreProcessor> importProcessors;
    private ShaderPreProcessor processor;
    private ShaderPreProcessor importProcessor;
    private CompletableFuture<Void> reloadFuture;
    private CompletableFuture<Void> recompileFuture;
    private CompletableFuture<Void> updateBuffersFuture;

    public ShaderManager(ShaderSourceSet sourceSet, ShaderPreDefinitions shaderPreDefinitions, DynamicBufferManger dynamicBufferManager) {
        this.dynamicBufferManager = dynamicBufferManager;
        this.sourceSet = sourceSet;
        this.definitions = shaderPreDefinitions;
        this.definitions.addListener(this::onDefinitionChanged);
        this.shaders = new HashMap<class_2960, ShaderProgram>();
        this.shadersView = Collections.unmodifiableMap(this.shaders);
        this.dirtyShaders = new HashSet<class_2960>();
        this.processors = new LinkedList<ShaderPreProcessor>();
        this.importProcessors = new LinkedList<ShaderPreProcessor>();
        this.processor = null;
        this.importProcessor = null;
        this.reloadFuture = CompletableFuture.completedFuture(null);
        this.recompileFuture = CompletableFuture.completedFuture(null);
        this.updateBuffersFuture = CompletableFuture.completedFuture(null);
    }

    private ShaderPreProcessor getProcessor() {
        if (this.processor == null) {
            this.processor = ShaderPreProcessor.allOf(this.processors);
        }
        return this.processor;
    }

    private ShaderPreProcessor getImportProcessor() {
        if (this.importProcessor == null) {
            this.importProcessor = ShaderPreProcessor.allOf(this.importProcessors);
        }
        return this.importProcessor;
    }

    private void onDefinitionChanged(String definition) {
        this.shaders.values().forEach(shader -> {
            if (shader.getDefinitionDependencies().contains(definition)) {
                Veil.LOGGER.debug("{} changed, recompiling {}", (Object)definition, (Object)shader.getId());
                this.scheduleRecompile(shader.getId());
            }
        });
    }

    private ProgramDefinition parseDefinition(class_2960 id, class_5912 provider) throws IOException {
        ProgramDefinition programDefinition;
        block9: {
            BufferedReader reader = provider.openAsReader(this.sourceSet.getShaderDefinitionLister().method_45112(id));
            try {
                ProgramDefinition definition = (ProgramDefinition)class_3518.method_15276((Gson)GSON, (Reader)reader, ProgramDefinition.class);
                if (definition.vertex() == null && definition.tesselationControl() == null && definition.tesselationEvaluation() == null && definition.geometry() == null && definition.fragment() == null && definition.compute() == null) {
                    throw new JsonSyntaxException("Shader programs must define at least 1 shader type");
                }
                programDefinition = definition;
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException e) {
                    throw new IOException(e);
                }
            }
            ((Reader)reader).close();
        }
        return programDefinition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readShader(class_3300 resourceManager, Map<class_2960, ProgramDefinition> definitions, Map<class_2960, VeilShaderSource> shaderSources, class_2960 definitionId, int flags) {
        HashSet<class_2960> checkedSources = new HashSet<class_2960>();
        ShaderPreProcessor processor = this.getProcessor();
        ShaderPreProcessor importProcessor = this.getImportProcessor();
        try {
            ProgramDefinition definition = this.parseDefinition(definitionId, (class_5912)resourceManager);
            if (definitions.put(definitionId, definition) != null) {
                throw new IllegalStateException("Duplicate shader ignored with ID " + String.valueOf(definitionId));
            }
            for (Int2ObjectMap.Entry shader : definition.shaders().int2ObjectEntrySet()) {
                int type = shader.getIntKey();
                class_2960 shaderId = ((ProgramDefinition.ShaderSource)shader.getValue()).location();
                class_7654 typeConverter = this.sourceSet.getTypeConverter(type);
                class_2960 location = typeConverter.method_45112(shaderId);
                if (!checkedSources.add(location)) continue;
                class_3298 resource = resourceManager.getResourceOrThrow(location);
                try {
                    BufferedReader reader = resource.method_43039();
                    try {
                        String source = IOUtils.toString((Reader)reader);
                        processor.prepare();
                        importProcessor.prepare();
                        Object2IntArrayMap uniformBindings = new Object2IntArrayMap();
                        HashSet<String> dependencies = new HashSet<String>();
                        HashSet<class_2960> includes = new HashSet<class_2960>();
                        PreProcessorContext preProcessorContext = new PreProcessorContext(importProcessor, definition, this.definitions, type, (Map<String, Integer>)uniformBindings, dependencies, includes, shaderId, true);
                        String transformed = this.processor.modify(preProcessorContext, source);
                        if (flags != 0) {
                            DynamicBufferType[] types = DynamicBufferType.decode(flags);
                            DynamicBufferProcessor bufferProcessor = new DynamicBufferProcessor(types);
                            transformed = bufferProcessor.modify(preProcessorContext, transformed);
                        }
                        shaderSources.put(location, new VeilShaderSource(shaderId, transformed, (Object2IntMap<String>)uniformBindings, dependencies, includes));
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Throwable t) {
                    throw new IOException("Failed to load " + ShaderManager.getTypeName(type) + " shader", t);
                    return;
                }
            }
        }
        catch (JsonParseException | IOException | IllegalArgumentException e) {
            Veil.LOGGER.error("Couldn't parse shader {} from {}", new Object[]{definitionId, this.sourceSet.getShaderDefinitionLister().method_45112(definitionId), e});
        }
    }

    private void compile(ShaderProgram program, ProgramDefinition definition, ShaderCompiler compiler) {
        class_2960 id = program.getId();
        try {
            program.compile(new ShaderCompiler.Context(this.dynamicBufferManager.getActiveBuffers(), this.sourceSet, definition), compiler);
        }
        catch (ShaderException e) {
            Veil.LOGGER.error("Failed to create shader {}: {}", (Object)id, (Object)e.getMessage());
            String error = e.getGlError();
            if (error != null) {
                Veil.LOGGER.warn(error);
            }
        }
        catch (Exception e) {
            Veil.LOGGER.error("Failed to create shader: {}", (Object)id, (Object)e);
        }
    }

    private void addProcessors(class_5912 provider) {
        if (provider != null) {
            this.addPreprocessor(new ShaderImportProcessor(provider));
        }
        this.addPreprocessor(new ShaderBindingProcessor());
        this.addPreprocessor(new ShaderPredefinitionProcessor(), false);
        this.addPreprocessor(new ShaderVersionProcessor(), false);
        this.addPreprocessor(new ShaderModifyProcessor(), false);
        this.addPreprocessor(new ShaderCustomProcessor(provider), false);
    }

    public void addPreprocessor(ShaderPreProcessor processor, boolean modifyImports) {
        this.processors.add(processor);
        this.processor = null;
        if (modifyImports) {
            this.importProcessors.add(processor);
            this.importProcessor = null;
        }
    }

    public void addPreprocessor(ShaderPreProcessor processor) {
        this.addPreprocessor(processor, true);
    }

    public void setGlobal(Consumer<ShaderProgram> setter) {
        this.shaders.values().forEach(setter);
    }

    @Nullable
    public ShaderProgram getShader(class_2960 id) {
        return this.shaders.get(id);
    }

    public Map<class_2960, ShaderProgram> getShaders() {
        return this.shadersView;
    }

    public ShaderSourceSet getSourceSet() {
        return this.sourceSet;
    }

    private ReloadState prepare(class_3300 resourceManager, Collection<class_2960> shaders, int activeBuffers) {
        HashMap<class_2960, ProgramDefinition> definitions = new HashMap<class_2960, ProgramDefinition>();
        HashMap<class_2960, VeilShaderSource> shaderSources = new HashMap<class_2960, VeilShaderSource>();
        this.addProcessors((class_5912)resourceManager);
        for (class_2960 key : shaders) {
            this.readShader(resourceManager, definitions, shaderSources, key, activeBuffers);
        }
        this.processors.clear();
        this.processor = null;
        this.importProcessors.clear();
        this.importProcessor = null;
        return new ReloadState(definitions, shaderSources);
    }

    private void apply(ReloadState reloadState) {
        this.shaders.values().forEach(NativeResource::free);
        this.shaders.clear();
        try (ShaderCompiler compiler = ShaderCompiler.direct(reloadState.shaderSources::get);){
            for (Map.Entry<class_2960, ProgramDefinition> entry : reloadState.definitions().entrySet()) {
                class_2960 id = entry.getKey();
                ShaderProgram program = ShaderProgram.create(id);
                this.compile(program, entry.getValue(), compiler);
                this.shaders.put(id, program);
            }
        }
        VeilRenderSystem.finalizeShaderCompilation();
        Veil.LOGGER.info("Loaded {} shaders from: {}", (Object)this.shaders.size(), (Object)this.sourceSet.getFolder());
    }

    private void applyRecompile(ReloadState reloadState, Collection<class_2960> shaders) {
        try (ShaderCompiler compiler = ShaderCompiler.direct(reloadState.shaderSources::get);){
            for (Map.Entry<class_2960, ProgramDefinition> entry : reloadState.definitions().entrySet()) {
                class_2960 id = entry.getKey();
                ShaderProgram program = this.getShader(id);
                if (program == null) {
                    Veil.LOGGER.warn("Failed to recompile shader: {}", (Object)id);
                    continue;
                }
                this.compile(program, entry.getValue(), compiler);
            }
        }
        VeilRenderSystem.finalizeShaderCompilation();
        Veil.LOGGER.info("Recompiled {} shaders from: {}", (Object)shaders.size(), (Object)this.sourceSet.getFolder());
    }

    private void scheduleRecompile(int attempt) {
        class_310 client = class_310.method_1551();
        client.method_18858(() -> {
            HashSet<class_2960> shaders;
            if (!this.recompileFuture.isDone()) {
                return;
            }
            Set<class_2960> set = this.dirtyShaders;
            synchronized (set) {
                shaders = new HashSet<class_2960>(this.dirtyShaders);
                this.dirtyShaders.clear();
            }
            int activeBuffers = this.dynamicBufferManager.getActiveBuffers();
            this.recompileFuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.prepare(client.method_1478(), shaders, activeBuffers), class_156.method_18349()).thenAcceptAsync(state -> this.applyRecompile((ReloadState)state, (Collection<class_2960>)shaders), (Executor)client)).handle((value, e) -> {
                if (e != null) {
                    Veil.LOGGER.error("Error recompiling shaders", e);
                }
                Set<class_2960> set = this.dirtyShaders;
                synchronized (set) {
                    if (this.dirtyShaders.isEmpty()) {
                        return value;
                    }
                }
                if (attempt >= 3) {
                    Veil.LOGGER.error("Failed to recompile shaders after {} attempts", (Object)attempt);
                    return value;
                }
                this.scheduleRecompile(attempt + 1);
                return value;
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleRecompile(class_2960 shader) {
        Set<class_2960> set = this.dirtyShaders;
        synchronized (set) {
            this.dirtyShaders.add(shader);
        }
        if (!this.recompileFuture.isDone()) {
            return;
        }
        this.scheduleRecompile(0);
    }

    @ApiStatus.Internal
    public void setActiveBuffers(int activeBuffers) {
        ShaderProgram active = null;
        try {
            HashSet<class_2960> shaders = new HashSet<class_2960>();
            Iterator<ShaderProgram> iterator = this.shaders.values().iterator();
            while (iterator.hasNext()) {
                ShaderProgramImpl impl;
                ShaderProgram program;
                active = program = iterator.next();
                if (!(program instanceof ShaderProgramImpl) || !(impl = (ShaderProgramImpl)program).setActiveBuffers(activeBuffers)) continue;
                shaders.add(program.getId());
            }
            if (!shaders.isEmpty()) {
                this.updateBuffersFuture = ((CompletableFuture)this.updateBuffersFuture.thenApplyAsync(unused -> this.prepare(class_310.method_1551().method_1478(), shaders, activeBuffers), (Executor)class_156.method_18349())).thenAcceptAsync(reloadState -> {
                    try (ShaderCompiler compiler = ShaderCompiler.direct(reloadState.shaderSources::get);){
                        for (Map.Entry<class_2960, ProgramDefinition> entry : reloadState.definitions().entrySet()) {
                            class_2960 id = entry.getKey();
                            ShaderProgram program = this.getShader(id);
                            if (!(program instanceof ShaderProgramImpl)) {
                                Veil.LOGGER.warn("Failed to set shader active buffers: {}", (Object)id);
                                continue;
                            }
                            ShaderProgramImpl impl = (ShaderProgramImpl)program;
                            try {
                                impl.updateActiveBuffers(new ShaderCompiler.Context(activeBuffers, this.sourceSet, null), compiler);
                            }
                            catch (ShaderException e) {
                                Veil.LOGGER.error("Failed to create shader {}: {}", (Object)id, (Object)e.getMessage());
                                String error = e.getGlError();
                                if (error == null) continue;
                                Veil.LOGGER.warn(error);
                            }
                            catch (Exception e) {
                                Veil.LOGGER.error("Failed to create shader: {}", (Object)id, (Object)e);
                            }
                        }
                    }
                    VeilRenderSystem.finalizeShaderCompilation();
                    Veil.LOGGER.info("Compiled {} shaders from: {}", (Object)shaders.size(), (Object)this.sourceSet.getFolder());
                }, (Executor)class_310.method_1551());
            }
        }
        catch (ShaderException e) {
            class_128 crashreport = class_128.method_560((Throwable)e, (String)"Setting Active Buffers");
            class_129 crashreportcategory = crashreport.method_562("Linking Program");
            crashreportcategory.method_578("Name", (Object)active.getId());
            String glError = e.getGlError();
            if (glError != null) {
                Veil.LOGGER.error(glError);
            }
            throw new class_148(crashreport);
        }
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        if (this.reloadFuture != null && !this.reloadFuture.isDone()) {
            return this.reloadFuture.thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0));
        }
        int activeBuffers = this.dynamicBufferManager.getActiveBuffers();
        this.reloadFuture = CompletableFuture.allOf(this.recompileFuture, this.updateBuffersFuture).thenCompose(unused -> ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            class_7654 lister = this.sourceSet.getShaderDefinitionLister();
            Set<class_2960> shaderIds = lister.method_45113(resourceManager).keySet().stream().map(arg_0 -> ((class_7654)lister).method_45115(arg_0)).collect(Collectors.toSet());
            return this.prepare(resourceManager, shaderIds, activeBuffers);
        }, backgroundExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0))).thenAcceptAsync(this::apply, gameExecutor));
        return this.reloadFuture;
    }

    public String method_22322() {
        return this.getClass().getSimpleName() + " " + this.getSourceSet().getFolder();
    }

    public CompletableFuture<Void> getReloadFuture() {
        return this.reloadFuture;
    }

    public CompletableFuture<Void> getRecompileFuture() {
        return this.recompileFuture;
    }

    public static String getTypeName(int type) {
        String value = TYPES.get(type);
        return value != null ? value : "0x" + Integer.toHexString(type);
    }

    @Override
    public void close() {
        this.shaders.values().forEach(NativeResource::free);
        this.shaders.clear();
    }

    private record PreProcessorContext(ShaderPreProcessor preProcessor, @Nullable ProgramDefinition definition, ShaderPreDefinitions preDefinitions, int type, Map<String, Integer> uniformBindings, Set<String> dependencies, Set<class_2960> includes, @Nullable class_2960 name, boolean sourceFile) implements ShaderPreProcessor.Context
    {
        @Override
        public String modify(@Nullable class_2960 name, String source) throws IOException {
            PreProcessorContext context = new PreProcessorContext(this.preProcessor, this.definition, this.preDefinitions, this.type, this.uniformBindings, this.dependencies, this.includes, name, false);
            return this.preProcessor.modify(context, source);
        }

        @Override
        public void addUniformBinding(String name, int binding) {
            this.uniformBindings.put(name, binding);
        }

        @Override
        public void addDefinitionDependency(String name) {
            this.dependencies.add(name);
        }

        @Override
        public void addInclude(class_2960 name) {
            this.includes.add(name);
        }

        @Override
        public boolean isSourceFile() {
            return this.sourceFile;
        }

        @Override
        @Nullable
        public String shaderInstance() {
            return null;
        }

        @Override
        @Nullable
        public class_293 vertexFormat() {
            return null;
        }
    }

    private record ReloadState(Map<class_2960, ProgramDefinition> definitions, Map<class_2960, VeilShaderSource> shaderSources) {
    }
}

