/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.necromancer.render.mesh;

import foundry.veil.api.client.necromancer.render.mesh.Mesh;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class CubeMesh
extends Mesh {
    private final List<Mesh.Face> faces;
    final int textureWidth;
    final int textureHeight;

    public CubeMesh(int textureWidth, int textureHeight) {
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.faces = new ArrayList<Mesh.Face>();
    }

    public Mesh.Face[] addCube(float xSize, float ySize, float zSize, float xOffset, float yOffset, float zOffset, float xInflate, float yInflate, float zInflate, float uOffset, float vOffset) {
        return this.addCube(xSize, ySize, zSize, xOffset, yOffset, zOffset, xInflate, yInflate, zInflate, uOffset, vOffset, false);
    }

    public Mesh.Face[] addCube(float xSize, float ySize, float zSize, float xOffset, float yOffset, float zOffset, float xInflate, float yInflate, float zInflate, float uOffset, float vOffset, boolean mirrored) {
        float minX = xOffset;
        float minY = yOffset;
        float minZ = zOffset;
        float maxX = xOffset + xSize;
        float maxY = yOffset + ySize;
        float maxZ = zOffset + zSize;
        minX -= xInflate;
        minY -= yInflate;
        minZ -= zInflate;
        maxX += xInflate;
        maxY += yInflate;
        maxZ += zInflate;
        if (mirrored) {
            float swap = maxX;
            maxX = minX;
            minX = swap;
        }
        Mesh.Vertex ooo = new Mesh.Vertex(minX, minY, minZ);
        Mesh.Vertex xoo = new Mesh.Vertex(maxX, minY, minZ);
        Mesh.Vertex oyo = new Mesh.Vertex(minX, maxY, minZ);
        Mesh.Vertex ooz = new Mesh.Vertex(minX, minY, maxZ);
        Mesh.Vertex xyo = new Mesh.Vertex(maxX, maxY, minZ);
        Mesh.Vertex oyz = new Mesh.Vertex(minX, maxY, maxZ);
        Mesh.Vertex xoz = new Mesh.Vertex(maxX, minY, maxZ);
        Mesh.Vertex xyz = new Mesh.Vertex(maxX, maxY, maxZ);
        float u0 = uOffset;
        float u1 = uOffset + (float)class_3532.method_15375((float)zSize);
        float u2 = uOffset + (float)class_3532.method_15375((float)zSize) + (float)class_3532.method_15375((float)xSize);
        float u3 = uOffset + (float)class_3532.method_15375((float)zSize) + (float)class_3532.method_15375((float)xSize) + (float)class_3532.method_15375((float)xSize);
        float u4 = uOffset + (float)class_3532.method_15375((float)zSize) + (float)class_3532.method_15375((float)xSize) + (float)class_3532.method_15375((float)zSize);
        float u5 = uOffset + (float)class_3532.method_15375((float)zSize) + (float)class_3532.method_15375((float)xSize) + (float)class_3532.method_15375((float)zSize) + (float)class_3532.method_15375((float)xSize);
        float v0 = vOffset;
        float v1 = vOffset + (float)class_3532.method_15375((float)zSize);
        float v2 = vOffset + (float)class_3532.method_15375((float)zSize) + (float)class_3532.method_15375((float)ySize);
        Mesh.Face[] cubeFaces = new Mesh.Face[]{new Mesh.Face(xoz, ooz, ooo, xoo, u3, v0, u2, v1, this.textureWidth, this.textureHeight, mirrored, class_2350.field_11036), new Mesh.Face(xyo, oyo, oyz, xyz, u2, v1, u1, v0, this.textureWidth, this.textureHeight, mirrored, class_2350.field_11033), new Mesh.Face(ooo, ooz, oyz, oyo, u4, v2, u2, v1, this.textureWidth, this.textureHeight, mirrored, class_2350.field_11034), new Mesh.Face(xoz, xoo, xyo, xyz, u1, v2, u0, v1, this.textureWidth, this.textureHeight, mirrored, class_2350.field_11039), new Mesh.Face(ooz, xoz, xyz, oyz, u5, v2, u4, v1, this.textureWidth, this.textureHeight, mirrored, class_2350.field_11043), new Mesh.Face(xoo, ooo, oyo, xyo, u2, v2, u1, v1, this.textureWidth, this.textureHeight, mirrored, class_2350.field_11035)};
        Collections.addAll(this.faces, cubeFaces);
        return cubeFaces;
    }

    public Mesh.Face addTri(float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3, float normalX, float normalY, float normalZ) {
        Mesh.Face face = new Mesh.Face(new Mesh.Vertex[]{new Mesh.Vertex(x1, y1, z1), new Mesh.Vertex(x2, y2, z2), new Mesh.Vertex(x2, y2, z2)}, new Mesh.UV[]{new Mesh.UV(u1, v1), new Mesh.UV(u2, v2), new Mesh.UV(u3, v3)}, new Vector3f(normalX, normalY, normalZ));
        this.faces.add(face);
        return face;
    }

    public Mesh.Face addFace(float normalX, float normalY, float normalZ, FaceVertex ... vertices) {
        Mesh.Vertex[] vertArray = new Mesh.Vertex[vertices.length];
        Mesh.UV[] uvArray = new Mesh.UV[vertices.length];
        for (int i = 0; i < vertices.length; ++i) {
            FaceVertex vertex = vertices[i];
            vertArray[i] = new Mesh.Vertex(vertex.x(), vertex.y(), vertex.z());
            uvArray[i] = new Mesh.UV(vertex.u() / (float)this.textureWidth, vertex.v() / (float)this.textureHeight);
        }
        Mesh.Face face = new Mesh.Face(vertArray, uvArray, new Vector3f(normalX, normalY, normalZ));
        this.faces.add(face);
        return face;
    }

    @Override
    public void render(class_4587 pPoseStack, class_4588 pVertexConsumer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        Matrix4f matrix4f = pPoseStack.method_23760().method_23761();
        Matrix3f matrix3f = pPoseStack.method_23760().method_23762();
        Vector4f position = new Vector4f();
        Vector3f normal = new Vector3f();
        for (Mesh.Face face : this.faces) {
            for (int i = 0; i < face.vertices.length; ++i) {
                Mesh.Vertex vertex = face.vertices[i];
                Mesh.UV uv = face.uvs[i];
                position.set(vertex.x(), vertex.y(), vertex.z(), 1.0f);
                matrix4f.transform(position);
                normal.set(face.normal.x(), face.normal.y(), face.normal.z());
                matrix3f.transform(normal);
                pVertexConsumer.method_22912(position.x(), position.y(), position.z()).method_22915(pRed, pGreen, pBlue, pAlpha).method_22913(uv.u(), uv.v()).method_22922(pPackedOverlay).method_60803(pPackedLight).method_22914(normal.x(), normal.y(), normal.z());
            }
        }
    }

    public record FaceVertex(float x, float y, float z, float u, float v) {
    }
}

