package foundry.veil.api.quasar.emitters.shape;

import org.joml.*;

import java.lang.Math;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5819;

public class Sphere implements EmitterShape {

    @Override
    public Vector3d getPoint(class_5819 randomSource, Vector3fc dimensions, Vector3fc rotation, Vector3dc position, boolean fromSurface) {
        double x = randomSource.method_43058() * 2 - 1;
        double y = randomSource.method_43058() * 2 - 1;
        double z = randomSource.method_43058() * 2 - 1;
        Vector3d normal = new Vector3d(x, y, z).normalize();
        Vector3fc dim = dimensions;
        if (!fromSurface) {
            normal.mul(randomSource.method_43058()).normalize();
            dim = dimensions.mul(
                    randomSource.method_43057(),
                    randomSource.method_43057(),
                    randomSource.method_43057(),
                    new Vector3f()
            );
        }
        Vector3d pos = normal.mul(dim);
        pos = pos.rotateX((float) Math.toRadians(rotation.x())).rotateY((float) Math.toRadians(rotation.y())).rotateZ((float) Math.toRadians(rotation.z()));
        return pos.add(position);
    }

    @Override
    public void renderShape(class_4587 stack, class_4588 consumer, Vector3fc dimensions, Vector3fc rotation) {
        float radius = dimensions.x();
        Matrix4f matrix4f = stack.method_23760().method_23761();
        for(int i = 0; i < 32; i++){
            for(int j = 0; j < 32; j++){
                Vector3f v1 = parametricSphere((float) Math.toRadians(i * 11.25f), (float) Math.toRadians(j * 11.25f), radius);
                Vector3f v2 = parametricSphere((float) Math.toRadians((i + 1) * 11.25f), (float) Math.toRadians(j * 11.25f), radius);
                Vector3f v3 = parametricSphere((float) Math.toRadians(i * 11.25f), (float) Math.toRadians((j + 1) * 11.25f), radius);
                Vector3f v4 = parametricSphere((float) Math.toRadians((i + 1) * 11.25f), (float) Math.toRadians((j + 1) * 11.25f), radius);
                consumer.method_22918(matrix4f, v1.x(), v1.y(), v1.z()).method_22915(0.15f, 0.15f, 1, 1).method_22914(0, 1, 0);
                consumer.method_22918(matrix4f, v2.x(), v2.y(), v2.z()).method_22915(0.15f, 0.15f, 1, 1).method_22914(0, 1, 0);
                consumer.method_22918(matrix4f, v3.x(), v3.y(), v3.z()).method_22915(0.15f, 0.15f, 1, 1).method_22914(0, 1, 0);
                consumer.method_22918(matrix4f, v4.x(), v4.y(), v4.z()).method_22915(0.15f, 0.15f, 1, 1).method_22914(0, 1, 0);
            }
        }
    }
    public static Vector3f parametricSphere(float u, float v, float r) {
        return new Vector3f(class_3532.method_15362(u) * class_3532.method_15374(v) * r, class_3532.method_15362(v) * r, class_3532.method_15374(u) * class_3532.method_15374(v) * r);
    }
}
