package foundry.veil.api.quasar.data.module.init;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import foundry.veil.api.quasar.data.ParticleModuleTypeRegistry;
import foundry.veil.api.quasar.data.module.ModuleType;
import foundry.veil.api.quasar.data.module.ParticleModuleData;
import foundry.veil.api.quasar.emitters.module.InitParticleModule;
import foundry.veil.api.quasar.emitters.module.UpdateParticleModule;
import foundry.veil.api.quasar.particle.ParticleModuleSet;
import net.minecraft.class_2680;
import net.minecraft.class_310;

public record BlockParticleModuleData(boolean dynamic) implements ParticleModuleData {

    public static final MapCodec<BlockParticleModuleData> CODEC = Codec.BOOL.optionalFieldOf("dynamic", true).xmap(BlockParticleModuleData::new, BlockParticleModuleData::dynamic);

    @Override
    public void addModules(ParticleModuleSet.Builder builder) {
        builder.addModule((InitParticleModule) particle -> {
            class_2680 state = particle.getBlockStateInOrUnder();
            if (!state.method_26215()) {
                particle.getRenderData().setAtlasSprite(class_310.method_1551().method_1541().method_3351().method_3339(state));
            }
        });
        if (this.dynamic) {
            builder.addModule((UpdateParticleModule) particle -> {
                class_2680 state = particle.getBlockStateInOrUnder();
                if (!state.method_26215()) {
                    particle.getRenderData().setAtlasSprite(class_310.method_1551().method_1541().method_3351().method_3339(state));
                }
            });
        }
    }

    @Override
    public ModuleType<?> getType() {
        return ParticleModuleTypeRegistry.BLOCK_PARTICLE;
    }
}
