/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.ui.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class PoseStackAnimator {
    private final class_4587 poseStack;
    private final List<AnimationStage> stages = new ArrayList<AnimationStage>();
    private int currentStageIndex = -1;
    private long stageStartTime;

    public PoseStackAnimator(class_4587 poseStack) {
        this.poseStack = poseStack;
    }

    public void addStage(long durationMillis, BiConsumer<Long, class_4587> transform) {
        this.stages.add(new AnimationStage(durationMillis, transform));
    }

    public void startAnimation() {
        this.currentStageIndex = 0;
        this.stageStartTime = System.currentTimeMillis();
    }

    public void tickAnimation() {
        if (this.isAnimating()) {
            AnimationStage currentStage = this.stages.get(this.currentStageIndex);
            long elapsedStageTime = System.currentTimeMillis() - this.stageStartTime;
            float progress = class_3532.method_15363((float)((float)elapsedStageTime / (float)currentStage.durationMillis), (float)0.0f, (float)1.0f);
            this.applyStageTransform(currentStage, progress);
            if (progress >= 1.0f && this.currentStageIndex < this.stages.size() - 1) {
                ++this.currentStageIndex;
                this.stageStartTime = System.currentTimeMillis();
            } else if (progress >= 1.0f) {
                this.resetAnimation();
            }
        }
    }

    public boolean isAnimating() {
        return this.currentStageIndex >= 0 && this.currentStageIndex < this.stages.size();
    }

    public void resetAnimation() {
        this.currentStageIndex = -1;
        this.stages.clear();
    }

    private void applyStageTransform(AnimationStage stage, float progress) {
        this.poseStack.method_22903();
        long elapsedStageTime = (long)(progress * (float)stage.durationMillis);
        stage.transform.accept(elapsedStageTime, this.poseStack);
        this.poseStack.method_22909();
    }

    private static class AnimationStage {
        long durationMillis;
        BiConsumer<Long, class_4587> transform;

        AnimationStage(long durationMillis, BiConsumer<Long, class_4587> transform) {
            this.durationMillis = durationMillis;
            this.transform = transform;
        }
    }
}

