/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.deferred;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.VeilClient;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.deferred.light.renderer.LightRenderer;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.FramebufferManager;
import foundry.veil.api.client.render.framebuffer.VeilFramebuffers;
import foundry.veil.api.client.render.post.PostPipeline;
import foundry.veil.api.client.render.post.PostProcessingManager;
import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.client.render.shader.definition.ShaderPreDefinitions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_5250;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.system.NativeResource;

public class VeilDeferredRenderer
implements class_3302,
NativeResource {
    public static final class_2960 PACK_ID = Veil.veilPath("deferred");
    public static final String DISABLE_VANILLA_ENTITY_LIGHT_KEY = "DISABLE_VANILLA_ENTITY_LIGHT";
    public static final class_2960 OPAQUE_POST = Veil.veilPath("core/opaque");
    public static final class_2960 LIGHT_POST = Veil.veilPath("core/light");
    public static final class_2960 OPAQUE_MIX = Veil.veilPath("core/mix_opaque");
    public static final class_2960 TRANSPARENT_MIX = Veil.veilPath("core/mix_transparent");
    public static final class_2960 TRANSPARENT_POST = Veil.veilPath("core/transparent");
    public static final class_2960 SCREEN_POST = Veil.veilPath("core/screen");
    public static final class_5250 UNSUPPORTED_TITLE = class_2561.method_43471((String)"veil.deferred.unsupported.title");
    public static final class_5250 UNSUPPORTED_SODIUM_DESC = class_2561.method_43471((String)"veil.deferred.unsupported.sodium_desc");
    public static final class_5250 UNSUPPORTED_FABULOUS_DESC = class_2561.method_43471((String)"veil.deferred.unsupported.fabulous_desc");
    private final ShaderManager deferredShaderManager;
    private final ShaderPreDefinitions shaderPreDefinitions;
    private final FramebufferManager framebufferManager;
    private final PostProcessingManager postProcessingManager;
    private final LightRenderer lightRenderer;
    private boolean enabled;
    private RendererState state;

    public VeilDeferredRenderer(ShaderManager deferredShaderManager, ShaderPreDefinitions shaderPreDefinitions, FramebufferManager framebufferManager, PostProcessingManager postProcessingManager) {
        this.deferredShaderManager = deferredShaderManager;
        this.shaderPreDefinitions = shaderPreDefinitions;
        this.framebufferManager = framebufferManager;
        this.postProcessingManager = postProcessingManager;
        this.lightRenderer = new LightRenderer();
        this.enabled = false;
        this.state = RendererState.INACTIVE;
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.supplyAsync(() -> {
            boolean active;
            boolean selected = class_310.method_1551().method_1520().method_29210().contains(PACK_ID.toString()) || resourceManager.method_29213().anyMatch(pack -> pack.method_14409().equals(PACK_ID.toString()));
            boolean bl = active = selected && VeilDeferredRenderer.isSupported();
            if (selected && class_310.method_29611()) {
                class_370.method_27024((class_374)class_310.method_1551().method_1566(), (class_370.class_9037)VeilClient.UNSUPPORTED_NOTIFICATION, (class_2561)UNSUPPORTED_TITLE, (class_2561)UNSUPPORTED_FABULOUS_DESC);
            }
            if (this.enabled != active) {
                this.enabled = active;
                if (active) {
                    Veil.LOGGER.info("Deferred Renderer Enabled");
                } else {
                    Veil.LOGGER.info("Deferred Renderer Disabled");
                    return preparationBarrier.method_18352(null).thenRunAsync(this::free, gameExecutor);
                }
            }
            if (this.enabled) {
                return this.deferredShaderManager.method_25931(preparationBarrier, resourceManager, prepareProfiler, applyProfiler, backgroundExecutor, gameExecutor);
            }
            return preparationBarrier.method_18352(null);
        }, gameExecutor).thenCompose(future -> future);
    }

    public void free() {
        this.enabled = false;
        this.state = RendererState.INACTIVE;
        this.deferredShaderManager.close();
        this.lightRenderer.free();
    }

    @ApiStatus.Internal
    public void reset() {
        this.lightRenderer.free();
    }

    @ApiStatus.Internal
    public void setup() {
        if (!this.isEnabled() || this.state == RendererState.DISABLED) {
            return;
        }
        switch (this.state.ordinal()) {
            case 2: {
                AdvancedFbo deferredFramebuffer = this.framebufferManager.getFramebuffer(VeilFramebuffers.OPAQUE);
                if (deferredFramebuffer == null) {
                    Veil.LOGGER.error("Missing deferred opaque buffer");
                    this.free();
                    return;
                }
                deferredFramebuffer.bind(true);
                break;
            }
            case 3: {
                AdvancedFbo transparent = this.framebufferManager.getFramebuffer(VeilFramebuffers.TRANSPARENT);
                if (transparent == null) {
                    Veil.LOGGER.error("Missing deferred transparent buffer");
                    this.free();
                    return;
                }
                transparent.bind(true);
            }
        }
    }

    @ApiStatus.Internal
    public void clear() {
        if (!this.isEnabled() || this.state == RendererState.DISABLED) {
            return;
        }
        switch (this.state.ordinal()) {
            case 2: 
            case 3: {
                AdvancedFbo.unbind();
            }
        }
    }

    @ApiStatus.Internal
    public void beginOpaque() {
        if (!this.isEnabled() || this.state == RendererState.DISABLED) {
            return;
        }
        this.state = RendererState.OPAQUE;
        AdvancedFbo deferred = this.framebufferManager.getFramebuffer(VeilFramebuffers.OPAQUE);
        if (deferred == null) {
            Veil.LOGGER.error("Missing deferred opaque buffer");
            this.free();
        }
    }

    @ApiStatus.Internal
    public void beginTranslucent() {
        if (!this.isEnabled() || this.state == RendererState.DISABLED) {
            return;
        }
        this.state = RendererState.TRANSLUCENT;
        AdvancedFbo transparent = this.framebufferManager.getFramebuffer(VeilFramebuffers.TRANSPARENT);
        if (transparent == null) {
            Veil.LOGGER.error("Missing deferred transparent buffer");
            this.free();
            return;
        }
        AdvancedFbo deferredFramebuffer = this.framebufferManager.getFramebuffer(VeilFramebuffers.OPAQUE);
        if (deferredFramebuffer != null) {
            deferredFramebuffer.resolveToAdvancedFbo(transparent, 256, 9728);
        }
    }

    private void run(class_3695 profiler, AdvancedFbo deferred, AdvancedFbo light, class_2960 post, class_2960 mix) {
        PostPipeline mixPipeline;
        PostPipeline postPipeline = this.postProcessingManager.getPipeline(post);
        if (postPipeline != null) {
            profiler.method_15396("post");
            this.postProcessingManager.runPipeline(postPipeline, false);
            profiler.method_15407();
        }
        profiler.method_15396("draw_lights");
        light.bind(true);
        this.lightRenderer.render(deferred);
        profiler.method_15407();
        PostPipeline lightPipeline = this.postProcessingManager.getPipeline(LIGHT_POST);
        if (lightPipeline != null) {
            profiler.method_15396("light_post");
            this.postProcessingManager.runPipeline(lightPipeline, false);
            profiler.method_15407();
        }
        if ((mixPipeline = this.postProcessingManager.getPipeline(mix)) != null) {
            profiler.method_15396("mix");
            this.postProcessingManager.runPipeline(mixPipeline, false);
            profiler.method_15407();
        }
    }

    @ApiStatus.Internal
    public void blit() {
        if (!this.isEnabled() || this.state == RendererState.DISABLED) {
            AdvancedFbo postFramebuffer = VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(VeilFramebuffers.POST);
            if (postFramebuffer != null) {
                AdvancedFbo.getMainFramebuffer().resolveToAdvancedFbo(postFramebuffer);
            }
            return;
        }
        class_3695 profiler = class_310.method_1551().method_16011();
        profiler.method_15396("veil_deferred");
        this.end();
        AdvancedFbo deferred = this.framebufferManager.getFramebuffer(VeilFramebuffers.OPAQUE);
        AdvancedFbo transparent = this.framebufferManager.getFramebuffer(VeilFramebuffers.TRANSPARENT);
        AdvancedFbo deferredLight = this.framebufferManager.getFramebuffer(VeilFramebuffers.OPAQUE_LIGHT);
        AdvancedFbo transparentLight = this.framebufferManager.getFramebuffer(VeilFramebuffers.TRANSPARENT_LIGHT);
        AdvancedFbo post = this.framebufferManager.getFramebuffer(VeilFramebuffers.POST);
        if (deferred == null || transparent == null || deferredLight == null || transparentLight == null || post == null) {
            Veil.LOGGER.error("Missing deferred light buffers");
            this.free();
            return;
        }
        profiler.method_15396("setup_lights");
        this.lightRenderer.setup(VeilRenderer.getCullingFrustum());
        profiler.method_15405("opaque_light");
        this.run(profiler, deferred, deferredLight, OPAQUE_POST, OPAQUE_MIX);
        profiler.method_15405("transparent_light");
        this.run(profiler, transparent, transparentLight, TRANSPARENT_POST, TRANSPARENT_MIX);
        profiler.method_15407();
        this.lightRenderer.clear();
        profiler.method_15396("screen_post");
        PostPipeline screenPipeline = this.postProcessingManager.getPipeline(SCREEN_POST);
        if (screenPipeline != null) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            this.postProcessingManager.runPipeline(screenPipeline, false);
            RenderSystem.disableBlend();
        }
        profiler.method_15407();
        profiler.method_15407();
    }

    @ApiStatus.Internal
    public void end() {
        if (!this.isEnabled() || this.state == RendererState.DISABLED) {
            return;
        }
        this.state = RendererState.INACTIVE;
    }

    @ApiStatus.Internal
    public void addDebugInfo(Consumer<String> consumer) {
        boolean ambientOcclusion = this.lightRenderer.isAmbientOcclusionEnabled();
        boolean vanillaLights = this.lightRenderer.isVanillaLightEnabled();
        boolean vanillaEntityLights = this.shaderPreDefinitions.getDefinition(DISABLE_VANILLA_ENTITY_LIGHT_KEY) == null;
        consumer.accept("Ambient Occlusion: " + (ambientOcclusion ? String.valueOf(class_124.field_1060) + "On" : String.valueOf(class_124.field_1061) + "Off"));
        consumer.accept("Vanilla Light: " + (vanillaLights ? String.valueOf(class_124.field_1060) + "On" : String.valueOf(class_124.field_1061) + "Off"));
        consumer.accept("Vanilla Entity Light: " + (vanillaEntityLights ? String.valueOf(class_124.field_1060) + "On" : String.valueOf(class_124.field_1061) + "Off"));
        this.lightRenderer.addDebugInfo(consumer);
    }

    public void enable() {
        this.state = RendererState.INACTIVE;
    }

    public void disable() {
        this.state = RendererState.DISABLED;
    }

    public boolean isEnabled() {
        return this.enabled && VeilDeferredRenderer.isSupported();
    }

    public static boolean isSupported() {
        return !class_310.method_29611() && !Veil.SODIUM;
    }

    public boolean isActive() {
        return this.isEnabled() && this.state.isActive();
    }

    public LightRenderer getLightRenderer() {
        return this.lightRenderer;
    }

    public RendererState getRendererState() {
        return this.state;
    }

    public ShaderManager getDeferredShaderManager() {
        return this.deferredShaderManager;
    }

    public static enum RendererState {
        DISABLED,
        INACTIVE,
        OPAQUE,
        TRANSLUCENT;


        public boolean isActive() {
            return this == OPAQUE || this == TRANSLUCENT;
        }
    }
}

