package foundry.veil.api.resource;

import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_5912;

public interface VeilResourceLoader {

    /**
     * Checks if the specified resource can load.
     *
     * @param packType        The type of pack the resource was loaded from
     * @param location        The path to load the resource from
     * @param filePath        The file path of the resource
     * @param modResourcePath The path to this resource in the build folder if in a dev environment
     * @return If this resource loader recognizes and can load the specified extension
     */
    boolean canLoad(class_3264 packType, class_2960 location, @Nullable Path filePath, @Nullable Path modResourcePath);

    /**
     * Loads the resource from the specified path.
     *
     * @param resourceManager The Veil resource manager instance
     * @param provider        The provider for vanilla resources
     * @param packType        The type of pack the resource was loaded from
     * @param location        The path to load the resource from
     * @param filePath        The file path of the resource
     * @param modResourcePath The path to this resource in the build folder if in a dev environment
     * @return The loaded resource
     */
    VeilResource<?> load(VeilResourceManager resourceManager, class_5912 provider, class_3264 packType, class_2960 location, @Nullable Path filePath, @Nullable Path modResourcePath) throws IOException;
}
