package foundry.veil.api.client.render.shader.processor;

import foundry.veil.api.client.render.shader.ShaderManager;
import org.apache.commons.io.IOUtils;

import java.io.IOException;
import java.io.Reader;
import java.util.*;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_5912;

/**
 * Processes a shader to add imports.
 *
 * @author Ocelot
 */
public class ShaderImportProcessor implements ShaderPreProcessor {

    private static final String INCLUDE_KEY = "#include ";

    private final class_5912 resourceProvider;
    private final Set<class_2960> addedImports;
    private final Map<class_2960, String> imports;
    private final List<class_2960> importOrder;
    private int layer;

    /**
     * Creates a new import processor that loads import files from the specified resource provider.
     *
     * @param resourceProvider The provider for import resources
     */
    public ShaderImportProcessor(class_5912 resourceProvider) {
        this.resourceProvider = resourceProvider;
        this.addedImports = new HashSet<>();
        this.imports = new HashMap<>();
        this.importOrder = new ArrayList<>();
        this.layer = 0;
    }

    @Override
    public void prepare() {
        this.addedImports.clear();
    }

    @Override
    public String modify(Context context, String source) throws IOException {
        List<String> inputLines = source.lines().toList();
        List<String> output = new LinkedList<>();

        for (String line : inputLines) {
            if (!line.startsWith(ShaderImportProcessor.INCLUDE_KEY)) {
                output.add(line);
                continue;
            }

            try {
                String trimmedImport = line.substring(ShaderImportProcessor.INCLUDE_KEY.length()).trim();
                class_2960 include = class_2960.method_60654(trimmedImport);
                context.addInclude(include);

                // Only read and process the import if it hasn't been added yet
                if (!this.addedImports.add(include)) {
                    continue;
                }

                try {
                    if (!this.imports.containsKey(include)) {
                        this.imports.put(include, this.loadImport(include));
                        this.importOrder.add(include);
                    }

                    String importString = this.imports.get(include);
                    if (importString == null) {
                        throw new IOException("Import previously failed to load");
                    }

                    long lineNumber = String.join("\n", output).lines().count();
                    int sourceNumber = this.importOrder.indexOf(include) + 1;
//                    output.add("#line 0 " + sourceNumber);
                    this.layer++;
                    output.add(context.modify(include, importString));
                    this.layer--;
//                    output.add("#line " + lineNumber + " " + (this.layer == 0 ? 0 : sourceNumber));
//                    output.add("#line " + lineNumber);
                } catch (Exception e) {
                    throw new IOException("Failed to add import: " + line, e);
                }
            } catch (class_151 e) {
                throw new IOException("Invalid import: " + line, e);
            }
        }

        return String.join("\n", output);
    }

    private String loadImport(class_2960 source) throws IOException {
        class_3298 resource = this.resourceProvider.getResourceOrThrow(ShaderManager.INCLUDE_LISTER.method_45112(source));
        try (Reader reader = resource.method_43039()) {
            return IOUtils.toString(reader);
        }
    }
}
