/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.texture;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.shader.texture.ShaderTextureSource;
import net.minecraft.class_2960;

public record FramebufferSource(class_2960 name, int sampler, boolean depth) implements ShaderTextureSource
{
    public static final MapCodec<FramebufferSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(source -> source.name.toString()), (App)Codec.INT.optionalFieldOf("sampler", (Object)0).forGetter(FramebufferSource::sampler)).apply((Applicative)instance, (name, sampler) -> {
        boolean depth = name.endsWith(":depth");
        String path = depth ? name.substring(0, name.length() - 6) : name;
        class_2960 location = name.contains(":") ? class_2960.method_60654((String)path) : class_2960.method_60655((String)"temp", (String)name);
        return new FramebufferSource(location, depth ? 0 : sampler, depth);
    }));

    @Override
    public int getId(ShaderTextureSource.Context context) {
        AdvancedFbo framebuffer = context.getFramebuffer(this.name);
        if (framebuffer == null) {
            return 0;
        }
        if (this.depth) {
            return framebuffer.isDepthTextureAttachment() ? framebuffer.getDepthTextureAttachment().method_4624() : 0;
        }
        return framebuffer.isColorTextureAttachment(this.sampler) ? framebuffer.getColorTextureAttachment(this.sampler).method_4624() : 0;
    }

    @Override
    public ShaderTextureSource.Type getType() {
        return ShaderTextureSource.Type.FRAMEBUFFER;
    }
}

