package foundry.veil.fabric.platform;

import foundry.veil.platform.registry.RegistrationProvider;
import foundry.veil.platform.registry.RegistryObject;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;

@ApiStatus.Internal
public class FabricRegistrationFactory implements RegistrationProvider.Factory {

    @SuppressWarnings("unchecked")
    @Override
    public <T> RegistrationProvider<T> create(class_5321<? extends class_2378<T>> key, String modId) {
        class_2378<?> reg = class_7923.field_41167.method_10223(key.method_29177());
        if (reg == null) {
            reg = FabricRegistryBuilder.createSimple((class_5321<class_2378<T>>) key).buildAndRegister();
        }
        return new Provider<>(modId, (class_2378<T>) reg);
    }

    @Override
    public <T> RegistrationProvider<T> create(class_2378<T> registry, String modId) {
        return new Provider<>(modId, registry);
    }

    private static class Provider<T> implements RegistrationProvider<T> {

        private final String modId;
        private final class_2378<T> registry;

        private final Set<RegistryObject<T>> entries = new HashSet<>();
        private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries);

        private Provider(String modId, class_2378<T> registry) {
            this.modId = modId;
            this.registry = registry;
        }

        @Override
        @SuppressWarnings("unchecked")
        public <I extends T> RegistryObject<I> register(class_2960 id, Supplier<? extends I> supplier) {
            RegistryObject<I> old = (RegistryObject<I>) this.registry.method_10223(id);
            if (old != null) {
                return old;
            }

            I obj = class_2378.method_10230(this.registry, id, supplier.get());
            class_5321<I> key = class_5321.method_29179((class_5321<? extends class_2378<I>>) this.registry.method_30517(), id);

            RegistryObject<I> ro = new RegistryObject<>() {

                @Override
                public class_5321<I> getResourceKey() {
                    return key;
                }

                @Override
                public class_2960 getId() {
                    return id;
                }

                @Override
                public boolean isPresent() {
                    return true;
                }

                @Override
                public I get() {
                    return obj;
                }

                @Override
                public class_6880<I> asHolder() {
                    return (class_6880<I>) Provider.this.registry.method_40290((class_5321<T>) key);
                }
            };
            this.entries.add((RegistryObject<T>) ro);
            return ro;
        }

        @Override
        public Collection<RegistryObject<T>> getEntries() {
            return this.entriesView;
        }

        @Override
        public class_2378<T> asVanillaRegistry() {
            return this.registry;
        }

        @Override
        public String getModId() {
            return this.modId;
        }
    }
}