package foundry.veil.fabric.mixin.client.deferred.vanilla;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1921;
import net.minecraft.class_284;
import net.minecraft.class_5944;
import net.minecraft.class_761;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_761.class)
public class LevelRendererMixin {

    @Inject(method = "renderSectionLayer", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/systems/RenderSystem;getShader()Lnet/minecraft/client/renderer/ShaderInstance;", shift = At.Shift.AFTER))
    public void updateUniforms(class_1921 renderType, double x, double y, double z, Matrix4f frustrumMatrix, Matrix4f projectionMatrix, CallbackInfo ci) {
        class_5944 shader = RenderSystem.getShader();
        class_284 iModelViewMat = shader.method_34582("NormalMat");
        if (iModelViewMat != null) {
            iModelViewMat.method_39978(frustrumMatrix.normal(new Matrix3f()));
        }
    }
}
