package foundry.veil.api.resource;

import foundry.veil.api.resource.type.McMetaResource;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_7368;
import org.jetbrains.annotations.Nullable;

public interface VeilResourceManager {

    default class_3300 resources(VeilResourceInfo resourceInfo) {
        return resourceInfo.packType() == class_3264.field_14190 ? this.serverResources() : this.clientResources();
    }

    class_3300 clientResources();

    class_3300 serverResources();

    @Nullable
    VeilResource<?> getVeilResource(String namespace, String path);

    default @Nullable VeilResource<?> getVeilResource(class_2960 location) {
        return this.getVeilResource(location.method_12836(), location.method_12832());
    }

    default @Nullable class_7368 getResourceMetadata(class_2960 location) {
        return this.getResourceMetadata(location.method_12836(), location.method_12832());
    }

    default @Nullable class_7368 getResourceMetadata(String namespace, String path) {
        VeilResource<?> resource = this.getVeilResource(namespace, path);
        return resource instanceof McMetaResource mcMetaResource ? mcMetaResource.metadata() : null;
    }
}
