package foundry.veil.api.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.deferred.VeilDeferredRenderer;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.ext.RenderTargetExtension;
import foundry.veil.impl.client.render.LevelPerspectiveCamera;
import foundry.veil.mixin.accessor.GameRendererAccessor;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;
import org.joml.*;

/**
 * Renders the level from different perspectives.
 *
 * @author Ocelot
 */
public final class VeilLevelPerspectiveRenderer {

    private static final LevelPerspectiveCamera CAMERA = new LevelPerspectiveCamera();
    private static final Matrix4f TRANSFORM = new Matrix4f();

    private static final Matrix4f BACKUP_PROJECTION = new Matrix4f();
    private static final Vector3f BACKUP_LIGHT0_POSITION = new Vector3f();
    private static final Vector3f BACKUP_LIGHT1_POSITION = new Vector3f();

    private static boolean renderingPerspective = false;

    private VeilLevelPerspectiveRenderer() {
    }

    /**
     * Renders the level from another POV. Automatically prevents circular render references.
     *
     * @param framebuffer       The framebuffer to draw into
     * @param modelView         The base modelview matrix
     * @param projection        The projection matrix
     * @param cameraPosition    The position of the camera
     * @param cameraOrientation The orientation of the camera
     * @param renderDistance    The chunk render distance
     * @param deltaTracker      The delta tracker instance
     */
    public static void render(AdvancedFbo framebuffer, Matrix4fc modelView, Matrix4fc projection, Vector3dc cameraPosition, Quaternionfc cameraOrientation, float renderDistance, class_9779 deltaTracker) {
        render(framebuffer, class_310.method_1551().field_1719, modelView, projection, cameraPosition, cameraOrientation, renderDistance, deltaTracker);
    }

    /**
     * Renders the level from another POV. Automatically prevents circular render references.
     *
     * @param framebuffer       The framebuffer to draw into
     * @param cameraEntity      The entity to draw the camera in relation to. If unsure use {@link #render(AdvancedFbo, Matrix4fc, Matrix4fc, Vector3dc, Quaternionfc, float, class_9779)}
     * @param modelView         The base modelview matrix
     * @param projection        The projection matrix
     * @param cameraPosition    The position of the camera
     * @param cameraOrientation The orientation of the camera
     * @param renderDistance    The chunk render distance
     * @param deltaTracker      The delta tracker instance
     */
    public static void render(AdvancedFbo framebuffer, @Nullable class_1297 cameraEntity, Matrix4fc modelView, Matrix4fc projection, Vector3dc cameraPosition, Quaternionfc cameraOrientation, float renderDistance, class_9779 deltaTracker) {
        if (renderingPerspective) {
            return;
        }

        class_310 minecraft = class_310.method_1551();
        class_757 gameRenderer = minecraft.field_1773;
        class_761 levelRenderer = minecraft.field_1769;
        class_1041 window = minecraft.method_22683();
        GameRendererAccessor accessor = (GameRendererAccessor) gameRenderer;
        RenderTargetExtension renderTargetExtension = (RenderTargetExtension) minecraft.method_1522();

        CAMERA.setup(cameraPosition, cameraEntity, minecraft.field_1687, cameraOrientation);

        class_4587 poseStack = new class_4587();

        poseStack.method_34425(TRANSFORM.set(modelView));
        poseStack.method_22907(CAMERA.method_23767());

        float backupRenderDistance = gameRenderer.method_3193();
        accessor.setRenderDistance(renderDistance);

        int backupWidth = window.method_4489();
        int backupHeight = window.method_4506();
        window.method_35642(framebuffer.getWidth());
        window.method_35643(framebuffer.getHeight());

        VeilDeferredRenderer deferredRenderer = VeilRenderSystem.renderer().getDeferredRenderer();
        boolean backupEnabled = deferredRenderer.isEnabled();
        if (backupEnabled) {
            deferredRenderer.disable();
        }

        BACKUP_PROJECTION.set(RenderSystem.getProjectionMatrix());
        gameRenderer.method_22709(TRANSFORM.set(projection));
        BACKUP_LIGHT0_POSITION.set(VeilRenderSystem.getLight0Position());
        BACKUP_LIGHT1_POSITION.set(VeilRenderSystem.getLight1Position());

        class_239 backupHitResult = minecraft.field_1765;
        class_1297 backupCrosshairPickEntity = minecraft.field_1692;

        renderingPerspective = true;
        framebuffer.bindDraw(true);
        renderTargetExtension.veil$setWrapper(framebuffer);
        levelRenderer.method_32133(new class_243(cameraPosition.x(), cameraPosition.y(), cameraPosition.z()), TRANSFORM, poseStack.method_23760().method_23761());
        levelRenderer.method_22710(deltaTracker, false, CAMERA, gameRenderer, gameRenderer.method_22974(), poseStack.method_23760().method_23761(), TRANSFORM);
        levelRenderer.method_3254();
        renderTargetExtension.veil$setWrapper(null);
        AdvancedFbo.unbind();
        renderingPerspective = false;

        minecraft.field_1692 = backupCrosshairPickEntity;
        minecraft.field_1765 = backupHitResult;

        RenderSystem.setShaderLights(BACKUP_LIGHT0_POSITION, BACKUP_LIGHT1_POSITION);
        gameRenderer.method_22709(BACKUP_PROJECTION);

        window.method_35642(backupWidth);
        window.method_35643(backupHeight);

        if (backupEnabled) {
            deferredRenderer.enable();
        }

        accessor.setRenderDistance(backupRenderDistance);
    }

    /**
     * @return Whether a perspective is being rendered
     */
    public static boolean isRenderingPerspective() {
        return renderingPerspective;
    }
}
