/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.CompiledShader;
import foundry.veil.api.client.render.shader.ShaderCompiler;
import foundry.veil.api.client.render.shader.ShaderException;
import foundry.veil.api.client.render.shader.program.MutableUniformAccess;
import foundry.veil.api.client.render.shader.program.ProgramDefinition;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.client.render.shader.program.TextureUniformAccess;
import foundry.veil.api.client.render.shader.texture.ShaderTextureSource;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_276;
import net.minecraft.class_284;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3298;
import net.minecraft.class_5944;
import net.minecraft.class_9226;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.opengl.GL31C;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.system.MemoryUtil;

@ApiStatus.Internal
public class ShaderProgramImpl
implements ShaderProgram {
    private final class_2960 id;
    private final Int2ObjectMap<CompiledShader> shaders;
    private final Object2IntMap<CharSequence> uniforms;
    private final Object2IntMap<CharSequence> uniformBlocks;
    private final Object2IntMap<CharSequence> storageBlocks;
    private final Map<String, ShaderTextureSource> textureSources;
    private final Set<String> definitionDependencies;
    private final TextureCache textures;
    private final Supplier<Wrapper> wrapper;
    private ProgramDefinition definition;
    private int program;

    public ShaderProgramImpl(class_2960 id) {
        this.id = id;
        this.shaders = new Int2ObjectArrayMap(2);
        this.uniforms = new Object2IntArrayMap();
        this.uniformBlocks = new Object2IntArrayMap();
        this.storageBlocks = new Object2IntArrayMap();
        this.textures = new TextureCache(this);
        this.textureSources = new HashMap<String, ShaderTextureSource>();
        this.definitionDependencies = new HashSet<String>();
        this.wrapper = Suppliers.memoize(() -> {
            Wrapper.constructing = true;
            try {
                Wrapper wrapper = new Wrapper(this);
                return wrapper;
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to wrap shader program: " + String.valueOf(this.getId()), e);
            }
            finally {
                Wrapper.constructing = false;
            }
        });
    }

    private void clearShader() {
        if (this.program != 0) {
            this.shaders.values().forEach(shader -> GL43C.glDetachShader((int)this.program, (int)shader.id()));
        }
        this.shaders.clear();
        this.uniforms.clear();
        this.uniformBlocks.clear();
        this.textures.clear();
        this.textureSources.clear();
        this.definitionDependencies.clear();
    }

    @Override
    public void compile(ShaderCompiler.Context context, ShaderCompiler compiler) throws Exception {
        this.definition = Objects.requireNonNull(context.definition());
        this.clearShader();
        this.textureSources.putAll(this.definition.textures());
        if (this.program == 0) {
            this.program = GL43C.glCreateProgram();
        }
        try {
            Int2ObjectMap<ProgramDefinition.ShaderSource> shaders = this.definition.shaders();
            for (Int2ObjectMap.Entry entry : shaders.int2ObjectEntrySet()) {
                int glType = entry.getIntKey();
                ProgramDefinition.ShaderSource source = (ProgramDefinition.ShaderSource)entry.getValue();
                CompiledShader shader2 = compiler.compile(context, glType, source.sourceType(), source.location());
                GL43C.glAttachShader((int)this.program, (int)shader2.id());
                this.shaders.put(glType, (Object)shader2);
            }
            if (class_310.field_1703 && !shaders.containsKey(37305) && !shaders.containsKey(35632)) {
                CompiledShader shader3 = compiler.compile(context, 35632, ProgramDefinition.SourceType.GLSL, "out vec4 fragColor;void main(){fragColor=vec4(1.0);}");
                GL43C.glAttachShader((int)this.program, (int)shader3.id());
                this.shaders.put(35632, (Object)shader3);
            }
            GL43C.glLinkProgram((int)this.program);
            if (GL43C.glGetProgrami((int)this.program, (int)35714) != 1) {
                String log = GL43C.glGetProgramInfoLog((int)this.program);
                throw new ShaderException("Failed to link shader", log);
            }
            this.shaders.values().forEach(shader -> {
                shader.apply(this);
                this.definitionDependencies.addAll(shader.definitionDependencies());
            });
        }
        catch (Exception e) {
            this.clearShader();
            throw e;
        }
    }

    public void free() {
        this.clearShader();
        if (this.program > 0) {
            GL43C.glDeleteProgram((int)this.program);
            this.program = 0;
        }
    }

    @Override
    public Int2ObjectMap<CompiledShader> getShaders() {
        return this.shaders;
    }

    @Override
    public Set<String> getDefinitionDependencies() {
        return this.definitionDependencies;
    }

    @Override
    public class_2960 getId() {
        return this.id;
    }

    @Override
    public Wrapper toShaderInstance() {
        return this.wrapper.get();
    }

    @Override
    public int getUniform(CharSequence name) {
        if (this.program == 0) {
            return -1;
        }
        return this.uniforms.computeIfAbsent((Object)name, k -> GL43C.glGetUniformLocation((int)this.program, (CharSequence)k));
    }

    @Override
    public int getUniformBlock(CharSequence name) {
        if (this.program == 0) {
            return -1;
        }
        return this.uniformBlocks.computeIfAbsent((Object)name, k -> GL31C.glGetUniformBlockIndex((int)this.program, (CharSequence)name));
    }

    @Override
    public int getStorageBlock(CharSequence name) {
        if (this.program == 0) {
            return -1;
        }
        return this.storageBlocks.computeIfAbsent((Object)name, k -> GL43C.glGetProgramResourceIndex((int)this.program, (int)37606, (CharSequence)name));
    }

    @Override
    public int getProgram() {
        return this.program;
    }

    @Override
    @Nullable
    public ProgramDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public int applyShaderSamplers(@Nullable ShaderTextureSource.Context context, int sampler) {
        if (context != null) {
            this.textureSources.forEach((name, source) -> this.addSampler((CharSequence)name, source.getId(context)));
        }
        return this.textures.bind(sampler);
    }

    @Override
    public void addSamplerListener(TextureUniformAccess.SamplerListener listener) {
        this.textures.addSamplerListener(listener);
    }

    @Override
    public void removeSamplerListener(TextureUniformAccess.SamplerListener listener) {
        this.textures.removeSamplerListener(listener);
    }

    @Override
    public void addSampler(CharSequence name, int textureId) {
        this.textures.put(name, textureId);
    }

    @Override
    public void removeSampler(CharSequence name) {
        this.textures.remove(name);
    }

    @Override
    public void clearSamplers() {
        this.textures.clear();
    }

    private static class TextureCache {
        private final ShaderProgram program;
        private final Object2IntMap<CharSequence> textures;
        private final Object2IntMap<CharSequence> boundSamplers;
        private final ObjectSet<TextureUniformAccess.SamplerListener> listeners;
        private boolean dirty;
        private IntBuffer bindings;

        private TextureCache(ShaderProgram program) {
            this.program = program;
            this.textures = new Object2IntArrayMap();
            this.textures.defaultReturnValue(-1);
            this.boundSamplers = new Object2IntArrayMap();
            this.listeners = new ObjectArraySet();
            this.bindings = null;
        }

        private int uploadTextures(int start, BiConsumer<Integer, Integer> textureConsumer) {
            this.boundSamplers.clear();
            if (this.textures.isEmpty()) {
                return start;
            }
            int maxSampler = VeilRenderSystem.maxCombinedTextureUnits();
            int count = 1;
            textureConsumer.accept(start, class_1047.method_4540().method_4624());
            for (Object2IntMap.Entry entry : this.textures.object2IntEntrySet()) {
                CharSequence name = (CharSequence)entry.getKey();
                if (this.program.getUniform(name) == -1) continue;
                int sampler = start + count;
                if (sampler >= maxSampler) {
                    this.program.setInt(name, 0);
                    Veil.LOGGER.error("Too many samplers were bound for shader (max {}): {}", (Object)maxSampler, (Object)this.program.getId());
                    continue;
                }
                int textureId = entry.getIntValue();
                if (textureId == 0) {
                    this.program.setInt(name, 0);
                    continue;
                }
                textureConsumer.accept(sampler, textureId);
                this.program.setInt(name, sampler);
                this.boundSamplers.put((Object)name, sampler);
                ++count;
            }
            for (TextureUniformAccess.SamplerListener listener : this.listeners) {
                listener.onUpdateSamplers(this.boundSamplers);
            }
            return start + count;
        }

        public int bind(int start) {
            if (VeilRenderSystem.textureMultibindSupported()) {
                if (this.dirty) {
                    this.dirty = false;
                    if (this.bindings == null || this.bindings.capacity() < 1 + this.textures.size()) {
                        this.bindings = MemoryUtil.memRealloc((IntBuffer)this.bindings, (int)(1 + this.textures.size()));
                    }
                    this.bindings.clear();
                    int end = this.uploadTextures(start, (sampler, id) -> this.bindings.put((int)id));
                    if (end == start) {
                        this.bindings.position(0);
                        return start;
                    }
                    this.bindings.flip();
                }
                if (this.bindings != null && this.bindings.limit() > 0) {
                    VeilRenderSystem.bindTextures(start, this.bindings);
                    return start + this.bindings.limit();
                }
                return start;
            }
            this.dirty = false;
            int activeTexture = GlStateManager._getActiveTexture();
            int end = this.uploadTextures(start, (sampler, id) -> {
                RenderSystem.activeTexture((int)(33984 + sampler));
                if (sampler >= 12) {
                    GL43C.glBindTexture((int)3553, (int)id);
                } else {
                    RenderSystem.bindTexture((int)id);
                }
            });
            RenderSystem.activeTexture((int)activeTexture);
            return end;
        }

        public void addSamplerListener(TextureUniformAccess.SamplerListener listener) {
            this.listeners.add((Object)listener);
        }

        public void removeSamplerListener(TextureUniformAccess.SamplerListener listener) {
            this.listeners.remove((Object)listener);
        }

        public void put(CharSequence name, int textureId) {
            this.dirty |= this.textures.put((Object)name, textureId) != textureId;
        }

        public void remove(CharSequence name) {
            if (this.textures.removeInt((Object)name) != 0) {
                this.dirty = true;
            }
        }

        public void clear() {
            this.textures.clear();
            this.boundSamplers.clear();
            if (this.bindings != null) {
                MemoryUtil.memFree((Buffer)this.bindings);
                this.bindings = null;
            }
            this.dirty = true;
        }
    }

    public static class Wrapper
    extends class_5944 {
        private static final byte[] DUMMY_SHADER = "{\n    \"vertex\": \"dummy\",\n    \"fragment\": \"dummy\"\n}\n".getBytes(StandardCharsets.UTF_8);
        private static final class_3298 RESOURCE = new class_3298(null, () -> new ByteArrayInputStream(DUMMY_SHADER)){

            public class_3262 method_45304() {
                throw new UnsupportedOperationException("No pack source");
            }

            public String method_14480() {
                return "dummy";
            }

            public Optional<class_9226> method_56936() {
                return Optional.empty();
            }
        };
        private static final class_293 DUMMY_FORMAT = class_293.method_60833().method_60840();
        public static boolean constructing = false;
        private final ShaderProgram program;

        private Wrapper(ShaderProgram program) throws IOException {
            super(name -> Optional.of(RESOURCE), "", DUMMY_FORMAT);
            this.program = program;
        }

        public void close() {
        }

        public void method_34585() {
            ShaderProgram.unbind();
        }

        public void method_34586() {
            this.program.setup();
        }

        public void method_34418() {
            throw new UnsupportedOperationException("Cannot attach shader program wrapper");
        }

        public void method_1279() {
        }

        @Nullable
        public UniformWrapper getUniform(String name) {
            UniformWrapper uniform = (UniformWrapper)((Object)this.field_29492.get(name));
            if (uniform != null) {
                return uniform.method_35660() == -1 ? null : uniform;
            }
            if (this.program != null && this.program.getUniform(name) == -1) {
                return null;
            }
            return (UniformWrapper)this.field_29492.computeIfAbsent(name, unused -> new UniformWrapper(() -> this.program, name));
        }

        public void method_34583(String name, Object value) {
            int sampler = -1;
            Object object = value;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_276.class, class_1044.class, Integer.class}, (Object)object2, n)) {
                case 0: {
                    class_276 target = (class_276)object2;
                    sampler = target.method_30277();
                    break;
                }
                case 1: {
                    class_1044 texture = (class_1044)object2;
                    sampler = texture.method_4624();
                    break;
                }
                case 2: {
                    Integer id = (Integer)object2;
                    sampler = id;
                    break;
                }
            }
            if (sampler != -1) {
                this.program.addSampler(name, sampler);
            }
        }

        public ShaderProgram program() {
            return this.program;
        }
    }

    public static class UniformWrapper
    extends class_284 {
        private final Supplier<MutableUniformAccess> access;

        public UniformWrapper(Supplier<MutableUniformAccess> access, String name) {
            super(name, 0, 0, null);
            super.close();
            this.access = access;
        }

        public void method_1297(int location) {
        }

        public void method_35659(int index, float value) {
            throw new UnsupportedOperationException("Use absolute set");
        }

        public void method_1251(float value) {
            this.access.get().setFloat(this.method_1298(), value);
        }

        public void method_1255(float x, float y) {
            this.access.get().setVector(this.method_1298(), x, y);
        }

        public void method_1249(float x, float y, float z) {
            this.access.get().setVector(this.method_1298(), x, y, z);
        }

        public void method_1254(float x, float y, float z, float w) {
            this.access.get().setVector(this.method_1298(), x, y, z, w);
        }

        public void method_34413(@NotNull Vector3f value) {
            this.access.get().setVector((CharSequence)this.method_1298(), (Vector3fc)value);
        }

        public void method_35652(@NotNull Vector4f value) {
            this.access.get().setVector((CharSequence)this.method_1298(), (Vector4fc)value);
        }

        public void method_1252(float x, float y, float z, float w) {
            this.method_1254(x, y, z, w);
        }

        public void method_35649(int value) {
            this.access.get().setInt(this.method_1298(), value);
        }

        public void method_35650(int x, int y) {
            this.access.get().setVector(this.method_1298(), x, y);
        }

        public void method_35651(int x, int y, int z) {
            this.access.get().setVector(this.method_1298(), x, y, z);
        }

        public void method_35656(int x, int y, int z, int w) {
            this.access.get().setVector(this.method_1298(), x, y, z, w);
        }

        public void method_1248(int x, int y, int z, int w) {
            this.method_35656(x, y, z, w);
        }

        public void method_1253(float[] values) {
            switch (values.length) {
                case 1: {
                    this.method_1251(values[0]);
                    break;
                }
                case 2: {
                    this.method_1255(values[0], values[1]);
                    break;
                }
                case 3: {
                    this.method_1249(values[0], values[1], values[2]);
                    break;
                }
                case 4: {
                    this.method_1254(values[0], values[1], values[2], values[3]);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Invalid value array: " + Arrays.toString(values));
                }
            }
        }

        public void method_35657(float $$0, float $$1, float $$2, float $$3) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void method_35644(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void method_35645(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void method_35653(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void method_35646(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void method_35647(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10, float $$11) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void method_35654(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void method_35655(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10, float $$11) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void method_35648(float $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10, float $$11, float $$12, float $$13, float $$14, float $$15) {
            throw new UnsupportedOperationException("Use #set(Matrix4fc) or #set(Matrix3fc) instead");
        }

        public void method_39978(@NotNull Matrix3f value) {
            this.access.get().setMatrix((CharSequence)this.method_1298(), (Matrix3fc)value);
        }

        public void method_1250(@NotNull Matrix4f value) {
            this.access.get().setMatrix((CharSequence)this.method_1298(), (Matrix4fc)value);
        }

        public void method_1300() {
        }

        public void close() {
        }

        public int method_35660() {
            return this.access.get().getUniform(this.method_1298());
        }
    }
}

