/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import com.mojang.blaze3d.platform.GlStateManager;
import foundry.veil.Veil;
import foundry.veil.api.client.editor.SingleWindowEditor;
import foundry.veil.api.client.imgui.CodeEditor;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.client.imgui.VeilLanguageDefinitions;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.definition.ShaderPreDefinitions;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.impl.client.editor.DeviceInfoViewer;
import foundry.veil.impl.client.imgui.VeilImGuiImpl;
import foundry.veil.impl.compat.IrisShaderMap;
import foundry.veil.impl.compat.SodiumShaderMap;
import foundry.veil.mixin.accessor.GameRendererAccessor;
import foundry.veil.mixin.accessor.LevelRendererAccessor;
import foundry.veil.mixin.accessor.PostChainAccessor;
import imgui.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImString;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntRBTreeMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.ObjIntConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_2561;
import net.minecraft.class_279;
import net.minecraft.class_280;
import net.minecraft.class_283;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_5348;
import net.minecraft.class_5944;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20C;

@ApiStatus.Internal
public class ShaderEditor
extends SingleWindowEditor
implements class_4013 {
    public static final class_2561 TITLE = class_2561.method_43471((String)"editor.veil.shader.title");
    private static final class_2561 REFRESH = class_2561.method_43471((String)"editor.veil.shader.button.refresh");
    private static final class_2561 UPLOAD = class_2561.method_43471((String)"editor.veil.shader.button.upload");
    private static final class_2561 SEARCH = class_2561.method_43471((String)"editor.veil.shader.search");
    private static final class_2561 SHADER_PROGRAMS = class_2561.method_43471((String)"editor.veil.shader.shader_programs");
    private static final class_2561 SHADER_DEFINITIONS = class_2561.method_43471((String)"editor.veil.shader.definitions");
    private static final class_2561 SHADER_DEFINITIONS_HINT = class_2561.method_43471((String)"editor.veil.shader.definitions.hint");
    private static final class_2561 OPEN_SOURCE = class_2561.method_43471((String)"editor.veil.shader.open_source");
    private static final Pattern ERROR_PARSER = Pattern.compile("ERROR: (\\d+):(\\d+): (.+)");
    private static final Pattern LINE_DIRECTIVE_PARSER = Pattern.compile("#line\\s+(\\d+)\\s*(\\d+)?");
    private final CodeEditor codeEditor;
    private final Object2IntMap<class_2960> shaders = new Object2IntRBTreeMap((a, b) -> {
        int compare = a.method_12836().compareTo(b.method_12836());
        if (compare == 0) {
            return a.method_12832().compareTo(b.method_12832());
        }
        return compare;
    });
    private final ImString programFilterText;
    private Pattern programFilter;
    private SelectedProgram selectedProgram;
    private int selectedTab;
    private final ImString addDefinitionText;
    private final Set<String> removedDefinitions;
    private final ImBoolean editSourceOpen;
    private int editProgramId;
    private int editShaderId;

    public ShaderEditor() {
        this.codeEditor = new CodeEditor(UPLOAD);
        this.codeEditor.setSaveCallback((source, errorConsumer) -> {
            if (this.selectedProgram == null || !GL20C.glIsShader((int)this.editShaderId)) {
                errorConsumer.accept(0, "Invalid Shader");
                return;
            }
            GlStateManager.glShaderSource((int)this.editShaderId, List.of(source));
            GL20C.glCompileShader((int)this.editShaderId);
            if (GL20C.glGetShaderi((int)this.editShaderId, (int)35713) != 1) {
                String log = GL20C.glGetShaderInfoLog((int)this.editShaderId);
                ShaderEditor.parseErrors(source, log).forEach(errorConsumer);
                System.out.println(log);
                return;
            }
            GL20C.glLinkProgram((int)this.editProgramId);
            if (GL20C.glGetProgrami((int)this.editProgramId, (int)35714) != 1) {
                String log = GL20C.glGetProgramInfoLog((int)this.editProgramId);
                ShaderEditor.parseErrors(source, log).forEach(errorConsumer);
                System.out.println(log);
            }
        });
        this.codeEditor.getEditor().setLanguageDefinition(VeilLanguageDefinitions.glsl());
        this.programFilterText = new ImString(128);
        this.programFilter = null;
        this.selectedProgram = null;
        this.selectedTab = 0;
        this.addDefinitionText = new ImString(128);
        this.removedDefinitions = new HashSet<String>(1);
        this.editSourceOpen = new ImBoolean();
        this.editProgramId = 0;
        this.editShaderId = 0;
    }

    private void setSelectedProgram(@Nullable class_2960 name) {
        if (name != null && this.shaders.containsKey((Object)name)) {
            int program = this.shaders.getInt((Object)name);
            if (GL20C.glIsProgram((int)program)) {
                int[] attachedShaders = new int[GL20C.glGetProgrami((int)program, (int)35717)];
                GL20C.glGetAttachedShaders((int)program, null, (int[])attachedShaders);
                Int2IntArrayMap shaders = new Int2IntArrayMap(attachedShaders.length);
                for (int shader : attachedShaders) {
                    shaders.put(GL20C.glGetShaderi((int)shader, (int)35663), shader);
                }
                this.selectedProgram = new SelectedProgram(name, program, Collections.unmodifiableMap(shaders));
                return;
            }
            Veil.LOGGER.error("Compiled shader does not exist for program: {}", (Object)name);
        }
        this.selectedProgram = null;
    }

    private void setEditShaderSource(int program, int shader) {
        this.editSourceOpen.set(true);
        this.editProgramId = program;
        this.editShaderId = shader;
        this.codeEditor.show(null, GL20C.glGetShaderSource((int)shader));
    }

    private static Map<Integer, String> parseErrors(String source, String log) {
        Map<Integer, Map<Integer, String>> logErrors = ShaderEditor.parseLogErrors(log);
        HashMap<Integer, String> foundErrors = new HashMap<Integer, String>();
        int sourceId = 0;
        int lineNumber = 0;
        int sourceLineNumber = -1;
        for (String line : source.split("\n")) {
            String error;
            ++sourceLineNumber;
            Matcher matcher = LINE_DIRECTIVE_PARSER.matcher(line);
            if (matcher.find()) {
                try {
                    lineNumber = Integer.parseInt(matcher.group(1));
                    if (matcher.groupCount() <= 1) continue;
                    sourceId = Integer.parseInt(matcher.group(2));
                }
                catch (Throwable throwable) {}
                continue;
            }
            Map<Integer, String> errors = logErrors.get(sourceId);
            if (errors != null && (error = errors.remove(lineNumber)) != null) {
                foundErrors.put(sourceLineNumber, error);
            }
            ++lineNumber;
        }
        return foundErrors;
    }

    private static Map<Integer, Map<Integer, String>> parseLogErrors(String log) {
        HashMap<Integer, Map<Integer, String>> logErrors = new HashMap<Integer, Map<Integer, String>>();
        for (String line : log.split("\n")) {
            Matcher matcher = ERROR_PARSER.matcher(line);
            if (!matcher.find()) continue;
            try {
                int sourceNumber = Integer.parseInt(matcher.group(1));
                int lineNumber = Integer.parseInt(matcher.group(2));
                Map errors = logErrors.computeIfAbsent(sourceNumber, unused -> new HashMap());
                if (errors.containsKey(lineNumber)) continue;
                String error = matcher.group(3);
                errors.put(lineNumber, error);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return logErrors;
    }

    private void reloadShaders() {
        this.shaders.clear();
        TabSource.values()[this.selectedTab].addShaders((arg_0, arg_1) -> this.shaders.put(arg_0, arg_1));
        if (this.selectedProgram != null && !this.shaders.containsKey((Object)this.selectedProgram.name)) {
            this.setSelectedProgram(null);
        }
    }

    @Override
    public class_2561 getDisplayName() {
        return TITLE;
    }

    @Override
    public class_2561 getGroup() {
        return RENDERER_GROUP;
    }

    @Override
    protected void renderComponents() {
        this.removedDefinitions.clear();
        ImGui.beginChild((String)"##shader_programs", (float)(ImGui.getContentRegionAvailX() * 2.0f / 3.0f), (float)0.0f);
        VeilImGuiUtil.component((class_5348)SHADER_PROGRAMS);
        TabSource[] sources = TabSource.values();
        if (ImGui.beginTabBar((String)"##controls")) {
            if (ImGui.tabItemButton((String)REFRESH.getString())) {
                this.reloadShaders();
            }
            for (TabSource source : sources) {
                if (!source.visible.getAsBoolean()) continue;
                ImGui.beginDisabled((!source.active.getAsBoolean() ? 1 : 0) != 0);
                if (ImGui.beginTabItem((String)source.displayName.getString())) {
                    if (this.selectedTab != source.ordinal()) {
                        this.selectedTab = source.ordinal();
                        this.setSelectedProgram(null);
                        this.reloadShaders();
                    }
                    ImGui.endTabItem();
                }
                ImGui.endDisabled();
            }
            ImGui.endTabBar();
        }
        while (!sources[this.selectedTab].active.getAsBoolean() && this.selectedTab > 0) {
            --this.selectedTab;
            this.setSelectedProgram(null);
            this.reloadShaders();
        }
        ImGui.setNextItemWidth((float)ImGui.getContentRegionAvailX());
        if (ImGui.inputTextWithHint((String)"##search", (String)SEARCH.getString(), (ImString)this.programFilterText)) {
            String regex = this.programFilterText.get();
            this.programFilter = null;
            if (!regex.isBlank()) {
                try {
                    this.programFilter = Pattern.compile(regex);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }
        }
        if (ImGui.beginListBox((String)"##programs", (float)ImGui.getContentRegionAvailX(), (float)-1.4E-45f)) {
            for (Object2IntMap.Entry entry : this.shaders.object2IntEntrySet()) {
                boolean selected;
                class_2960 name = (class_2960)entry.getKey();
                boolean bl = selected = this.selectedProgram != null && name.equals((Object)this.selectedProgram.name);
                if (this.programFilter != null && !this.programFilter.matcher(name.toString()).find()) {
                    if (!selected) continue;
                    this.setSelectedProgram(null);
                    continue;
                }
                if (ImGui.selectable((String)("##" + name.toString()), (boolean)selected)) {
                    this.setSelectedProgram(name);
                }
                ImGui.sameLine();
                VeilImGuiUtil.resourceLocation(name);
                ImGui.pushStyleVar((int)14, (float)0.0f, (float)ImGui.getStyle().getItemSpacingY());
                ImGui.sameLine();
                ImGui.text((String)(" (" + entry.getIntValue() + ")"));
                ImGui.popStyleVar();
            }
            ImGui.endListBox();
        }
        ImGui.endChild();
        ShaderPreDefinitions definitions = VeilRenderSystem.renderer().getShaderDefinitions();
        ImGui.sameLine();
        if (ImGui.beginChild((String)"##panel", (float)0.0f, (float)ImGui.getContentRegionAvailY())) {
            if (ImGui.beginChild((String)"##open_source", (float)0.0f, (float)(ImGui.getContentRegionAvailY() / 2.0f))) {
                VeilImGuiUtil.component((class_5348)OPEN_SOURCE);
                this.openShaderButton(35632);
                this.openShaderButton(35633);
                this.openShaderButton(37305);
                this.openShaderButton(36313);
                this.openShaderButton(36488);
                this.openShaderButton(36487);
            }
            ImGui.endChild();
            if (ImGui.beginChild((String)"##shader_definitions", (float)0.0f, (float)ImGui.getContentRegionAvailY())) {
                VeilImGuiUtil.component((class_5348)SHADER_DEFINITIONS);
                ImGui.setNextItemWidth((float)ImGui.getContentRegionAvailX());
                if (ImGui.inputTextWithHint((String)"##add_definition", (String)SHADER_DEFINITIONS_HINT.getString(), (ImString)this.addDefinitionText, (int)32)) {
                    definitions.define(this.addDefinitionText.get().trim());
                    this.addDefinitionText.clear();
                }
                if (ImGui.beginListBox((String)"##definitions", (float)-1.4E-45f, (float)ImGui.getContentRegionAvailY())) {
                    for (Map.Entry<String, String> entry : definitions.getDefinitions().entrySet()) {
                        String name = entry.getKey();
                        String value = entry.getValue();
                        ImGui.pushID((String)name);
                        ImGui.text((String)value);
                        float size = ImGui.getTextLineHeightWithSpacing();
                        ImGui.sameLine();
                        ImGui.dummy((float)(ImGui.getContentRegionAvailX() - ImGui.getStyle().getCellPaddingX() * 2.0f - size), (float)0.0f);
                        ImGui.sameLine();
                        if (ImGui.button((String)"X", (float)size, (float)size)) {
                            this.removedDefinitions.add(name);
                        }
                        ImGui.popID();
                    }
                    ImGui.endListBox();
                }
            }
            ImGui.endChild();
        }
        ImGui.endChild();
        for (String name : this.removedDefinitions) {
            definitions.remove(name);
        }
    }

    @Override
    public void render() {
        ImGui.setNextWindowSizeConstraints((float)600.0f, (float)400.0f, (float)Float.MAX_VALUE, (float)Float.MAX_VALUE);
        super.render();
        this.codeEditor.renderWindow();
    }

    private void openShaderButton(int type) {
        boolean disabled = this.selectedProgram == null || !this.selectedProgram.shaders.containsKey(type);
        ImGui.beginDisabled((boolean)disabled);
        if (disabled) {
            ImGui.pushStyleColor((int)21, (int)ImGui.getColorU32((int)7));
        }
        if (ImGui.button((String)DeviceInfoViewer.getShaderName(type).getString())) {
            this.setEditShaderSource(this.selectedProgram.programId, this.selectedProgram.shaders.get(type));
        }
        if (disabled) {
            ImGui.popStyleColor();
        }
        ImGui.endDisabled();
    }

    @Override
    public void onShow() {
        super.onShow();
        this.reloadShaders();
    }

    @Override
    public void onHide() {
        super.onHide();
        this.shaders.clear();
    }

    @Override
    public void free() {
        super.free();
        this.codeEditor.free();
    }

    public void method_14491(@NotNull class_3300 resourceManager) {
        if (this.isOpen()) {
            this.reloadShaders();
        }
    }

    private record SelectedProgram(class_2960 name, int programId, Map<Integer, Integer> shaders) {
    }

    private static enum TabSource {
        VANILLA((class_2561)class_2561.method_43471((String)"editor.veil.shader.source.vanilla")){

            @Override
            public void addShaders(ObjIntConsumer<class_2960> registry) {
                GameRendererAccessor gameRenderer = (GameRendererAccessor)class_310.method_1551().field_1773;
                Map<String, class_5944> shaders = gameRenderer.getShaders();
                for (class_5944 shader : shaders.values()) {
                    String name = shader.method_35787().isBlank() ? Integer.toString(shader.method_1270()) : shader.method_35787();
                    registry.accept(class_2960.method_60654((String)name), shader.method_1270());
                }
                class_5944 blitShader = gameRenderer.getBlitShader();
                registry.accept(class_2960.method_60654((String)blitShader.method_35787()), blitShader.method_1270());
            }
        }
        ,
        VANILLA_POST((class_2561)class_2561.method_43471((String)"editor.veil.shader.source.vanilla_post")){

            @Override
            public void addShaders(ObjIntConsumer<class_2960> registry) {
                LevelRendererAccessor levelRenderer = (LevelRendererAccessor)class_310.method_1551().field_1769;
                this.addChainPasses(registry, levelRenderer.getEntityEffect());
                this.addChainPasses(registry, levelRenderer.getTransparencyChain());
                GameRendererAccessor gameRenderer = (GameRendererAccessor)class_310.method_1551().field_1773;
                this.addChainPasses(registry, gameRenderer.getPostEffect());
            }

            private void addChainPasses(ObjIntConsumer<class_2960> registry, @Nullable class_279 chain) {
                if (chain == null) {
                    return;
                }
                List<class_283> passes = ((PostChainAccessor)chain).getPasses();
                for (class_283 pass : passes) {
                    class_280 effect = pass.method_1295();
                    registry.accept(class_2960.method_60654((String)effect.method_35763()), effect.method_1270());
                }
            }
        }
        ,
        VEIL((class_2561)class_2561.method_43471((String)"editor.veil.shader.source.veil")){

            @Override
            public void addShaders(ObjIntConsumer<class_2960> registry) {
                Map<class_2960, ShaderProgram> shaders = VeilRenderSystem.renderer().getShaderManager().getShaders();
                for (ShaderProgram shader : shaders.values()) {
                    registry.accept(shader.getId(), shader.getProgram());
                }
                VeilImGuiImpl.get().addImguiShaders(registry);
            }
        }
        ,
        VEIL_DEFERRED((class_2561)class_2561.method_43471((String)"editor.veil.shader.source.veil_deferred"), VeilRenderSystem.renderer().getDeferredRenderer()::isEnabled, () -> true){

            @Override
            public void addShaders(ObjIntConsumer<class_2960> registry) {
                Map<class_2960, ShaderProgram> shaders = VeilRenderSystem.renderer().getDeferredRenderer().getDeferredShaderManager().getShaders();
                for (ShaderProgram shader : shaders.values()) {
                    registry.accept(shader.getId(), shader.getProgram());
                }
            }
        }
        ,
        IRIS((class_2561)class_2561.method_43471((String)"editor.veil.shader.source.iris"), IrisShaderMap::isEnabled, IrisShaderMap::isEnabled){

            @Override
            public void addShaders(ObjIntConsumer<class_2960> registry) {
                for (class_5944 shader : IrisShaderMap.getLoadedShaders()) {
                    String name = shader.method_35787().isBlank() ? Integer.toString(shader.method_1270()) : shader.method_35787();
                    registry.accept(class_2960.method_60654((String)name), shader.method_1270());
                }
            }
        }
        ,
        SODIUM((class_2561)class_2561.method_43471((String)"editor.veil.shader.source.sodium"), SodiumShaderMap::isEnabled, SodiumShaderMap::isEnabled){

            @Override
            public void addShaders(ObjIntConsumer<class_2960> registry) {
                for (Object2IntMap.Entry entry : SodiumShaderMap.getLoadedShaders().object2IntEntrySet()) {
                    registry.accept((class_2960)entry.getKey(), entry.getIntValue());
                }
            }
        }
        ,
        OTHER((class_2561)class_2561.method_43471((String)"editor.veil.shader.source.unknown")){

            @Override
            public void addShaders(ObjIntConsumer<class_2960> registry) {
                IntOpenHashSet programs = new IntOpenHashSet();
                for (int i = 1; i < 10000; ++i) {
                    if (!GL20C.glIsProgram((int)i)) continue;
                    programs.add(i);
                }
                for (TabSource value : TabSource.values()) {
                    if (value == this) continue;
                    value.addShaders((arg_0, arg_1) -> 7.lambda$addShaders$0((IntSet)programs, arg_0, arg_1));
                }
                IntIterator intIterator = programs.iterator();
                while (intIterator.hasNext()) {
                    int program = (Integer)intIterator.next();
                    registry.accept(class_2960.method_60655((String)"unknown", (String)Integer.toString(program)), program);
                }
            }

            private static /* synthetic */ void lambda$addShaders$0(IntSet programs, class_2960 name, int id) {
                programs.remove(id);
            }
        };

        private final class_2561 displayName;
        private final BooleanSupplier active;
        private final BooleanSupplier visible;

        private TabSource(class_2561 displayName) {
            this(displayName, () -> true, () -> true);
        }

        private TabSource(class_2561 displayName, BooleanSupplier active, BooleanSupplier visible) {
            this.displayName = displayName;
            this.active = active;
            this.visible = visible;
        }

        public abstract void addShaders(ObjIntConsumer<class_2960> var1);
    }
}

