/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import foundry.veil.Veil;
import foundry.veil.api.client.tooltip.Tooltippable;
import foundry.veil.api.client.tooltip.VeilUIItemTooltipDataHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_757;
import net.minecraft.class_811;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class UIUtils {
    public static void drawHoverText(Tooltippable tooltippable, float pticks, class_1799 stack, class_4587 pStack, List<? extends class_5348> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, int backgroundColor, int borderColorStart, int borderColorEnd, class_327 font, int tooltipTextWidthBonus, int tooltipTextHeightBonus, List<VeilUIItemTooltipDataHolder> items, int desiredX, int desiredY) {
        int n;
        if (textLines.isEmpty()) {
            return;
        }
        List<class_5684> list = UIUtils.gatherTooltipComponents(stack, textLines, stack.method_32347(), mouseX, screenWidth, screenHeight, font, font);
        RenderSystem.disableDepthTest();
        int tooltipTextWidth = 0;
        for (class_5348 class_53482 : textLines) {
            int textLineWidth = font.method_27525(class_53482);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        boolean needsWrap = false;
        boolean bl = true;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            needsWrap = true;
        }
        if (needsWrap) {
            int wrappedTooltipWidth = 0;
            ArrayList<? extends class_5348> wrappedTextLines = new ArrayList<class_5348>();
            for (int i = 0; i < textLines.size(); ++i) {
                class_5348 textLine = textLines.get(i);
                List wrappedLine = font.method_27527().method_27495(textLine, tooltipTextWidth, class_2583.field_24360);
                if (i == 0) {
                    n = wrappedLine.size();
                }
                for (class_5348 line : wrappedLine) {
                    int lineWidth = font.method_27525(line);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add((class_5348)line);
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            textLines = wrappedTextLines;
            tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
        }
        int tooltipY = mouseY - 12;
        int tooltipHeight = 8;
        if (textLines.size() > 1) {
            tooltipHeight += (textLines.size() - 1) * 10;
            if (textLines.size() > n) {
                tooltipHeight += 2;
            }
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        int zLevel = 400;
        UIUtils.drawTooltipRects(pticks, pStack, 400, backgroundColor, borderColorStart, borderColorEnd, font, list, tooltipTextWidth += tooltipTextWidthBonus, n, tooltipX, tooltipY, tooltipHeight += tooltipTextHeightBonus, items);
    }

    private static void drawTooltipRects(float pticks, class_4587 pStack, int z, int backgroundColor, int borderColorStart, int borderColorEnd, class_327 font, List<class_5684> list, int tooltipTextWidth, int titleLinesCount, int tooltipX, int tooltipY, int tooltipHeight, List<VeilUIItemTooltipDataHolder> items) {
        pStack.method_22903();
        Matrix4f mat = pStack.method_23760().method_23761();
        UIUtils.drawGradientRect(mat, z, tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, backgroundColor, backgroundColor);
        UIUtils.drawGradientRect(mat, z, tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, backgroundColor, backgroundColor);
        UIUtils.drawGradientRect(mat, z, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        UIUtils.drawGradientRect(mat, z, tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        UIUtils.drawGradientRect(mat, z, tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        UIUtils.drawGradientRect(mat, z, tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        UIUtils.drawGradientRect(mat, z, tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        UIUtils.drawGradientRect(mat, z, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, borderColorStart, borderColorStart);
        UIUtils.drawGradientRect(mat, z, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, borderColorEnd, borderColorEnd);
        int itemY = tooltipY;
        for (int lineNumber = 0; lineNumber < list.size(); ++lineNumber) {
            if (lineNumber + 1 == titleLinesCount) {
                itemY += 2;
            }
            itemY += 10;
        }
        pStack.method_22903();
        pStack.method_46416(0.0f, 0.0f, 300.0f);
        if (items != null && !items.isEmpty()) {
            for (VeilUIItemTooltipDataHolder item : items) {
                UIUtils.renderAndDecorateItem(item.getItemStack(), (float)tooltipX + item.getX().apply(Float.valueOf(pticks)).floatValue(), (float)itemY + item.getY().apply(Float.valueOf(pticks)).floatValue());
                UIUtils.drawTexturedRect(pStack.method_23760().method_23761(), z + 100, (float)tooltipX + item.getX().apply(Float.valueOf(pticks)).floatValue(), (float)itemY + item.getY().apply(Float.valueOf(pticks)).floatValue(), 16.0f, 16.0f, 0.0f, 0.0f, 0.0f, 0.0f, 16, 16, Veil.veilPath("textures/gui/item_shadow.png"));
            }
        }
        pStack.method_22909();
        class_4597.class_4598 renderType = class_310.method_1551().method_22940().method_23000();
        pStack.method_22904(0.0, 0.0, (double)z);
        for (int lineNumber = 0; lineNumber < list.size(); ++lineNumber) {
            class_5684 line = list.get(lineNumber);
            if (line != null) {
                line.method_32665(font, tooltipX, tooltipY, mat, renderType);
            }
            if (lineNumber + 1 == titleLinesCount) {
                tooltipY += 2;
            }
            tooltipY += 10;
        }
        renderType.method_22993();
        pStack.method_22909();
        RenderSystem.enableDepthTest();
    }

    public static void renderAndDecorateItem(class_1799 $$0, float $$1, float $$2) {
        UIUtils.tryRenderGuiItem((class_1309)class_310.method_1551().field_1724, $$0, $$1, $$2, 0);
    }

    public static void tryRenderGuiItem(@Nullable class_1309 $$0, class_1799 $$1, float $$2, float $$3, int $$4) {
        UIUtils.tryRenderGuiItem($$0, $$1, $$2, $$3, $$4, 0.0f);
    }

    public static List<class_5684> gatherTooltipComponents(class_1799 stack, List<? extends class_5348> textElements, Optional<class_5632> itemComponent, int mouseX, int screenWidth, int screenHeight, @Nullable class_327 forcedFont, class_327 fallbackFont) {
        class_327 font = forcedFont != null ? forcedFont : fallbackFont;
        List elements = textElements.stream().map(Either::left).collect(Collectors.toCollection(ArrayList::new));
        itemComponent.ifPresent(c -> elements.add(1, Either.right((Object)c)));
        int tooltipTextWidth = elements.stream().mapToInt(either -> (Integer)either.map(arg_0 -> ((class_327)font).method_27525(arg_0), component -> 0)).max().orElse(0);
        boolean needsWrap = false;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        int tooltipTextWidthF = tooltipTextWidth;
        if (needsWrap) {
            return elements.stream().flatMap(either -> (Stream)either.map(text -> font.method_1728(text, tooltipTextWidthF).stream().map(class_5684::method_32662), component -> Stream.of(class_5684.method_32663((class_5632)component)))).toList();
        }
        return elements.stream().map(either -> (class_5684)either.map(text -> class_5684.method_32662((class_5481)(text instanceof class_2561 ? ((class_2561)text).method_30937() : class_2477.method_10517().method_30934(text))), class_5684::method_32663)).toList();
    }

    public static void drawGradientRect(Matrix4f mat, int zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22918(mat, (float)right, (float)top, (float)zLevel).method_22915(startRed, startGreen, startBlue, startAlpha);
        buffer.method_22918(mat, (float)left, (float)top, (float)zLevel).method_22915(startRed, startGreen, startBlue, startAlpha);
        buffer.method_22918(mat, (float)left, (float)bottom, (float)zLevel).method_22915(endRed, endGreen, endBlue, endAlpha);
        buffer.method_22918(mat, (float)right, (float)bottom, (float)zLevel).method_22915(endRed, endGreen, endBlue, endAlpha);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.disableBlend();
    }

    public static void drawTexturedRect(Matrix4f mat, int zLevel, float x, float y, float width, float height, float u, float v, float uWidth, float vHeight, int textureWidth, int textureHeight, class_2960 texture) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        float f = 1.0f / (float)textureWidth;
        float f1 = 1.0f / (float)textureHeight;
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22918(mat, x, y + height, (float)zLevel).method_22913(u * f, (v + vHeight) * f1);
        buffer.method_22918(mat, x + width, y + height, (float)zLevel).method_22913((u + uWidth) * f, (v + vHeight) * f1);
        buffer.method_22918(mat, x + width, y, (float)zLevel).method_22913((u + uWidth) * f, v * f1);
        buffer.method_22918(mat, x, y, (float)zLevel).method_22913(u * f, v * f1);
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    public static void tryRenderGuiItem(class_1309 $$0, class_1799 $$1, float $$2, float $$3, int $$4, float $$5) {
    }

    public static void renderGuiItem(class_1799 stack, float x, float y, class_1087 bakedModel) {
        boolean $$7;
        class_310.method_1551().method_1531().method_4619(class_1059.field_5275).method_4527(false, false);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1059.field_5275);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4fStack $$4 = RenderSystem.getModelViewStack();
        $$4.pushMatrix();
        $$4.translate(8.0f, 8.0f, 0.0f);
        $$4.scale(1.0f, -1.0f, 1.0f);
        $$4.scale(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 $$5 = new class_4587();
        class_4597.class_4598 $$6 = class_310.method_1551().method_22940().method_23000();
        boolean bl = $$7 = !bakedModel.method_24304();
        if ($$7) {
            class_308.method_24210();
        } else {
            class_308.method_24211();
        }
        class_310.method_1551().method_1480().method_23179(stack, class_811.field_4317, false, $$5, (class_4597)$$6, 0xF000F0, class_4608.field_21444, bakedModel);
        $$6.method_22993();
        RenderSystem.enableDepthTest();
        if ($$7) {
            class_308.method_24211();
        }
        $$4.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }
}

