/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.lwjgl.system.NativeResource;

public class CachedBufferSource
implements class_4597,
NativeResource {
    protected final Object2ObjectMap<class_1921, class_9799> buffers = new Object2ObjectArrayMap();
    protected final Map<class_1921, class_287> startedBuilders = new HashMap<class_1921, class_287>();
    @Nullable
    protected class_1921 lastSharedType;

    public class_4588 getBuffer(class_1921 renderType) {
        class_287 last = this.startedBuilders.get(renderType);
        if (last != null && !renderType.method_43332()) {
            this.endBatch(renderType, last);
            last = null;
        }
        if (last != null) {
            return last;
        }
        class_9799 bytebufferbuilder = (class_9799)this.buffers.computeIfAbsent((Object)renderType, unused -> new class_9799(renderType.method_22722()));
        class_287 builder = new class_287(bytebufferbuilder, renderType.method_23033(), renderType.method_23031());
        this.startedBuilders.put(renderType, builder);
        return builder;
    }

    public void free() {
        this.buffers.values().forEach(class_9799::method_60809);
        this.buffers.clear();
        this.startedBuilders.clear();
        this.lastSharedType = null;
    }

    public void endLastBatch() {
        if (this.lastSharedType != null) {
            this.endBatch(this.lastSharedType);
            this.lastSharedType = null;
        }
    }

    public void endBatch() {
        this.endLastBatch();
        for (class_1921 rendertype : this.buffers.keySet()) {
            this.endBatch(rendertype);
        }
    }

    public void endBatch(class_1921 pRenderType) {
        class_287 bufferbuilder = this.startedBuilders.remove(pRenderType);
        if (bufferbuilder != null) {
            this.endBatch(pRenderType, bufferbuilder);
        }
    }

    private void endBatch(class_1921 renderType, class_287 pBuilder) {
        class_9801 meshdata = pBuilder.method_60794();
        if (meshdata != null) {
            if (renderType.method_60894()) {
                class_9799 bytebufferbuilder = (class_9799)this.buffers.computeIfAbsent((Object)renderType, unused -> new class_9799(renderType.method_22722()));
                meshdata.method_60819(bytebufferbuilder, RenderSystem.getVertexSorting());
            }
            renderType.method_60895(meshdata);
        }
        if (renderType.equals(this.lastSharedType)) {
            this.lastSharedType = null;
        }
    }
}

