/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.necromancer.animation.keyframed;

import foundry.veil.api.client.necromancer.Bone;
import foundry.veil.api.client.necromancer.Skeleton;
import foundry.veil.api.client.necromancer.SkeletonParent;
import foundry.veil.api.client.necromancer.animation.Animation;
import foundry.veil.api.client.necromancer.animation.keyframed.BoneTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class KeyframedAnimation<P extends SkeletonParent, T extends Skeleton<P>>
extends Animation<P, T> {
    final boolean looped;
    final boolean additive;
    final Map<String, BoneTimeline> timelines;

    protected KeyframedAnimation(boolean looped, boolean additive) {
        this.looped = looped;
        this.additive = additive;
        this.timelines = new HashMap<String, BoneTimeline>();
    }

    @Override
    public boolean running(P parent, T skeleton, float mixFactor, float time) {
        return mixFactor > 0.0f;
    }

    @Override
    public void apply(P parent, T skeleton, float mixFactor, float time) {
        if (this.looped) {
            time %= 1.0f;
        }
        block0: for (Map.Entry<String, BoneTimeline> entry : this.timelines.entrySet()) {
            String boneID = entry.getKey();
            BoneTimeline timeline = entry.getValue();
            if (!((Skeleton)skeleton).bones.containsKey(boneID)) continue;
            Bone bone = ((Skeleton)skeleton).bones.get(boneID);
            Keyframe first = timeline.keyframes.get(0);
            Keyframe last = timeline.keyframes.get(timeline.keyframes.size() - 1);
            if (time < first.time) {
                if (this.looped) {
                    this.applyMixedKeyframes(bone, last, first, (time - (last.time - 1.0f)) / (first.time - (last.time - 1.0f)), mixFactor);
                    continue;
                }
                first.transform.apply(bone, mixFactor, this.additive);
                continue;
            }
            if (time > last.time) {
                if (this.looped) {
                    this.applyMixedKeyframes(bone, last, first, (time - last.time) / (first.time + 1.0f - last.time), mixFactor);
                    continue;
                }
                last.transform.apply(bone, mixFactor, this.additive);
                continue;
            }
            for (int i = 0; i < timeline.keyframes.size() - 1; ++i) {
                Keyframe prev = timeline.keyframes.get(i);
                Keyframe next = timeline.keyframes.get(i + 1);
                if (!(next.time > time)) continue;
                this.applyMixedKeyframes(bone, prev, first, (time - prev.time) / (next.time - prev.time), mixFactor);
                continue block0;
            }
        }
    }

    private void applyMixedKeyframes(Bone bone, Keyframe prevKeyframe, Keyframe nextKeyframe, float keyframeMixFactor, float poseMixFactor) {
        BoneTransform transform = BoneTransform.compose(prevKeyframe.transform, nextKeyframe.transform, keyframeMixFactor);
        transform.apply(bone, poseMixFactor, this.additive);
    }

    protected static class BoneTimeline {
        final List<Keyframe> keyframes = new ArrayList<Keyframe>();

        protected BoneTimeline(String boneID) {
        }
    }

    protected static class Keyframe {
        final float time;
        final BoneTransform transform;

        protected Keyframe(float time, BoneTransform transform) {
            this.time = time;
            this.transform = transform;
        }
    }
}

