package foundry.veil.api.quasar.emitters.shape;

import net.minecraft.class_238;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_761;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Plane implements EmitterShape {

    @Override
    public Vector3d getPoint(class_5819 randomSource, Vector3fc dimensions, Vector3fc rotation, Vector3dc position, boolean fromSurface) {
        double x = randomSource.method_43059() * 2 - 1;
        double y = randomSource.method_43059() * 2 - 1;
        double z = randomSource.method_43059() * 2 - 1;
        double max = Math.max(Math.abs(x), Math.max(Math.abs(y), Math.abs(z)));
        Vector3d normal = new Vector3d(x / max, y / max, z / max).normalize();
        Vector3fc dim = dimensions;
        if (!fromSurface) {
            normal.mul(randomSource.method_43058()).normalize();
            dim = dimensions.mul(
                    randomSource.method_43057(),
                    randomSource.method_43057(),
                    randomSource.method_43057(),
                    new Vector3f()
            );
        }
        Vector3d pos = normal.mul(dim);
        pos = pos.rotateX((float) Math.toRadians(rotation.x())).rotateY((float) Math.toRadians(rotation.y())).rotateZ((float) Math.toRadians(rotation.z()));
        return pos.add(position);
    }

    @Override
    public void renderShape(class_4587 stack, class_4588 consumer, Vector3fc dimensions, Vector3fc rotation) {
        float x = dimensions.x();
        float y = 0;
        float z = dimensions.z();
        class_761.method_22982(stack, consumer, new class_238(-x, -y, -z, x, y, z), 0.15f, 0.15f, 1, 1);
    }
}
