package foundry.veil.api.client.necromancer.render;

import foundry.veil.api.client.necromancer.Skeleton;
import foundry.veil.api.client.necromancer.SkeletonParent;
import foundry.veil.api.client.necromancer.animation.Animator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import net.minecraft.class_922;

public abstract class NecromancerEntityRenderer<T extends class_1297 & SkeletonParent, M extends Skeleton<T>> extends class_897<T> {
    final Function<T, M> skeletonFactory;
    final BiFunction<T, M, Animator<T, M>> animatorFactory;
    final List<NecromancerEntityRenderLayer<T, M>> layers;

    protected NecromancerEntityRenderer(class_5617.class_5618 pContext,
                                        Function<T, M> skeletonFactory,
                                        BiFunction<T, M, Animator<T, M>> animatorFactory,
                                        float shadowRadius) {
        super(pContext);
        this.skeletonFactory = skeletonFactory;
        this.animatorFactory = animatorFactory;
        this.field_4673 = shadowRadius;
        this.layers = new ArrayList<>();
    }

    public void addLayer(NecromancerEntityRenderLayer<T, M> layer) {
        this.layers.add(layer);
    }

    public void setupEntity(T entity) {
        M skeleton = skeletonFactory.apply(entity);
        entity.setSkeleton(skeleton);
        entity.setAnimator(animatorFactory.apply(entity, skeleton));
    }

    public abstract Skin<M> getSkin(T parent);

    public void method_3936(T pEntity, float pEntityYaw, float pPartialTicks, class_4587 poseStack, class_4597 pBuffer, int pPackedLight) {
        poseStack.method_22903();
        float scale = 1.0F / 16.0F;
        poseStack.method_22905(scale, scale, scale);

        class_310 minecraft = class_310.method_1551();
        boolean invisible = pEntity.method_5756(minecraft.field_1724);
        boolean glowing = minecraft.method_27022(pEntity);

        boolean shouldRender = !invisible;

        class_1921 rendertype = this.getRenderType(pEntity, this.method_3931(pEntity));
        M skeleton = (M) pEntity.getSkeleton();
        Skin<M> skin = this.getSkin(pEntity);

        if (shouldRender && skeleton != null && skin != null ) {
            renderSkin(pEntity, skeleton, skin, pEntity.field_6012, pPartialTicks, poseStack, pBuffer.getBuffer(rendertype), pPackedLight, this.getOverlayCoords(pEntity), 1, 1, 1, 1);
        }

        if (!pEntity.method_7325() && rendertype != null && skeleton != null) {
            for (NecromancerEntityRenderLayer<T, M> layer : this.layers) layer.render(poseStack, pBuffer, pPackedLight, pEntity, skeleton, pPartialTicks);
        }

        poseStack.method_22909();
        super.method_3936(pEntity, pEntityYaw, pPartialTicks, poseStack, pBuffer, pPackedLight);
    }

    public int getOverlayCoords(T pEntity) {
        return (pEntity instanceof class_1309 living) ? class_922.method_23622(living, 0) : class_4608.field_21444;
    }

    public void renderSkin(T entity, M skeleton, Skin<M> skin, int ticksExisted, float partialTicks, class_4587 poseStack, class_4588 consumer, int packedLight, int packedOverlay, float r, float g, float b, float a) {
        skin.render(skeleton, ticksExisted, partialTicks, poseStack, consumer, packedLight, packedOverlay, r, g, b, a);
    }

    public abstract class_1921 getRenderType(T entity, class_2960 texture);

    protected class_1921 getRenderType(T pLivingEntity, boolean visible, boolean spectator, boolean glowing) {
        class_2960 texture = this.method_3931(pLivingEntity);
        if (!visible) return null;
        return this.getRenderType(pLivingEntity, texture);
    }
}
