/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.fabric.mixin.client;

import com.google.common.collect.ImmutableList;
import foundry.veil.Veil;
import foundry.veil.VeilClient;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.event.FreeNativeResourcesEvent;
import foundry.veil.api.event.VeilRegisterBlockLayerEvent;
import foundry.veil.api.event.VeilRegisterFixedBuffersEvent;
import foundry.veil.api.event.VeilRendererEvent;
import foundry.veil.fabric.FabricRenderTypeStageHandler;
import foundry.veil.fabric.event.FabricFreeNativeResourcesEvent;
import foundry.veil.fabric.event.FabricVeilRegisterBlockLayerEvent;
import foundry.veil.fabric.event.FabricVeilRegisterFixedBuffersEvent;
import foundry.veil.fabric.event.FabricVeilRendererEvent;
import foundry.veil.mixin.accessor.RenderStateShardAccessor;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_542;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_310.class})
public class MinecraftMixin {
    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;resizeDisplay()V", shift=At.Shift.BEFORE)})
    public void init(class_542 gameConfig, CallbackInfo ci) {
        VeilClient.initRenderer();
        ((VeilRendererEvent)FabricVeilRendererEvent.EVENT.invoker()).onVeilRendererAvailable(VeilRenderSystem.renderer());
        ((VeilRegisterFixedBuffersEvent)FabricVeilRegisterFixedBuffersEvent.EVENT.invoker()).onRegisterFixedBuffers(FabricRenderTypeStageHandler::register);
    }

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setupDefaultState(IIII)V")})
    public void registerBlockLayers(class_542 gameConfig, CallbackInfo ci) {
        ImmutableList.Builder blockLayers = ImmutableList.builder();
        ((VeilRegisterBlockLayerEvent)FabricVeilRegisterBlockLayerEvent.EVENT.invoker()).onRegisterBlockLayers(renderType -> {
            if (Veil.platform().isDevelopmentEnvironment() && renderType.method_22722() > 786432) {
                Veil.LOGGER.warn("Block render layer '{}' uses a large buffer size: {}. If this is intended you can ignore this message", (Object)((RenderStateShardAccessor)renderType).getName(), (Object)renderType.method_22722());
            }
            blockLayers.add((Object)renderType);
        });
        FabricRenderTypeStageHandler.setBlockLayers((ImmutableList.Builder<class_1921>)blockLayers);
    }

    @Inject(method={"close"}, at={@At(value="INVOKE", target="Lnet/minecraft/Util;shutdownExecutors()V", shift=At.Shift.BEFORE)})
    public void close(CallbackInfo ci) {
        ((FreeNativeResourcesEvent)FabricFreeNativeResourcesEvent.EVENT.invoker()).onFree();
    }
}

