/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.necromancer.animation.keyframed;

import foundry.veil.api.client.necromancer.animation.keyframed.BoneTransform;
import net.minecraft.class_3532;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class Interpolations {
    private static final Quaternionf qTempA = new Quaternionf();
    private static final Quaternionf qTempB = new Quaternionf();
    private static final Quaternionf qTempC = new Quaternionf();
    private static final Quaternionf qTempD = new Quaternionf();
    private static final Quaternionf qTempE = new Quaternionf();
    private static final AxisAngle4f aaTempA = new AxisAngle4f();
    private static final AxisAngle4f aaTempB = new AxisAngle4f();
    private static final AxisAngle4f aaTempC = new AxisAngle4f();
    private static final AxisAngle4f aaTempD = new AxisAngle4f();

    public static AxisAngle4f aaMul(AxisAngle4f aa, float scalar) {
        return aa.set(aa.angle * scalar, aa.x, aa.y, aa.z);
    }

    public static AxisAngle4f aaAdd(AxisAngle4f ... aas) {
        float angle = 0.0f;
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        for (AxisAngle4f aa : aas) {
            angle += aa.angle;
            x += aa.x;
            y += aa.y;
            z += aa.z;
        }
        return aas[0].set(angle, x, y, z).normalize();
    }

    public static Quaternionf quaternionHermite(float delta, Quaternionfc r0, AxisAngle4f v0, Quaternionfc r1, AxisAngle4f v1, Quaternionf dest) {
        float w1 = 3.0f * delta * delta - 2.0f * delta * delta * delta;
        float w2 = delta * delta * delta - 2.0f * delta * delta + delta;
        float w3 = delta * delta * delta - delta * delta;
        AxisAngle4f r1_sub_r0 = aaTempA.set((Quaternionfc)r1.mul((Quaternionfc)r0.invert(dest), dest));
        return dest.set(Interpolations.aaAdd(Interpolations.aaMul(r1_sub_r0, w1), Interpolations.aaMul(v0, w2), Interpolations.aaMul(v1, w3))).mul(r0);
    }

    public static Quaternionf quaternionCatmullRom(float delta, Quaternionfc r0, Quaternionfc r1, Quaternionfc r2, Quaternionfc r3, Quaternionf dest) {
        AxisAngle4f r1_sub_r0 = aaTempB.set((Quaternionfc)r1.mul((Quaternionfc)r0.invert(dest), dest));
        AxisAngle4f r2_sub_r1 = aaTempC.set((Quaternionfc)r2.mul((Quaternionfc)r1.invert(dest), dest));
        AxisAngle4f r3_sub_r2 = aaTempD.set((Quaternionfc)r3.mul((Quaternionfc)r2.invert(dest), dest));
        AxisAngle4f v1 = Interpolations.aaMul(Interpolations.aaAdd(r1_sub_r0, r2_sub_r1), 0.5f);
        AxisAngle4f v2 = Interpolations.aaMul(Interpolations.aaAdd(r2_sub_r1, r3_sub_r2), 0.5f);
        return Interpolations.quaternionHermite(delta, r1, v1, r2, v2, dest);
    }

    public static enum InterpolationType {
        STEP((delta, prevPrev, prev, next, nextNext) -> delta > 0.5f ? next : prev),
        LINEAR((delta, prevPrev, prev, next, nextNext) -> {
            float x = class_3532.method_16439((float)delta, (float)prev.x(), (float)next.x());
            float y = class_3532.method_16439((float)delta, (float)prev.y(), (float)next.y());
            float z = class_3532.method_16439((float)delta, (float)prev.z(), (float)next.z());
            float sx = class_3532.method_16439((float)delta, (float)prev.sx(), (float)next.sx());
            float sy = class_3532.method_16439((float)delta, (float)prev.sy(), (float)next.sy());
            float sz = class_3532.method_16439((float)delta, (float)prev.sz(), (float)next.sz());
            qTempA.set(prev.qx(), prev.qy(), prev.qz(), prev.qw());
            qTempB.set(next.qx(), next.qy(), next.qz(), next.qw());
            qTempA.slerp((Quaternionfc)qTempB, delta);
            return new BoneTransform(x, y, z, Interpolations.qTempA.x, Interpolations.qTempA.y, Interpolations.qTempA.z, Interpolations.qTempA.w, sx, sy, sz);
        }),
        CUBIC((delta, prevPrev, prev, next, nextNext) -> {
            float x = class_3532.method_41303((float)delta, (float)prevPrev.x(), (float)prev.x(), (float)next.x(), (float)nextNext.x());
            float y = class_3532.method_41303((float)delta, (float)prevPrev.y(), (float)prev.y(), (float)next.y(), (float)nextNext.y());
            float z = class_3532.method_41303((float)delta, (float)prevPrev.z(), (float)prev.z(), (float)next.z(), (float)nextNext.z());
            float sx = class_3532.method_41303((float)delta, (float)prevPrev.sx(), (float)prev.sx(), (float)next.sx(), (float)nextNext.sx());
            float sy = class_3532.method_41303((float)delta, (float)prevPrev.sy(), (float)prev.sy(), (float)next.sy(), (float)nextNext.sy());
            float sz = class_3532.method_41303((float)delta, (float)prevPrev.sz(), (float)prev.sz(), (float)next.sz(), (float)nextNext.sz());
            qTempA.set(prevPrev.qx(), prevPrev.qy(), prevPrev.qz(), prevPrev.qw());
            qTempB.set(prev.qx(), prev.qy(), prev.qz(), prev.qw());
            qTempC.set(next.qx(), next.qy(), next.qz(), next.qw());
            qTempD.set(nextNext.qx(), nextNext.qy(), nextNext.qz(), nextNext.qw());
            qTempE.set((Quaternionfc)Interpolations.quaternionCatmullRom(delta, (Quaternionfc)qTempA, (Quaternionfc)qTempB, (Quaternionfc)qTempC, (Quaternionfc)qTempD, qTempE));
            return new BoneTransform(x, y, z, Interpolations.qTempE.x, Interpolations.qTempE.y, Interpolations.qTempE.z, Interpolations.qTempE.w, sx, sy, sz);
        });

        final InterpolationFunction function;

        private InterpolationType(InterpolationFunction function) {
            this.function = function;
        }
    }

    private static interface InterpolationFunction {
        public BoneTransform compose(float var1, BoneTransform var2, BoneTransform var3, BoneTransform var4, BoneTransform var5);
    }
}

