package foundry.veil.mixin.client.skeleton;

import foundry.veil.api.client.necromancer.SkeletonParent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_638;
import net.minecraft.class_761;

@Mixin(class_761.class)
public class LevelRendererMixin {
    @Shadow @Nullable private class_638 level;

    @Inject(method = "tick()V", at = @At("HEAD"))
    private void veil$levelRenderTick(CallbackInfo ci) {
        if (this.level == null) return;
        for (class_1297 entity : this.level.method_18112()) {
            if (entity instanceof SkeletonParent parent) {
                if (parent.getAnimator() != null) parent.getAnimator().tick(parent);
            }
        }
    }
}
