package foundry.veil.impl.client.render.pipeline;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.impl.client.render.deferred.DeferredShaderStateCache;
import org.jetbrains.annotations.ApiStatus;

import java.util.function.Supplier;
import net.minecraft.class_4668;

@ApiStatus.Internal
public class ShaderProgramShard extends class_4668.class_5942 {

    private final Supplier<ShaderProgram> shader;
    private final DeferredShaderStateCache cache;

    public ShaderProgramShard(Supplier<ShaderProgram> shader) {
        this.shader = shader;
        this.cache = new DeferredShaderStateCache();
    }

    @Override
    public void method_23516() {
        ShaderProgram program = this.shader.get();
        if (!this.cache.setupRenderState(program)) {
            VeilRenderSystem.setShader(program);
        }
    }

    @Override
    public String toString() {
        ShaderProgram shader = this.shader.get();
        return this.field_21363 + "[" + (shader != null ? shader.getId() : "null") + "]";
    }
}
