package foundry.veil.fabric.mixin.client.deferred;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.impl.client.render.deferred.DeferredShaderStateCache;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Supplier;
import net.minecraft.class_4184;
import net.minecraft.class_5944;
import net.minecraft.class_702;
import net.minecraft.class_765;

@Mixin(class_702.class)
public class ParticleEngineMixin {

    @Unique
    private final DeferredShaderStateCache veil$cache = new DeferredShaderStateCache();

    @Inject(method = "render", at = @At("HEAD"))
    public void setupRenderState(class_765 lightTexture, class_4184 camera, float partialTick, CallbackInfo ci) {
        VeilRenderSystem.renderer().getDeferredRenderer().setup();
    }

    @Inject(method = "render", at = @At("RETURN"))
    public void clearRenderState(class_765 lightTexture, class_4184 camera, float partialTick, CallbackInfo ci) {
        VeilRenderSystem.renderer().getDeferredRenderer().clear();
    }

    @ModifyArg(method = "render", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/systems/RenderSystem;setShader(Ljava/util/function/Supplier;)V"), index = 0, remap = false)
    public Supplier<class_5944> setShader(Supplier<class_5944> value) {
        return () -> this.veil$cache.getShader(value.get());
    }
}
