/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.framebuffer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import foundry.veil.Veil;
import foundry.veil.api.CodecReloadListener;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.FramebufferDefinition;
import gg.moonflower.molangcompiler.api.MolangEnvironment;
import gg.moonflower.molangcompiler.api.MolangRuntime;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1041;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_7654;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.NativeResource;

public class FramebufferManager
extends CodecReloadListener<FramebufferDefinition>
implements NativeResource {
    private static final class_2960 MAIN = class_2960.method_60656((String)"main");
    public static final Codec<class_2960> FRAMEBUFFER_CODEC = Codec.STRING.comapFlatMap(name -> {
        try {
            if (!name.contains(":")) {
                class_2960 id = class_2960.method_43902((String)"temp", (String)name);
                return id != null ? DataResult.success((Object)id) : DataResult.error(() -> "Invalid path: " + name);
            }
            class_2960 id = class_2960.method_12829((String)name);
            return id != null ? DataResult.success((Object)id) : DataResult.error(() -> "Invalid path: " + name);
        }
        catch (class_151 e) {
            return DataResult.error(() -> "Not a valid resource location: " + name + ". " + e.getMessage());
        }
    }, location -> "temp".equals(location.method_12836()) ? location.method_12832() : location.toString()).stable();
    public static final class_7654 FRAMEBUFFER_LISTER = class_7654.method_45114((String)"pinwheel/framebuffers");
    private final Map<class_2960, FramebufferDefinition> framebufferDefinitions = new HashMap<class_2960, FramebufferDefinition>();
    private final Map<class_2960, AdvancedFbo> framebuffers = new HashMap<class_2960, AdvancedFbo>();
    private final Map<class_2960, AdvancedFbo> framebuffersView = Collections.unmodifiableMap(this.framebuffers);
    private final Set<class_2960> screenFramebuffers = new HashSet<class_2960>();
    private final Set<class_2960> manualFramebuffers = new HashSet<class_2960>();

    public FramebufferManager() {
        super(FramebufferDefinition.CODEC, FRAMEBUFFER_LISTER);
    }

    private void initFramebuffer(class_2960 name, FramebufferDefinition definition, MolangEnvironment runtime) {
        try {
            AdvancedFbo fbo = definition.createBuilder(runtime).build(true);
            fbo.bindDraw(false);
            fbo.clear();
            this.framebuffers.put(name, fbo);
            if (!definition.autoClear()) {
                this.manualFramebuffers.add(name);
            }
        }
        catch (Exception e) {
            Veil.LOGGER.error("Failed to initialize framebuffer: {}", (Object)name, (Object)e);
        }
    }

    @ApiStatus.Internal
    public void resizeFramebuffers(int width, int height) {
        MolangRuntime runtime = (MolangRuntime)MolangRuntime.runtime().setQuery("screen_width", (float)width).setQuery("screen_height", (float)height).create();
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        for (class_2960 name : this.screenFramebuffers) {
            FramebufferDefinition definition;
            this.manualFramebuffers.remove(name);
            AdvancedFbo fbo = this.framebuffers.remove(name);
            if (fbo != null) {
                fbo.free();
            }
            if ((definition = this.framebufferDefinitions.get(name)) == null) continue;
            this.initFramebuffer(name, definition, (MolangEnvironment)runtime);
        }
        AdvancedFbo.unbind();
    }

    @ApiStatus.Internal
    public void clear() {
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        this.framebuffers.forEach((name, fbo) -> {
            if (this.manualFramebuffers.contains(name)) {
                return;
            }
            fbo.bindDraw(false);
            fbo.clear();
        });
        GL30.glBindFramebuffer((int)36160, (int)0);
    }

    public void setFramebuffer(class_2960 name, AdvancedFbo fbo) {
        AdvancedFbo oldBuffer;
        if (this.manualFramebuffers.add(name) && (oldBuffer = this.framebuffers.remove(name)) != null) {
            oldBuffer.free();
            Veil.LOGGER.warn("Replaced defined framebuffer {} with manual buffer", (Object)name);
        }
        this.framebuffers.put(name, fbo);
    }

    @Nullable
    public AdvancedFbo removeFramebuffer(class_2960 name) {
        if (this.manualFramebuffers.remove(name)) {
            return this.framebuffers.remove(name);
        }
        return null;
    }

    @Nullable
    public AdvancedFbo getFramebuffer(class_2960 name) {
        return this.framebuffers.get(name);
    }

    public Map<class_2960, AdvancedFbo> getFramebuffers() {
        return this.framebuffersView;
    }

    protected void apply(@NotNull Map<class_2960, FramebufferDefinition> data, @NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        this.framebufferDefinitions.clear();
        this.framebufferDefinitions.putAll(data);
        Veil.LOGGER.info("Loaded {} framebuffers", (Object)this.framebufferDefinitions.size());
        this.free();
        class_1041 window = class_310.method_1551().method_22683();
        MolangRuntime runtime = (MolangRuntime)MolangRuntime.runtime().setQuery("screen_width", (float)window.method_4489()).setQuery("screen_height", (float)window.method_4506()).create();
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        this.framebufferDefinitions.forEach((name, definition) -> {
            this.initFramebuffer((class_2960)name, (FramebufferDefinition)definition, (MolangEnvironment)runtime);
            if (!definition.width().isConstant() || !definition.height().isConstant()) {
                this.screenFramebuffers.add((class_2960)name);
            }
        });
        AdvancedFbo.unbind();
        this.setFramebuffer(MAIN, AdvancedFbo.getMainFramebuffer());
    }

    public void free() {
        this.framebuffers.keySet().removeAll(this.manualFramebuffers);
        this.framebuffers.values().forEach(NativeResource::free);
        this.framebuffers.clear();
        this.manualFramebuffers.clear();
        this.screenFramebuffers.clear();
    }
}

