/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render;

import foundry.veil.api.client.editor.EditorManager;
import foundry.veil.api.client.render.CameraMatrices;
import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.GuiInfo;
import foundry.veil.api.client.render.deferred.VeilDeferredRenderer;
import foundry.veil.api.client.render.framebuffer.FramebufferManager;
import foundry.veil.api.client.render.post.PostProcessingManager;
import foundry.veil.api.client.render.rendertype.DynamicRenderTypeManager;
import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.client.render.shader.ShaderModificationManager;
import foundry.veil.api.client.render.shader.definition.ShaderPreDefinitions;
import foundry.veil.api.quasar.particle.ParticleSystemManager;
import foundry.veil.ext.LevelRendererExtension;
import foundry.veil.impl.client.imgui.VeilImGuiImpl;
import foundry.veil.mixin.accessor.ReloadableResourceManagerAccessor;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.system.NativeResource;

public class VeilRenderer
implements NativeResource {
    private final ShaderModificationManager shaderModificationManager = new ShaderModificationManager();
    private final ShaderPreDefinitions shaderPreDefinitions = new ShaderPreDefinitions();
    private final ShaderManager shaderManager = new ShaderManager(ShaderManager.PROGRAM_SET, this.shaderPreDefinitions);
    private final FramebufferManager framebufferManager = new FramebufferManager();
    private final PostProcessingManager postProcessingManager = new PostProcessingManager();
    private final VeilDeferredRenderer deferredRenderer;
    private final DynamicRenderTypeManager dynamicRenderTypeManager;
    private final ParticleSystemManager quasarParticleManager;
    private final EditorManager editorManager;
    private final CameraMatrices cameraMatrices;
    private final GuiInfo guiInfo;

    @ApiStatus.Internal
    public VeilRenderer(class_3304 resourceManager) {
        ShaderManager deferredShaderManager = new ShaderManager(ShaderManager.DEFERRED_SET, this.shaderPreDefinitions);
        this.deferredRenderer = new VeilDeferredRenderer(deferredShaderManager, this.shaderPreDefinitions, this.framebufferManager, this.postProcessingManager);
        this.dynamicRenderTypeManager = new DynamicRenderTypeManager();
        this.quasarParticleManager = new ParticleSystemManager();
        this.editorManager = new EditorManager(resourceManager);
        this.cameraMatrices = new CameraMatrices();
        this.guiInfo = new GuiInfo();
        List<class_3302> listeners = ((ReloadableResourceManagerAccessor)resourceManager).getListeners();
        listeners.add(0, (class_3302)this.shaderModificationManager);
        listeners.add(1, this.shaderManager);
        resourceManager.method_14477((class_3302)this.framebufferManager);
        resourceManager.method_14477((class_3302)this.postProcessingManager);
        resourceManager.method_14477((class_3302)this.deferredRenderer);
        resourceManager.method_14477((class_3302)this.dynamicRenderTypeManager);
    }

    public ShaderModificationManager getShaderModificationManager() {
        return this.shaderModificationManager;
    }

    public ShaderPreDefinitions getShaderDefinitions() {
        return this.shaderPreDefinitions;
    }

    public ShaderManager getShaderManager() {
        return this.shaderManager;
    }

    public FramebufferManager getFramebufferManager() {
        return this.framebufferManager;
    }

    public PostProcessingManager getPostProcessingManager() {
        return this.postProcessingManager;
    }

    public VeilDeferredRenderer getDeferredRenderer() {
        return this.deferredRenderer;
    }

    public DynamicRenderTypeManager getDynamicRenderTypeManager() {
        return this.dynamicRenderTypeManager;
    }

    public ParticleSystemManager getParticleManager() {
        return this.quasarParticleManager;
    }

    public EditorManager getEditorManager() {
        return this.editorManager;
    }

    public CameraMatrices getCameraMatrices() {
        return this.cameraMatrices;
    }

    public GuiInfo getGuiInfo() {
        return this.guiInfo;
    }

    public static boolean hasImGui() {
        return VeilImGuiImpl.get() instanceof VeilImGuiImpl;
    }

    public static CullFrustum getCullingFrustum() {
        return ((LevelRendererExtension)class_310.method_1551().field_1769).veil$getCullFrustum();
    }

    public void free() {
        this.shaderManager.close();
        this.framebufferManager.free();
        this.postProcessingManager.free();
        this.deferredRenderer.free();
        this.quasarParticleManager.clear();
        this.cameraMatrices.free();
        this.guiInfo.free();
    }
}

