package foundry.veil.api.quasar.fx;

import com.mojang.blaze3d.systems.RenderSystem;
import org.joml.Vector3f;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;

public class Line {
    public enum TilingMode {
        NONE,
        STRETCH,
        REPEAT
    }
    public enum CurveMode {
        NONE((points, freq) -> points),
        BEZIER((points, freq) -> {
            // calculate bezier curve points and add them to the points array.
            // the number of curve points between each original point should be the frequency divided by amount of input points
            class_243[] curvePoints = new class_243[(points.length-2) * freq];
            for (int i = 0; i < points.length - 1; i++) {
                class_243 p0 = points[i];
                class_243 p1 = points[i + 1];
                class_243 p2 = points[Math.min(i + 2, points.length - 1)];
                class_243 p3 = points[Math.min(i + 3, points.length - 1)];
                for (int j = 0; j < freq; j++) {
                    float t = (float) j / freq;
                    float t2 = t * t;
                    float t3 = t2 * t;
                    float x = (float) (0.5f * ((2.0f * p1.method_10216()) +
                                                (-p0.method_10216() + p2.method_10216()) * t +
                                                (2.0f * p0.method_10216() - 5.0f * p1.method_10216() + 4 * p2.method_10216() - p3.method_10216()) * t2 +
                                                (-p0.method_10216() + 3.0f * p1.method_10216() - 3.0f * p2.method_10216() + p3.method_10216()) * t3));
                    float y = (float) (0.5f * ((2.0f * p1.method_10214()) +
                                                (-p0.method_10214() + p2.method_10214()) * t +
                                                (2.0f * p0.method_10214() - 5.0f * p1.method_10214() + 4 * p2.method_10214() - p3.method_10214()) * t2 +
                                                (-p0.method_10214() + 3.0f * p1.method_10214() - 3.0f * p2.method_10214() + p3.method_10214()) * t3));
                    float z = (float) (0.5f * ((2.0f * p1.method_10215()) +
                                                (-p0.method_10215() + p2.method_10215()) * t +
                                                (2.0f * p0.method_10215() - 5.0f * p1.method_10215() + 4 * p2.method_10215() - p3.method_10215()) * t2 +
                                                (-p0.method_10215() + 3.0f * p1.method_10215() - 3.0f * p2.method_10215() + p3.method_10215()) * t3));
                    curvePoints[i * freq + j] = new class_243(x, y, z);
                }
            }
            return curvePoints;
        }),
        CATMULL_ROM((points, freq) -> {
            // calculate catmull-rom curve points and add them to the points array.
            // the number of curve points between each original point should be the frequency divided by amount of input points
            class_243[] curvePoints = new class_243[points.length * freq];
            for (int i = 0; i < points.length - 1; i++) {
                class_243 p0 = points[Math.max(i - 1, 0)];
                class_243 p1 = points[i];
                class_243 p2 = points[Math.min(i + 1, points.length - 1)];
                class_243 p3 = points[Math.min(i + 2, points.length - 1)];
                for (int j = 0; j < freq; j++) {
                    float t = (float) j / freq;
                    float t2 = t * t;
                    float t3 = t2 * t;
                    float x = (float) (0.5f * ((2.0f * p1.method_10216()) +
                                                (-p0.method_10216() + p2.method_10216()) * t +
                                                (2.0f * p0.method_10216() - 5.0f * p1.method_10216() + 4 * p2.method_10216() - p3.method_10216()) * t2 +
                                                (-p0.method_10216() + 3.0f * p1.method_10216() - 3.0f * p2.method_10216() + p3.method_10216()) * t3));
                    float y = (float) (0.5f * ((2.0f * p1.method_10214()) +
                                                (-p0.method_10214() + p2.method_10214()) * t +
                                                (2.0f * p0.method_10214() - 5.0f * p1.method_10214() + 4 * p2.method_10214() - p3.method_10214()) * t2 +
                                                (-p0.method_10214() + 3.0f * p1.method_10214() - 3.0f * p2.method_10214() + p3.method_10214()) * t3));
                    float z = (float) (0.5f * ((2.0f * p1.method_10215()) +
                                                (-p0.method_10215() + p2.method_10215()) * t +
                                                (2.0f * p0.method_10215() - 5.0f * p1.method_10215() + 4 * p2.method_10215() - p3.method_10215()) * t2 +
                                                (-p0.method_10215() + 3.0f * p1.method_10215() - 3.0f * p2.method_10215() + p3.method_10215()) * t3));
                    curvePoints[i * freq + j] = new class_243(x, y, z);
                }
            }
            return curvePoints;
        });

        final BiFunction<class_243[], Integer, class_243[]> curveFunction;

        CurveMode(BiFunction<class_243[], Integer, class_243[]> curveFunction) {
            this.curveFunction = curveFunction;
        }
    }
    private class_243[] points;
    private int color;
    private Function<Float, Float> widthFunction;
    private int length = 100;
    private boolean billboard = true;
    private TilingMode tilingMode = TilingMode.STRETCH;
    private int frequency = 1;
    private float minDistance = 0f;
    private class_2960 texture = null;
    private CurveMode curveMode = CurveMode.NONE;

    public Line(class_243[] points, int color, Function<Float, Float> widthFunction) {
        this.points = points;
        this.color = color;
        this.widthFunction = widthFunction;
    }

    public Line(int color, Function<Float, Float> widthFunction) {
        this(new class_243[]{class_243.field_1353}, color, widthFunction);
    }

    public void setCurveMode(CurveMode curveMode) {
        this.curveMode = curveMode;
    }

    public void setTilingMode(TilingMode tilingMode) {
        this.tilingMode = tilingMode;
    }

    public void setTexture(class_2960 texture) {
        this.texture = texture;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public void setMinDistance(float minDistance) {
        this.minDistance = minDistance;
    }

    public void setPoints(class_243[] points) {
        if(points.length > length) {
            class_243[] newPoints = new class_243[length];
            System.arraycopy(points, points.length - length, newPoints, 0, length);
            points = newPoints;
        }
        this.points = points;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setWidthFunction(Function<Float, Float> widthFunction) {
        this.widthFunction = widthFunction;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setBillboard(boolean billboard) {
        this.billboard = billboard;
    }

    public class_243[] getPoints() {
        return points;
    }

    public int getColor() {
        return color;
    }

    public Function<Float, Float> getWidthFunction() {
        return widthFunction;
    }

    public int getLength() {
        return length;
    }

    public boolean getBillboard() {
        return billboard;
    }

    public TilingMode getTilingMode() {
        return tilingMode;
    }

    public int getFrequency() {
        return frequency;
    }

    public float getMinDistance() {
        return minDistance;
    }

    public class_2960 getTexture() {
        return texture;
    }

    public CurveMode getCurveMode() {
        return curveMode;
    }

    public void addPoint(class_243 point) {
        class_243[] newPoints = new class_243[points.length + 1];
        System.arraycopy(points, 0, newPoints, 0, points.length);
        newPoints[points.length] = point;
        points = newPoints;
    }

    public void removePoint(int index) {
        class_243[] newPoints = new class_243[points.length - 1];
        System.arraycopy(points, 0, newPoints, 0, index);
        System.arraycopy(points, index + 1, newPoints, index, points.length - index - 1);
        points = newPoints;
    }

    public class_243[] setupCurvePoints() {
        // calculate curve points and add them to the points array
        return curveMode.curveFunction.apply(points, frequency);
    }

    public void render(class_4587 stack, class_4588 consumer, int light){
        stack.method_22903();
        RenderSystem.disableCull();
        class_243[] curvePoints = setupCurvePoints();
        Vector3f[][] corners = new Vector3f[curvePoints.length][2];
        for (int i = 0; i < curvePoints.length; i++) {
            float width = widthFunction.apply((float) i / (curvePoints.length - 1));
            Vector3f topOffset = new Vector3f(0, (width / 2f),0);
            Vector3f bottomOffset = new Vector3f(0, -(width / 2f), 0);
            if (billboard) {
//                Vector3f cameraDirection = new Vector3f(Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().subtract(curvePoints[i]).normalize());
//                Vector3f dirToNextPoint = new Vector3f(curvePoints[Math.min(i + frequency, curvePoints.length - 1)].subtract(curvePoints[i]).normalize());
//                Vector3f axis = cameraDirection.copy();
//                // invert the axis
//                axis.mul(-1);
//                axis.cross(dirToNextPoint);
//                topOffset = axis.copy();
//                topOffset.mul(width/2f);
//                bottomOffset = axis.copy();
//                bottomOffset.mul(-width/2f);
            }
            topOffset.add((float) curvePoints[i].field_1352, (float) curvePoints[i].field_1351, (float) curvePoints[i].field_1350);
            bottomOffset.add((float) curvePoints[i].field_1352, (float) curvePoints[i].field_1351, (float) curvePoints[i].field_1350);
            corners[i/frequency][0] = topOffset;
            corners[i/frequency][1] = bottomOffset;
        }
        renderPoints(stack, consumer, light, corners, color);
        RenderSystem.enableCull();
        stack.method_22909();
    }

    private void renderPoints(class_4587 stack, class_4588 consumer, int light, Vector3f[][] corners, int color) {
        stack.method_22903();
        float r = (color >> 16 & 255) / 255f;
        float g = (color >> 8 & 255) / 255f;
        float b = (color & 255) / 255f;
        float a = (color >> 24 & 255) / 255f;
        for (int i = 0; i < corners.length - 1; i++) {
            Vector3f top = corners[i][0];
            Vector3f bottom = corners[i][1];
            Vector3f nextTop = corners[i + 1][0];
            Vector3f nextBottom = corners[i + 1][1];
            if(nextTop == null) {
                nextTop = top;
            }
            if(nextBottom == null) {
                nextBottom = bottom;
            }
            if(top == null || bottom == null) continue;
            float u = 0;
            float u1 = 1;
            if(tilingMode == TilingMode.STRETCH) {
                u = (float) i / (corners.length - 1);
                u1 = (float) (i + 1) / (corners.length - 1);
            }
            consumer.method_22918(stack.method_23760().method_23761(), bottom.x(), bottom.y(), bottom.z()).method_22915(r, g, b, a).method_22913(u, 0).method_22922(class_4608.field_21444).method_60803(light).method_22914(0, 1, 0);
            consumer.method_22918(stack.method_23760().method_23761(), top.x(), top.y(), top.z()).method_22915(r, g, b, a).method_22913(u, 1).method_22922(class_4608.field_21444).method_60803(light).method_22914(0, 1, 0);
            consumer.method_22918(stack.method_23760().method_23761(), nextTop.x(), nextTop.y(), nextTop.z()).method_22915(r, g, b, a).method_22913(u1, 1).method_22922(class_4608.field_21444).method_60803(light).method_22914(0, 1, 0);
            consumer.method_22918(stack.method_23760().method_23761(), nextBottom.x(), nextBottom.y(), nextBottom.z()).method_22915(r, g, b, a).method_22913(u1, 0).method_22922(class_4608.field_21444).method_60803(light).method_22914(0, 1, 0);
        }
        stack.method_22909();
    }

    public enum RenderMode {
        FLAT,
        CUBOID;
    }
}
