package foundry.veil.api.client.render;

import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.rendertype.VeilRenderTypeBuilder;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.impl.client.render.pipeline.AdvancedFboShard;
import foundry.veil.impl.client.render.pipeline.PatchStateShard;
import foundry.veil.impl.client.render.pipeline.ShaderProgramShard;
import foundry.veil.impl.client.render.wrapper.VanillaAdvancedFboWrapper;
import java.util.function.Supplier;
import net.minecraft.class_1921;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import net.minecraft.class_4668;

/**
 * Bridges between Minecraft and Veil render classes.
 *
 * @author Ocelot
 */
public interface VeilRenderBridge {

    /**
     * Creates a cull frustum helper from the specified vanilla frustum.
     *
     * @param frustum The frustum to use for the cull frustum
     * @return The cull frustum
     */
    static CullFrustum create(class_4604 frustum) {
        return (CullFrustum) frustum;
    }

    /**
     * Creates a render type builder helper from the specified vanilla composite state builder.
     *
     * @param builder The state builder to wrap
     * @return The render type builder
     */
    static VeilRenderTypeBuilder create(class_1921.class_4688.class_4689 builder) {
        return (VeilRenderTypeBuilder) builder;
    }

    /**
     * Creates a matrix stack wrapper for the specified post stack.
     *
     * @param poseStack The pose stack to wrap
     * @return The matrix stack representation
     */
    static MatrixStack create(class_4587 poseStack) {
        return (MatrixStack) poseStack;
    }

    /**
     * Wraps the specified render target in a new advanced fbo.
     *
     * @param renderTarget The render target instance
     * @return A new advanced fbo that wraps the target in the api
     */
    static AdvancedFbo wrap(class_276 renderTarget) {
        return VeilRenderBridge.wrap(() -> renderTarget);
    }

    /**
     * Wraps the specified render target in a new advanced fbo.
     *
     * @param renderTargetSupplier The supplier to the render target instance
     * @return A new advanced fbo that wraps the target in the api
     */
    static AdvancedFbo wrap(Supplier<class_276> renderTargetSupplier) {
        return new VanillaAdvancedFboWrapper(renderTargetSupplier);
    }

    /**
     * Creates a new shader state that points to the specified Veil shader name.
     *
     * @param shader The name of the shader to point to.
     * @return A new shader state shard for that shader
     */
    static class_4668.class_5942 shaderState(class_2960 shader) {
        return new ShaderProgramShard(() -> VeilRenderSystem.renderer().getShaderManager().getShader(shader));
    }

    /**
     * Creates a new shader state that points to the specified Veil shader name.
     *
     * @param shader The shader to use
     * @return A new shader state shard for that shader
     */
    static class_4668.class_5942 shaderState(ShaderProgram shader) {
        return new ShaderProgramShard(() -> shader);
    }

    /**
     * Creates a new shader state that points to the specified Veil shader name.
     *
     * @param shader A supplier to the shader to use
     * @return A new shader state shard for that shader
     */
    static class_4668.class_5942 shaderState(Supplier<ShaderProgram> shader) {
        return new ShaderProgramShard(shader);
    }

    /**
     * Creates a new output state that draws into the specified Veil framebuffer.
     *
     * @param framebuffer The framebuffer to use
     * @return A new shader state shard for that shader
     */
    static class_4668.class_4678 outputState(class_2960 framebuffer) {
        return new AdvancedFboShard(framebuffer, () -> VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(framebuffer));
    }

    /**
     * Creates a new output state that draws into the specified Veil framebuffer.
     *
     * @param framebuffer The framebuffer to use
     * @return A new shader state shard for that shader
     */
    static class_4668.class_4678 outputState(AdvancedFbo framebuffer) {
        return new AdvancedFboShard(null, () -> framebuffer);
    }

    /**
     * Creates a new output state that draws into the specified Veil framebuffer.
     *
     * @param framebuffer A supplier to the framebuffer to use
     * @return A new shader state shard for that shader
     */
    static class_4668.class_4678 outputState(Supplier<AdvancedFbo> framebuffer) {
        return new AdvancedFboShard(null, framebuffer);
    }

    /**
     * Creates a new render state shard for tesselation patch size.
     *
     * @param patchVertices The number of vertices per patch
     * @return A new patch state
     */
    static PatchStateShard patchState(int patchVertices) {
        return new PatchStateShard(patchVertices);
    }
}
