/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.texture;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.shader.texture.FramebufferSource;
import foundry.veil.api.client.render.shader.texture.LocationSource;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public sealed interface ShaderTextureSource
permits LocationSource, FramebufferSource {
    public static final Codec<Type> TYPE_CODEC = Codec.STRING.flatXmap(name -> Optional.ofNullable(Type.byName(name)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown post texture source: " + name)), object -> DataResult.success((Object)object.name().toLowerCase(Locale.ROOT)));
    public static final Codec<ShaderTextureSource> CODEC = Codec.either((Codec)class_2960.field_25139, (Codec)TYPE_CODEC.dispatch(ShaderTextureSource::getType, Type::getCodec)).xmap(either -> (ShaderTextureSource)either.map(LocationSource::new, right -> right), source -> {
        Either either;
        if (source instanceof LocationSource) {
            LocationSource l = (LocationSource)source;
            either = Either.left((Object)l.location());
        } else {
            either = Either.right((Object)source);
        }
        return either;
    });
    public static final Context GLOBAL_CONTEXT = new Context(){};

    public int getId(Context var1);

    public Type getType();

    public static enum Type {
        LOCATION(LocationSource.CODEC),
        FRAMEBUFFER(FramebufferSource.CODEC);

        private final MapCodec<? extends ShaderTextureSource> codec;

        private Type(MapCodec<? extends ShaderTextureSource> codec) {
            this.codec = codec;
        }

        public MapCodec<? extends ShaderTextureSource> getCodec() {
            return this.codec;
        }

        @Nullable
        public static Type byName(String name) {
            for (Type type : Type.values()) {
                if (!type.name().toLowerCase(Locale.ROOT).equals(name)) continue;
                return type;
            }
            return null;
        }
    }

    public static interface Context {
        @Nullable
        default public AdvancedFbo getFramebuffer(class_2960 name) {
            return VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(name);
        }

        default public class_1044 getTexture(class_2960 name) {
            return class_310.method_1551().method_1531().method_4619(name);
        }
    }
}

