/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.imgui;

import foundry.veil.Veil;
import foundry.veil.api.client.color.Color;
import foundry.veil.api.client.editor.EditorManager;
import foundry.veil.api.client.render.VeilRenderSystem;
import imgui.ImFont;
import imgui.ImGui;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5224;
import net.minecraft.class_5225;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.ApiStatus;

public class VeilImGuiUtil {
    private static final ImGuiCharSink IM_GUI_CHAR_SINK = new ImGuiCharSink();
    private static final class_5225 IM_GUI_SPLITTER = new class_5225((charId, style) -> VeilImGuiUtil.getStyleFont(style).getCharAdvance(charId));
    private static final class_2960 ICON_FONT = Veil.veilPath("remixicon");

    public static void tooltip(String text) {
        ImGui.textColored((int)-11184811, (String)"(?)");
        if (ImGui.isItemHovered()) {
            ImGui.beginTooltip();
            ImGui.pushTextWrapPos((float)((float)ImGui.getFontSize() * 35.0f));
            ImGui.textColored((int)-1, (String)text);
            ImGui.popTextWrapPos();
            ImGui.endTooltip();
        }
    }

    public static void setTooltip(class_5348 text) {
        ImGui.beginTooltip();
        VeilImGuiUtil.component(text);
        ImGui.endTooltip();
    }

    public static void component(class_5348 text) {
        VeilImGuiUtil.component(text, Float.POSITIVE_INFINITY);
    }

    public static void component(class_5348 text, float wrapWidth) {
        IM_GUI_CHAR_SINK.reset();
        for (class_5481 part : class_2477.method_10517().method_30933(IM_GUI_SPLITTER.method_27495(text, (int)wrapWidth, class_2583.field_24360))) {
            part.accept((class_5224)IM_GUI_CHAR_SINK);
            IM_GUI_CHAR_SINK.finish();
            ImGui.newLine();
        }
    }

    public static void icon(int code) {
        ImGui.pushFont((ImFont)VeilRenderSystem.renderer().getEditorManager().getFont(ICON_FONT, false, false));
        ImGui.text((String)("" + (char)code));
        ImGui.popFont();
    }

    public static void icon(int code, int color) {
        ImGui.pushFont((ImFont)VeilRenderSystem.renderer().getEditorManager().getFont(ICON_FONT, false, false));
        ImGui.textColored((int)color, (String)("" + (char)code));
        ImGui.popFont();
    }

    public static void textCentered(String text, float width) {
        ImGui.setCursorPosX((float)(ImGui.getCursorPosX() + (width - ImGui.getFont().calcTextSizeAX((float)ImGui.getFontSize(), Float.MAX_VALUE, 0.0f, text)) / 2.0f));
        ImGui.text((String)text);
    }

    public static void resourceLocation(class_2960 loc) {
        ImGui.beginGroup();
        ImGui.textColored((int)VeilImGuiUtil.colorOf(loc.method_12836()), (String)(loc.method_12836() + ":"));
        ImGui.pushStyleVar((int)14, (float)0.0f, (float)0.0f);
        ImGui.sameLine();
        ImGui.text((String)loc.method_12832());
        ImGui.popStyleVar();
        ImGui.endGroup();
        if (ImGui.beginPopupContextItem((String)String.valueOf(loc))) {
            if (ImGui.selectable((String)"##copy_location")) {
                ImGui.setClipboardText((String)loc.toString());
            }
            ImGui.pushStyleVar((int)14, (float)0.0f, (float)0.0f);
            ImGui.setItemAllowOverlap();
            ImGui.sameLine();
            VeilImGuiUtil.icon(60305);
            ImGui.sameLine();
            ImGui.popStyleVar();
            ImGui.text((String)"Copy Location");
            ImGui.endPopup();
        }
    }

    public static int colorOf(String modid) {
        int color = (modid.hashCode() & 0xAAAAAA) + 0x444444;
        Color c = Color.of(0xFF | color << 8);
        c.mix(Color.WHITE.darkenCopy(0.4f), 0.35f);
        return c.getRGBA();
    }

    public static ImFont getStyleFont(class_2583 style) {
        return VeilRenderSystem.renderer().getEditorManager().getFont(class_2583.field_24359.equals((Object)style.method_27708()) ? EditorManager.DEFAULT_FONT : style.method_27708(), style.method_10984(), style.method_10966());
    }

    public static int getColor(int color) {
        float[] colors = ImGui.getStyle().getColors()[color];
        return (int)(colors[3] * 255.0f) << 24 | (int)(colors[0] * 255.0f) << 16 | (int)(colors[1] * 255.0f) << 8 | (int)(colors[2] * 255.0f);
    }

    public static class_5225 getStringSplitter() {
        return IM_GUI_SPLITTER;
    }

    @ApiStatus.Internal
    private static class ImGuiCharSink
    implements class_5224 {
        private ImFont font;
        private int textColor;
        private class_2568 hoverEvent;
        private class_2558 clickEvent;
        private final StringBuilder buffer = new StringBuilder();

        private ImGuiCharSink() {
            this.reset();
        }

        public void reset() {
            this.font = ImGui.getFont();
            this.textColor = VeilImGuiUtil.getColor(0);
            this.buffer.setLength(0);
            this.hoverEvent = null;
            this.clickEvent = null;
        }

        public boolean accept(int unknown, class_2583 style, int codePoint) {
            int styleColor;
            ImFont font = VeilImGuiUtil.getStyleFont(style);
            int n = styleColor = style.method_10973() != null ? style.method_10973().method_27716() : this.textColor;
            if (font != this.font || styleColor != this.textColor || style.method_10969() != this.hoverEvent || style.method_10970() != this.clickEvent) {
                if (!this.buffer.isEmpty()) {
                    this.finish();
                }
                this.font = VeilImGuiUtil.getStyleFont(style);
                this.textColor = styleColor;
                this.hoverEvent = style.method_10969();
                this.clickEvent = style.method_10970();
            }
            this.buffer.appendCodePoint(codePoint);
            return true;
        }

        public void finish() {
            if (!this.buffer.isEmpty()) {
                ImGui.pushStyleVar((int)14, (float)0.0f, (float)0.0f);
                ImGui.pushFont((ImFont)this.font);
                ImGui.textColored((int)(0xFF000000 | (this.textColor & 0xFF0000) >> 16 | this.textColor & 0xFF00 | (this.textColor & 0xFF) << 16), (String)this.buffer.toString());
                if (ImGui.isItemClicked() && this.clickEvent != null) {
                    this.handleClick();
                }
                if (ImGui.isItemHovered() && this.hoverEvent != null) {
                    this.handleHover();
                }
                ImGui.sameLine();
                ImGui.popFont();
                ImGui.popStyleVar();
                this.buffer.setLength(0);
            }
        }

        private void handleClick() {
            class_310 minecraft = class_310.method_1551();
            String value = this.clickEvent.method_10844();
            if (this.clickEvent.method_10845() == class_2558.class_2559.field_11749) {
                try {
                    URI uri = new URI(value);
                    String scheme = uri.getScheme();
                    if (scheme == null) {
                        throw new URISyntaxException(value, "Missing protocol");
                    }
                    if (!scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
                        throw new URISyntaxException(value, "Unsupported protocol: " + scheme.toLowerCase(Locale.ROOT));
                    }
                    class_156.method_668().method_673(uri);
                }
                catch (URISyntaxException e) {
                    Veil.LOGGER.error("Can't open url for {}", (Object)this.clickEvent, (Object)e);
                }
                return;
            }
            if (this.clickEvent.method_10845() == class_2558.class_2559.field_11746) {
                class_156.method_668().method_673(new File(value).toURI());
                return;
            }
            if (this.clickEvent.method_10845() == class_2558.class_2559.field_11745) {
                return;
            }
            if (this.clickEvent.method_10845() == class_2558.class_2559.field_11750) {
                return;
            }
            if (this.clickEvent.method_10845() == class_2558.class_2559.field_21462) {
                minecraft.field_1774.method_1455(value);
                return;
            }
            Veil.LOGGER.error("Don't know how to handle {}", (Object)this.clickEvent);
        }

        private void handleHover() {
            class_310 minecraft = class_310.method_1551();
            class_2568.class_5249 stack = (class_2568.class_5249)this.hoverEvent.method_10891(class_2568.class_5247.field_24343);
            if (stack != null) {
                ImGui.beginTooltip();
                List tooltip = class_437.method_25408((class_310)minecraft, (class_1799)stack.method_27683());
                for (class_2561 line : tooltip) {
                    VeilImGuiUtil.component((class_5348)line, (float)ImGui.getFontSize() * 35.0f);
                }
                ImGui.endTooltip();
                return;
            }
            class_2568.class_5248 entity = (class_2568.class_5248)this.hoverEvent.method_10891(class_2568.class_5247.field_24344);
            if (entity != null) {
                if (minecraft.field_1690.field_1827) {
                    ImGui.beginTooltip();
                    List tooltip = entity.method_27682();
                    for (class_2561 line : tooltip) {
                        VeilImGuiUtil.component((class_5348)line, (float)ImGui.getFontSize() * 35.0f);
                    }
                    ImGui.endTooltip();
                }
                return;
            }
            class_2561 showText = (class_2561)this.hoverEvent.method_10891(class_2568.class_5247.field_24342);
            if (showText != null) {
                ImGui.beginTooltip();
                VeilImGuiUtil.component((class_5348)showText, (float)ImGui.getFontSize() * 35.0f);
                ImGui.endTooltip();
            }
        }
    }
}

