package foundry.veil.impl.client.editor;

import foundry.veil.api.client.editor.SingleWindowEditor;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.post.PostProcessingManager;
import imgui.ImGui;
import imgui.flag.ImGuiCond;
import imgui.flag.ImGuiDataType;
import imgui.flag.ImGuiDragDropFlags;
import imgui.type.ImInt;
import org.jetbrains.annotations.ApiStatus;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

@ApiStatus.Internal
public class PostEditor extends SingleWindowEditor {

    public static final class_2561 TITLE = class_2561.method_43471("editor.veil.post.title");

    private static final class_2561 INACTIVE = class_2561.method_43471("editor.veil.post.inactive");
    private static final class_2561 ACTIVE = class_2561.method_43471("editor.veil.post.active");

    private final Set<class_2960> removedPipelines;

    public PostEditor() {
        this.removedPipelines = new HashSet<>(1);
    }

    @Override
    public void render() {
        ImGui.setNextWindowSize(600, 0);
        super.render();
    }

    @Override
    public void renderComponents() {
        this.removedPipelines.clear();
        PostProcessingManager postProcessingManager = VeilRenderSystem.renderer().getPostProcessingManager();

        float availableWidth = ImGui.getContentRegionAvailX();

        ImGui.setNextItemWidth(availableWidth / 2);
        ImGui.beginGroup();
        VeilImGuiUtil.component(INACTIVE);
        if (ImGui.beginListBox("##available_pipelines", availableWidth / 2, 0)) {
            for (class_2960 entry : postProcessingManager.getPipelines()) {
                if (postProcessingManager.isActive(entry)) {
                    continue;
                }

                VeilImGuiUtil.resourceLocation(entry);

                if (ImGui.beginDragDropSource(ImGuiDragDropFlags.SourceAllowNullID)) {
                    ImGui.setDragDropPayload("POST_PIPELINE", entry, ImGuiCond.Once);
                    VeilImGuiUtil.resourceLocation(entry);

                    ImGui.endDragDropSource();
                }
            }

            ImGui.endListBox();
        }

        if (ImGui.beginDragDropTarget()) {

            class_2960 payload = ImGui.acceptDragDropPayload("POST_PIPELINE");

            if (payload != null) {
                this.removedPipelines.add(payload);
            }

            ImGui.endDragDropTarget();
        }

        ImGui.endGroup();

        ImGui.sameLine();

        ImGui.setNextItemWidth(availableWidth / 2);
        ImGui.beginGroup();
        VeilImGuiUtil.component(ACTIVE);

        if (ImGui.beginListBox("##shaders", availableWidth / 2, 0)) {
            for (PostProcessingManager.ProfileEntry entry : postProcessingManager.getActivePipelines()) {
                class_2960 id = entry.getPipeline();

                ImGui.pushID(id.toString());
                VeilImGuiUtil.resourceLocation(id);
                if (ImGui.beginDragDropSource(ImGuiDragDropFlags.SourceAllowNullID)) {
                    ImGui.setDragDropPayload("POST_PIPELINE", id, ImGuiCond.Once);
                    VeilImGuiUtil.resourceLocation(id);
                    ImGui.endDragDropSource();
                }

                float priorityWidth = ImGui.calcTextSize("999999").x;
                ImGui.setItemAllowOverlap();
                ImGui.sameLine(ImGui.getContentRegionAvailX() - priorityWidth - 2);
                ImGui.setNextItemWidth(priorityWidth);
                ImInt editPriority = new ImInt(entry.getPriority());
                if (ImGui.dragScalar("##priority", ImGuiDataType.S32, editPriority, 1)) {
                    entry.setPriority(editPriority.get());
                }
                ImGui.popID();
            }

            ImGui.endListBox();
        }

        if (ImGui.beginDragDropTarget()) {
            class_2960 payload = ImGui.acceptDragDropPayload("POST_PIPELINE");

            if (payload != null) {
                postProcessingManager.add(payload);
            }

            ImGui.endDragDropTarget();
        }
        ImGui.endGroup();


        for (class_2960 id : this.removedPipelines) {
            postProcessingManager.remove(id);
        }
    }

    @Override
    public class_2561 getDisplayName() {
        return TITLE;
    }

    @Override
    public class_2561 getGroup() {
        return RENDERER_GROUP;
    }
}
