/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.tooltip;

import foundry.veil.api.client.color.Color;
import foundry.veil.api.client.color.ColorTheme;
import foundry.veil.api.client.color.Colorc;
import foundry.veil.api.client.tooltip.Tooltippable;
import foundry.veil.api.client.tooltip.VeilUIItemTooltipDataHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_7225;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2586.class})
public class TooltipBlockEntityMixin
implements Tooltippable {
    @Unique
    private List<class_2561> veil$tooltip = new ArrayList<class_2561>();
    @Unique
    private ColorTheme veil$theme;
    @Unique
    private final List<VeilUIItemTooltipDataHolder> veil$tooltipDataHolder = new ArrayList<VeilUIItemTooltipDataHolder>();
    @Unique
    private boolean veil$worldspace = true;
    @Unique
    private boolean veil$tooltipEnabled = false;
    @Unique
    private int veil$tooltipX = 0;
    @Unique
    private int veil$tooltipY = 0;
    @Unique
    private int veil$tooltipWidth = 0;
    @Unique
    private int veil$tooltipHeight = 0;

    @Override
    public List<class_2561> getTooltip() {
        return this.veil$tooltip;
    }

    @Override
    public boolean isTooltipEnabled() {
        return this.veil$tooltipEnabled;
    }

    @Override
    public class_2487 saveTooltipData() {
        class_2487 tag = new class_2487();
        tag.method_10556("tooltipEnabled", this.veil$tooltipEnabled);
        tag.method_10569("tooltipX", this.veil$tooltipX);
        tag.method_10569("tooltipY", this.veil$tooltipY);
        tag.method_10569("tooltipWidth", this.veil$tooltipWidth);
        tag.method_10569("tooltipHeight", this.veil$tooltipHeight);
        tag.method_10556("worldspace", this.veil$worldspace);
        if (this.veil$theme != null) {
            class_2487 themeTag = new class_2487();
            for (Map.Entry<String, Colorc> entry : this.veil$theme.getColorsMap().entrySet()) {
                String key = entry.getKey() != null ? entry.getKey() : "";
                themeTag.method_10569(key, entry.getValue().argb());
            }
            tag.method_10566("theme", (class_2520)themeTag);
        }
        return tag;
    }

    @Override
    public void loadTooltipData(class_2487 tag) {
        this.veil$tooltipEnabled = tag.method_10577("tooltipEnabled");
        this.veil$tooltipX = tag.method_10550("tooltipX");
        this.veil$tooltipY = tag.method_10550("tooltipY");
        this.veil$tooltipWidth = tag.method_10550("tooltipWidth");
        this.veil$tooltipHeight = tag.method_10550("tooltipHeight");
        this.veil$worldspace = tag.method_10577("worldspace");
        if (this.veil$theme != null) {
            this.veil$theme.clear();
        }
        if (tag.method_10573("theme", 10)) {
            if (this.veil$theme == null) {
                this.veil$theme = new ColorTheme();
            }
            class_2487 themeTag = tag.method_10562("theme");
            for (String key : themeTag.method_10541()) {
                this.veil$theme.addColor(key, new Color(themeTag.method_10550(key)));
            }
        }
    }

    @Override
    public void setTooltip(List<class_2561> tooltip) {
        this.veil$tooltip = tooltip;
    }

    @Override
    public void addTooltip(class_2561 tooltip) {
        this.veil$tooltip.add(tooltip);
    }

    @Override
    public void addTooltip(List<class_2561> tooltip) {
        this.veil$tooltip.addAll(tooltip);
    }

    @Override
    public void addTooltip(String tooltip) {
        this.veil$tooltip.add(class_2561.method_30163((String)tooltip));
    }

    @Override
    public ColorTheme getTheme() {
        return this.veil$theme;
    }

    @Override
    public void setTheme(ColorTheme theme) {
        this.veil$theme = theme;
    }

    @Override
    public void setBackgroundColor(int color) {
        this.veil$theme.addColor("background", new Color(color));
    }

    @Override
    public void setTopBorderColor(int color) {
        this.veil$theme.addColor("topBorder", new Color(color));
    }

    @Override
    public void setBottomBorderColor(int color) {
        this.veil$theme.addColor("bottomBorder", new Color(color));
    }

    @Override
    public boolean getWorldspace() {
        return this.veil$worldspace;
    }

    @Override
    public class_1799 getStack() {
        return class_1799.field_8037;
    }

    @Override
    public int getTooltipWidth() {
        return this.veil$tooltipWidth;
    }

    @Override
    public int getTooltipHeight() {
        return this.veil$tooltipHeight;
    }

    @Override
    public int getTooltipXOffset() {
        return this.veil$tooltipX;
    }

    @Override
    public int getTooltipYOffset() {
        return this.veil$tooltipHeight;
    }

    @Override
    public List<VeilUIItemTooltipDataHolder> getItems() {
        return this.veil$tooltipDataHolder;
    }

    @Inject(method={"saveAdditional"}, at={@At(value="RETURN")})
    public void saveAdditional(class_2487 pTag, class_7225.class_7874 pRegistries, CallbackInfo ci) {
        pTag.method_10566("tooltipData", (class_2520)this.saveTooltipData());
    }

    @Inject(method={"loadAdditional"}, at={@At(value="RETURN")})
    public void loadAdditional(class_2487 pTag, class_7225.class_7874 pRegistries, CallbackInfo ci) {
        this.loadTooltipData(pTag.method_10562("tooltipData"));
    }
}

