/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.dynamicbuffer;

import com.mojang.blaze3d.platform.GlStateManager;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.compat.SodiumCompat;
import foundry.veil.ext.RenderTargetExtension;
import foundry.veil.ext.ShaderInstanceExtension;
import foundry.veil.mixin.dynamicbuffer.accessor.DynamicBufferGameRendererAccessor;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1047;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5944;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL12C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.NativeResource;

@ApiStatus.Internal
public class DynamicBufferManager
implements NativeResource {
    private static final int[] GL_MAPPING = new int[]{35633, 36488, 36487, 36313, 35632, 37305};
    public static final class_2960 MAIN_WRAPPER = Veil.veilPath("dynamic_main");
    private int activeBuffers = 0;
    private final Object2IntMap<class_2960> activeBufferLayers = new Object2IntArrayMap();
    private boolean enabled = false;
    private final int[] clearBuffers = Arrays.stream(DynamicBufferType.values()).mapToInt(type -> 36065 + type.ordinal()).toArray();
    private final Map<class_2960, AdvancedFbo> framebuffers = new HashMap<class_2960, AdvancedFbo>();
    private final List<AdvancedFbo> dynamicFramebuffers = new ArrayList<AdvancedFbo>();
    private final EnumMap<DynamicBufferType, DynamicBuffer> dynamicBuffers = new EnumMap(DynamicBufferType.class);
    private int dynamicFboPointer;

    public DynamicBufferManager(int width, int height) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer textures = stack.mallocInt(DynamicBufferType.values().length);
            GL12C.glGenTextures((IntBuffer)textures);
            for (DynamicBufferType value : DynamicBufferType.values()) {
                DynamicBuffer buffer = new DynamicBuffer(value, textures.get(value.ordinal()));
                buffer.init(width, height);
                this.dynamicBuffers.put(value, buffer);
            }
        }
    }

    private void deleteFramebuffers() {
        for (Map.Entry<class_2960, AdvancedFbo> entry : this.framebuffers.entrySet()) {
            entry.getValue().free();
            VeilRenderSystem.renderer().getFramebufferManager().removeFramebuffer(entry.getKey());
        }
        this.framebuffers.clear();
        for (AdvancedFbo fbo : this.dynamicFramebuffers) {
            fbo.free();
        }
        this.dynamicFramebuffers.clear();
        this.dynamicFboPointer = 0;
    }

    public int getActiveBuffers(class_2960 name) {
        return this.activeBufferLayers.getOrDefault((Object)name, 0);
    }

    public int getActiveBuffers() {
        return this.activeBuffers;
    }

    public int getBufferTexture(DynamicBufferType buffer) {
        if ((this.activeBuffers & buffer.getMask()) != 0) {
            int index = 1 + Integer.bitCount(this.activeBuffers & buffer.getMask() - 1);
            int texture = ((RenderTargetExtension)class_310.method_1551().method_1522()).veil$getTexture(index);
            if (texture != 0) {
                return texture;
            }
            return this.dynamicBuffers.get((Object)((Object)buffer)).textureId;
        }
        return class_1047.method_4540().method_4624();
    }

    public boolean setActiveBuffers(class_2960 name, int activeBuffers) {
        int buffers = this.activeBufferLayers.getOrDefault((Object)name, 0);
        if (buffers == activeBuffers) {
            return false;
        }
        if (activeBuffers == 0) {
            this.activeBufferLayers.removeInt((Object)name);
        } else {
            this.activeBufferLayers.put((Object)name, activeBuffers);
        }
        int flags = 0;
        IntIterator intIterator = this.activeBufferLayers.values().iterator();
        while (intIterator.hasNext()) {
            int value = (Integer)intIterator.next();
            flags |= value;
        }
        if (flags == this.activeBuffers) {
            return false;
        }
        this.activeBuffers = flags;
        this.deleteFramebuffers();
        VeilRenderer renderer = VeilRenderSystem.renderer();
        ArrayList<class_5944> shaders = new ArrayList<class_5944>();
        DynamicBufferGameRendererAccessor accessor = (DynamicBufferGameRendererAccessor)class_310.method_1551().field_1773;
        for (class_5944 shader : accessor.getShaders().values()) {
            if (!((ShaderInstanceExtension)shader).veil$swapBuffers(this.activeBuffers)) continue;
            shaders.add(shader);
        }
        if (!shaders.isEmpty()) {
            renderer.getVanillaShaderCompiler().reload(shaders);
        }
        if ((this.activeBuffers & DynamicBufferType.NORMAL.getMask()) != (activeBuffers & DynamicBufferType.NORMAL.getMask())) {
            VeilRenderSystem.rebuildChunks();
        }
        if (SodiumCompat.INSTANCE != null) {
            SodiumCompat.INSTANCE.setActiveBuffers(activeBuffers);
        }
        try {
            renderer.getShaderManager().setActiveBuffers(activeBuffers);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        VeilRenderSystem.updateActiveBuffers();
        return true;
    }

    @ApiStatus.Internal
    public boolean isEnabled() {
        return this.activeBuffers != 0 && this.enabled;
    }

    @ApiStatus.Internal
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void free() {
        this.deleteFramebuffers();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer textures = stack.mallocInt(DynamicBufferType.BUFFERS.length);
            for (DynamicBufferType value : DynamicBufferType.BUFFERS) {
                textures.put(value.ordinal(), this.dynamicBuffers.get((Object)((Object)value)).textureId);
            }
            GL12C.glDeleteTextures((IntBuffer)textures);
        }
        this.dynamicBuffers.clear();
    }

    @ApiStatus.Internal
    public void setupRenderState(class_2960 name, @Nullable class_276 renderTarget, boolean setViewport) {
        if (!this.isEnabled()) {
            return;
        }
        if (renderTarget == null) {
            VeilRenderSystem.renderer().getFramebufferManager().removeFramebuffer(name);
            AdvancedFbo fbo = this.framebuffers.remove(name);
            if (fbo != null) {
                fbo.free();
            }
            this.setupRenderState(MAIN_WRAPPER, Objects.requireNonNull(class_310.method_1551().method_1522()), setViewport);
            return;
        }
        AdvancedFbo fbo = this.framebuffers.get(name);
        if (fbo == null) {
            AdvancedFbo.Builder builder = AdvancedFbo.withSize(renderTarget.field_1482, renderTarget.field_1481);
            builder.addColorTextureWrapper(renderTarget.method_30277());
            for (Map.Entry<DynamicBufferType, DynamicBuffer> entry : this.dynamicBuffers.entrySet()) {
                DynamicBufferType type = entry.getKey();
                if ((this.activeBuffers & type.getMask()) == 0) continue;
                builder.setName(type.getSourceName()).addColorTextureWrapper(entry.getValue().textureId);
            }
            builder.setDepthTextureWrapper(renderTarget.method_30278());
            builder.setDebugLabel(name.toString());
            fbo = builder.build(true);
            this.framebuffers.put(name, fbo);
        }
        VeilRenderSystem.renderer().getFramebufferManager().setFramebuffer(name, fbo);
        fbo.bind(setViewport);
    }

    public AdvancedFbo getDynamicFbo(AdvancedFbo framebuffer) {
        if (this.activeBuffers == 0 || !this.enabled) {
            return framebuffer;
        }
        if (!framebuffer.isColorTextureAttachment(0)) {
            return framebuffer;
        }
        int colorTexture = framebuffer.getColorTextureAttachment(0).method_4624();
        if (this.dynamicFboPointer < this.dynamicFramebuffers.size()) {
            AdvancedFbo fbo = this.dynamicFramebuffers.get(this.dynamicFboPointer);
            if (fbo.getWidth() == framebuffer.getWidth() && fbo.getHeight() == framebuffer.getHeight()) {
                ++this.dynamicFboPointer;
                fbo.setColorAttachmentTexture(0, colorTexture);
                if (framebuffer.isDepthTextureAttachment()) {
                    fbo.setDepthAttachmentTexture(framebuffer.getDepthTextureAttachment().method_4624());
                }
                fbo.clear(16384, this.clearBuffers);
                return fbo;
            }
            this.dynamicFramebuffers.remove(this.dynamicFboPointer);
            fbo.free();
        }
        AdvancedFbo.Builder builder = AdvancedFbo.withSize(framebuffer.getWidth(), framebuffer.getHeight());
        builder.addColorTextureWrapper(colorTexture);
        for (Map.Entry<DynamicBufferType, DynamicBuffer> entry : this.dynamicBuffers.entrySet()) {
            DynamicBufferType type = entry.getKey();
            if ((this.activeBuffers & type.getMask()) == 0) continue;
            builder.setName(type.getSourceName()).setFormat(type.getTexelFormat(), type.getInternalFormat()).addColorTextureBuffer();
        }
        if (framebuffer.isDepthTextureAttachment()) {
            builder.setDepthTextureWrapper(framebuffer.getDepthTextureAttachment().method_4624());
        } else {
            builder.setDepthTextureBuffer();
        }
        builder.setDebugLabel(framebuffer.getDebugLabel());
        AdvancedFbo fbo = builder.build(true);
        this.dynamicFramebuffers.add(this.dynamicFboPointer, fbo);
        ++this.dynamicFboPointer;
        return fbo;
    }

    public int[] getClearBuffers() {
        return this.clearBuffers;
    }

    @ApiStatus.Internal
    public void clear() {
        for (AdvancedFbo framebuffer : this.framebuffers.values()) {
            framebuffer.clear(0.0f, 0.0f, 0.0f, 0.0f, 16384, this.clearBuffers);
        }
        ListIterator<AdvancedFbo> iterator = this.dynamicFramebuffers.listIterator(this.dynamicFboPointer);
        while (iterator.hasNext()) {
            iterator.next().free();
            iterator.remove();
        }
        this.dynamicFboPointer = 0;
    }

    @ApiStatus.Internal
    public void resizeFramebuffers(int width, int height) {
        this.deleteFramebuffers();
        for (DynamicBuffer buffer : this.dynamicBuffers.values()) {
            buffer.resize(width, height);
        }
    }

    private record DynamicBuffer(DynamicBufferType type, int textureId) {
        public void init(int width, int height) {
            GlStateManager._bindTexture((int)this.textureId);
            GlStateManager._texParameter((int)3553, (int)10241, (int)9728);
            GlStateManager._texParameter((int)3553, (int)10240, (int)9728);
            GlStateManager._texParameter((int)3553, (int)33085, (int)0);
            GlStateManager._texParameter((int)3553, (int)33082, (int)0);
            GlStateManager._texParameter((int)3553, (int)33083, (int)0);
            GlStateManager._texParameter((int)3553, (int)34049, (float)0.0f);
            GlStateManager._texParameter((int)3553, (int)10242, (int)33071);
            GlStateManager._texParameter((int)3553, (int)10243, (int)33071);
            GlStateManager._texImage2D((int)3553, (int)0, (int)this.type.getInternalFormat(), (int)width, (int)height, (int)0, (int)this.type.getTexelFormat(), (int)5125, null);
        }

        public void resize(int width, int height) {
            GlStateManager._bindTexture((int)this.textureId);
            GlStateManager._texImage2D((int)3553, (int)0, (int)this.type.getInternalFormat(), (int)width, (int)height, (int)0, (int)this.type.getTexelFormat(), (int)5125, null);
        }
    }
}

