/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.fabric;

import com.google.common.collect.ImmutableList;
import foundry.veil.api.client.render.VeilLevelPerspectiveRenderer;
import foundry.veil.api.client.render.VeilRenderBridge;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.rendertype.VeilRenderType;
import foundry.veil.api.event.VeilRenderLevelStageEvent;
import foundry.veil.ext.LevelRendererBlockLayerExtension;
import foundry.veil.fabric.event.FabricVeilRenderLevelStageEvent;
import foundry.veil.mixin.rendertype.accessor.RenderTypeBufferSourceAccessor;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.SequencedMap;
import java.util.Set;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4668;
import net.minecraft.class_761;
import net.minecraft.class_9779;
import net.minecraft.class_9799;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;

@ApiStatus.Internal
public class FabricRenderTypeStageHandler {
    private static final Map<VeilRenderLevelStageEvent.Stage, Set<class_1921>> STAGE_RENDER_TYPES = new EnumMap<VeilRenderLevelStageEvent.Stage, Set<class_1921>>(VeilRenderLevelStageEvent.Stage.class);
    private static Set<class_1921> CUSTOM_BLOCK_LAYERS;
    private static List<class_1921> BLOCK_LAYERS;

    public static void register(@Nullable VeilRenderLevelStageEvent.Stage stage, class_1921 renderType) {
        SequencedMap<class_1921, class_9799> fixedBuffers = ((RenderTypeBufferSourceAccessor)class_310.method_1551().method_22940().method_23000()).getFixedBuffers();
        class_9799 old = fixedBuffers.put(renderType, new class_9799(renderType.method_22722()));
        if (old != null) {
            old.close();
        }
        if (stage != null) {
            STAGE_RENDER_TYPES.computeIfAbsent(stage, unused -> new ObjectArraySet()).add(renderType);
        }
    }

    public static void renderStage(LevelRendererBlockLayerExtension extension, class_3695 profiler, VeilRenderLevelStageEvent.Stage stage, class_761 levelRenderer, class_4597.class_4598 bufferSource, @Nullable class_4587 poseStack, Matrix4fc frustumMatrix, Matrix4fc projectionMatrix, int renderTick, class_9779 deltaTracker, class_4184 camera, class_4604 frustum) {
        profiler.method_15396(stage.getName());
        ((VeilRenderLevelStageEvent)FabricVeilRenderLevelStageEvent.EVENT.invoker()).onRenderLevelStage(stage, levelRenderer, bufferSource, VeilRenderBridge.create(poseStack != null ? poseStack : new class_4587()), frustumMatrix, projectionMatrix, renderTick, deltaTracker, camera, frustum);
        profiler.method_15407();
        Set<class_1921> stages = STAGE_RENDER_TYPES.get((Object)stage);
        if (stages != null) {
            stages.forEach(renderType -> {
                profiler.method_15396("render_" + VeilRenderType.getName((class_4668)renderType));
                if (CUSTOM_BLOCK_LAYERS.contains(renderType)) {
                    class_243 pos = camera.method_19326();
                    extension.veil$drawBlockLayer((class_1921)renderType, pos.field_1352, pos.field_1351, pos.field_1350, frustumMatrix, projectionMatrix);
                }
                bufferSource.method_22994(renderType);
                profiler.method_15407();
            });
        }
        if (!VeilLevelPerspectiveRenderer.isRenderingPerspective()) {
            profiler.method_15396("post");
            VeilRenderSystem.renderPost(stage);
            profiler.method_15407();
        }
    }

    public static List<class_1921> getBlockLayers(ImmutableList<class_1921> base) {
        if (BLOCK_LAYERS == null || base.size() != BLOCK_LAYERS.size()) {
            ImmutableList.Builder blockLayers = ImmutableList.builder();
            blockLayers.addAll(base);
            if (CUSTOM_BLOCK_LAYERS != null) {
                blockLayers.addAll(CUSTOM_BLOCK_LAYERS);
            }
            BLOCK_LAYERS = blockLayers.build();
        }
        return BLOCK_LAYERS;
    }

    public static void setBlockLayers(Set<class_1921> blockLayers) {
        CUSTOM_BLOCK_LAYERS = blockLayers;
        BLOCK_LAYERS = null;
    }
}

